/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import com.sun.awt.AWTUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class DefaultDesktopManager
implements DesktopManager,
Serializable {
    static final String HAS_BEEN_ICONIFIED_PROPERTY = "wasIconOnce";
    static final int DEFAULT_DRAG_MODE = 0;
    static final int OUTLINE_DRAG_MODE = 1;
    static final int FASTER_DRAG_MODE = 2;
    int dragMode = 0;
    private transient Rectangle currentBounds = null;
    private transient Graphics desktopGraphics = null;
    private transient Rectangle desktopBounds = null;
    private transient Rectangle[] floatingItems = new Rectangle[0];
    private transient boolean didDrag;
    private transient Point currentLoc = null;

    public void openFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.getDesktopIcon().getParent() != null) {
            jInternalFrame.getDesktopIcon().getParent().add(jInternalFrame);
            this.removeIconFor(jInternalFrame);
        }
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (jDesktopPane == null) {
            return;
        }
        boolean bl = jInternalFrame.isSelected();
        Container container = jInternalFrame.getParent();
        JInternalFrame jInternalFrame2 = null;
        if (bl) {
            jInternalFrame2 = jDesktopPane.getNextFrame(jInternalFrame);
            try {
                jInternalFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (container != null) {
            container.remove(jInternalFrame);
            container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
        }
        this.removeIconFor(jInternalFrame);
        if (jInternalFrame.getNormalBounds() != null) {
            jInternalFrame.setNormalBounds(null);
        }
        if (this.wasIcon(jInternalFrame)) {
            this.setWasIcon(jInternalFrame, null);
        }
        if (jInternalFrame2 != null) {
            try {
                jInternalFrame2.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else if (bl && jDesktopPane.getComponentCount() == 0) {
            jDesktopPane.requestFocus();
        }
    }

    public void maximizeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.isIcon()) {
            try {
                jInternalFrame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
            Rectangle rectangle = jInternalFrame.getParent().getBounds();
            this.setBoundsForFrame(jInternalFrame, 0, 0, rectangle.width, rectangle.height);
        }
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void minimizeFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.isIcon()) {
            this.iconifyFrame(jInternalFrame);
            return;
        }
        if (jInternalFrame.getNormalBounds() != null) {
            Rectangle rectangle = jInternalFrame.getNormalBounds();
            jInternalFrame.setNormalBounds(null);
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.setBoundsForFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void iconifyFrame(JInternalFrame jInternalFrame) {
        Serializable serializable;
        Container container = jInternalFrame.getParent();
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        boolean bl = jInternalFrame.isSelected();
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        if (!this.wasIcon(jInternalFrame)) {
            serializable = this.getBoundsForIconOf(jInternalFrame);
            jDesktopIcon.setBounds(serializable.x, serializable.y, serializable.width, serializable.height);
            this.setWasIcon(jInternalFrame, Boolean.TRUE);
        }
        if (container == null || jDesktopPane == null) {
            return;
        }
        if (container instanceof JLayeredPane) {
            serializable = (JLayeredPane)container;
            int n = JLayeredPane.getLayer(jInternalFrame);
            JLayeredPane.putLayer(jDesktopIcon, n);
        }
        if (!jInternalFrame.isMaximum()) {
            jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
        }
        jDesktopPane.setComponentOrderCheckingEnabled(false);
        container.remove(jInternalFrame);
        container.add(jDesktopIcon);
        jDesktopPane.setComponentOrderCheckingEnabled(true);
        container.repaint(jInternalFrame.getX(), jInternalFrame.getY(), jInternalFrame.getWidth(), jInternalFrame.getHeight());
        if (bl && jDesktopPane.selectFrame(true) == null) {
            jInternalFrame.restoreSubcomponentFocus();
        }
    }

    public void deiconifyFrame(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Container container = jDesktopIcon.getParent();
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (container != null && jDesktopPane != null) {
            container.add(jInternalFrame);
            if (jInternalFrame.isMaximum()) {
                Rectangle rectangle = container.getBounds();
                if (jInternalFrame.getWidth() != rectangle.width || jInternalFrame.getHeight() != rectangle.height) {
                    this.setBoundsForFrame(jInternalFrame, 0, 0, rectangle.width, rectangle.height);
                }
            }
            this.removeIconFor(jInternalFrame);
            if (jInternalFrame.isSelected()) {
                jInternalFrame.moveToFront();
                jInternalFrame.restoreSubcomponentFocus();
            } else {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        JInternalFrame jInternalFrame2;
        Container container = jInternalFrame.getParent();
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        JInternalFrame jInternalFrame3 = jInternalFrame2 = jDesktopPane == null ? null : jDesktopPane.getSelectedFrame();
        if (container == null && (container = jInternalFrame.getDesktopIcon().getParent()) == null) {
            return;
        }
        if (jInternalFrame2 == null) {
            if (jDesktopPane != null) {
                jDesktopPane.setSelectedFrame(jInternalFrame);
            }
        } else if (jInternalFrame2 != jInternalFrame) {
            if (jInternalFrame2.isSelected()) {
                try {
                    jInternalFrame2.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (jDesktopPane != null) {
                jDesktopPane.setSelectedFrame(jInternalFrame);
            }
        }
        jInternalFrame.moveToFront();
    }

    public void deactivateFrame(JInternalFrame jInternalFrame) {
        JInternalFrame jInternalFrame2;
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        JInternalFrame jInternalFrame3 = jInternalFrame2 = jDesktopPane == null ? null : jDesktopPane.getSelectedFrame();
        if (jInternalFrame2 == jInternalFrame) {
            jDesktopPane.setSelectedFrame(null);
        }
    }

    public void beginDraggingFrame(JComponent jComponent) {
        this.setupDragMode(jComponent);
        if (this.dragMode == 2) {
            Container container = jComponent.getParent();
            this.floatingItems = this.findFloatingItems(jComponent);
            this.currentBounds = jComponent.getBounds();
            if (container instanceof JComponent) {
                this.desktopBounds = ((JComponent)container).getVisibleRect();
            } else {
                this.desktopBounds = container.getBounds();
                this.desktopBounds.y = 0;
                this.desktopBounds.x = 0;
            }
            this.desktopGraphics = JComponent.safelyGetGraphics(container);
            ((JInternalFrame)jComponent).isDragging = true;
            this.didDrag = false;
        }
    }

    private void setupDragMode(JComponent jComponent) {
        JDesktopPane jDesktopPane = this.getDesktopPane(jComponent);
        Container container = jComponent.getParent();
        this.dragMode = 0;
        if (jDesktopPane != null) {
            String string = (String)jDesktopPane.getClientProperty("JDesktopPane.dragMode");
            Window window = SwingUtilities.getWindowAncestor(jComponent);
            this.dragMode = window != null && !AWTUtilities.isWindowOpaque(window) ? 0 : (string != null && string.equals("outline") ? 1 : (string != null && string.equals("faster") && jComponent instanceof JInternalFrame && ((JInternalFrame)jComponent).isOpaque() && (container == null || container.isOpaque()) ? 2 : (jDesktopPane.getDragMode() == 1 ? 1 : (jDesktopPane.getDragMode() == 0 && jComponent instanceof JInternalFrame && ((JInternalFrame)jComponent).isOpaque() ? 2 : 0))));
        }
    }

    public void dragFrame(JComponent jComponent, int n, int n2) {
        if (this.dragMode == 1) {
            JDesktopPane jDesktopPane = this.getDesktopPane(jComponent);
            if (jDesktopPane != null) {
                Graphics graphics = JComponent.safelyGetGraphics(jDesktopPane);
                graphics.setXORMode(Color.white);
                if (this.currentLoc != null) {
                    graphics.drawRect(this.currentLoc.x, this.currentLoc.y, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
                }
                graphics.drawRect(n, n2, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
                this.currentLoc = new Point(n, n2);
                graphics.dispose();
            }
        } else if (this.dragMode == 2) {
            this.dragFrameFaster(jComponent, n, n2);
        } else {
            this.setBoundsForFrame(jComponent, n, n2, jComponent.getWidth(), jComponent.getHeight());
        }
    }

    public void endDraggingFrame(JComponent jComponent) {
        if (this.dragMode == 1 && this.currentLoc != null) {
            this.setBoundsForFrame(jComponent, this.currentLoc.x, this.currentLoc.y, jComponent.getWidth(), jComponent.getHeight());
            this.currentLoc = null;
        } else if (this.dragMode == 2) {
            this.currentBounds = null;
            if (this.desktopGraphics != null) {
                this.desktopGraphics.dispose();
                this.desktopGraphics = null;
            }
            this.desktopBounds = null;
            ((JInternalFrame)jComponent).isDragging = false;
        }
    }

    public void beginResizingFrame(JComponent jComponent, int n) {
        this.setupDragMode(jComponent);
    }

    public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        if (this.dragMode == 0 || this.dragMode == 2) {
            this.setBoundsForFrame(jComponent, n, n2, n3, n4);
        } else {
            JDesktopPane jDesktopPane = this.getDesktopPane(jComponent);
            if (jDesktopPane != null) {
                Graphics graphics = JComponent.safelyGetGraphics(jDesktopPane);
                graphics.setXORMode(Color.white);
                if (this.currentBounds != null) {
                    graphics.drawRect(this.currentBounds.x, this.currentBounds.y, this.currentBounds.width - 1, this.currentBounds.height - 1);
                }
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                this.currentBounds = new Rectangle(n, n2, n3, n4);
                graphics.setPaintMode();
                graphics.dispose();
            }
        }
    }

    public void endResizingFrame(JComponent jComponent) {
        if (this.dragMode == 1 && this.currentBounds != null) {
            this.setBoundsForFrame(jComponent, this.currentBounds.x, this.currentBounds.y, this.currentBounds.width, this.currentBounds.height);
            this.currentBounds = null;
        }
    }

    public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        boolean bl = jComponent.getWidth() != n3 || jComponent.getHeight() != n4;
        jComponent.setBounds(n, n2, n3, n4);
        if (bl) {
            jComponent.validate();
        }
    }

    protected void removeIconFor(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Container container = jDesktopIcon.getParent();
        if (container != null) {
            container.remove(jDesktopIcon);
            container.repaint(jDesktopIcon.getX(), jDesktopIcon.getY(), jDesktopIcon.getWidth(), jDesktopIcon.getHeight());
        }
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame jInternalFrame) {
        JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
        Dimension dimension = jDesktopIcon.getPreferredSize();
        Container container = jInternalFrame.getParent();
        if (container == null) {
            container = jInternalFrame.getDesktopIcon().getParent();
        }
        if (container == null) {
            return new Rectangle(0, 0, dimension.width, dimension.height);
        }
        Rectangle rectangle = container.getBounds();
        Component[] componentArray = container.getComponents();
        Rectangle rectangle2 = null;
        Component component = null;
        int n = 0;
        int n2 = rectangle.height - dimension.height;
        int n3 = dimension.width;
        int n4 = dimension.height;
        boolean bl = false;
        while (!bl) {
            rectangle2 = new Rectangle(n, n2, n3, n4);
            bl = true;
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] instanceof JInternalFrame) {
                    component = ((JInternalFrame)componentArray[i]).getDesktopIcon();
                } else {
                    if (!(componentArray[i] instanceof JInternalFrame.JDesktopIcon)) continue;
                    component = (JInternalFrame.JDesktopIcon)componentArray[i];
                }
                if (component.equals(jDesktopIcon) || !rectangle2.intersects(component.getBounds())) continue;
                bl = false;
                break;
            }
            if (component == null) {
                return rectangle2;
            }
            if ((n += component.getBounds().width) + n3 <= rectangle.width) continue;
            n = 0;
            n2 -= n4;
        }
        return rectangle2;
    }

    protected void setPreviousBounds(JInternalFrame jInternalFrame, Rectangle rectangle) {
        jInternalFrame.setNormalBounds(rectangle);
    }

    protected Rectangle getPreviousBounds(JInternalFrame jInternalFrame) {
        return jInternalFrame.getNormalBounds();
    }

    protected void setWasIcon(JInternalFrame jInternalFrame, Boolean bl) {
        if (bl != null) {
            jInternalFrame.putClientProperty(HAS_BEEN_ICONIFIED_PROPERTY, bl);
        }
    }

    protected boolean wasIcon(JInternalFrame jInternalFrame) {
        return jInternalFrame.getClientProperty(HAS_BEEN_ICONIFIED_PROPERTY) == Boolean.TRUE;
    }

    JDesktopPane getDesktopPane(JComponent jComponent) {
        JDesktopPane jDesktopPane = null;
        Container container = jComponent.getParent();
        while (jDesktopPane == null) {
            if (container instanceof JDesktopPane) {
                jDesktopPane = (JDesktopPane)container;
                continue;
            }
            if (container == null) break;
            container = container.getParent();
        }
        return jDesktopPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dragFrameFaster(JComponent jComponent, int n, int n2) {
        Rectangle rectangle = new Rectangle(this.currentBounds.x, this.currentBounds.y, this.currentBounds.width, this.currentBounds.height);
        this.currentBounds.x = n;
        this.currentBounds.y = n2;
        if (this.didDrag) {
            this.emergencyCleanup(jComponent);
        } else {
            this.didDrag = true;
            ((JInternalFrame)jComponent).danger = false;
        }
        boolean bl = this.isFloaterCollision(rectangle, this.currentBounds);
        JComponent jComponent2 = (JComponent)jComponent.getParent();
        Rectangle rectangle2 = rectangle.intersection(this.desktopBounds);
        RepaintManager repaintManager = RepaintManager.currentManager(jComponent);
        repaintManager.beginPaint();
        try {
            int n3;
            if (!bl) {
                repaintManager.copyArea(jComponent2, this.desktopGraphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, n - rectangle.x, n2 - rectangle.y, true);
            }
            jComponent.setBounds(this.currentBounds);
            if (bl) {
                ((JInternalFrame)jComponent).isDragging = false;
                jComponent2.paintImmediately(this.currentBounds);
                ((JInternalFrame)jComponent).isDragging = true;
            }
            repaintManager.markCompletelyClean(jComponent2);
            repaintManager.markCompletelyClean(jComponent);
            Rectangle[] rectangleArray = null;
            rectangleArray = rectangle.intersects(this.currentBounds) ? SwingUtilities.computeDifference(rectangle, this.currentBounds) : new Rectangle[]{rectangle};
            for (n3 = 0; n3 < rectangleArray.length; ++n3) {
                jComponent2.paintImmediately(rectangleArray[n3]);
            }
            if (!rectangle2.equals(rectangle)) {
                rectangleArray = SwingUtilities.computeDifference(rectangle, this.desktopBounds);
                for (n3 = 0; n3 < rectangleArray.length; ++n3) {
                    rectangleArray[n3].x += n - rectangle.x;
                    rectangleArray[n3].y += n2 - rectangle.y;
                    ((JInternalFrame)jComponent).isDragging = false;
                    jComponent2.paintImmediately(rectangleArray[n3]);
                    ((JInternalFrame)jComponent).isDragging = true;
                }
            }
        }
        finally {
            repaintManager.endPaint();
        }
    }

    private boolean isFloaterCollision(Rectangle rectangle, Rectangle rectangle2) {
        if (this.floatingItems.length == 0) {
            return false;
        }
        for (int i = 0; i < this.floatingItems.length; ++i) {
            boolean bl = rectangle.intersects(this.floatingItems[i]);
            if (bl) {
                return true;
            }
            boolean bl2 = rectangle2.intersects(this.floatingItems[i]);
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    private Rectangle[] findFloatingItems(JComponent jComponent) {
        Container container = jComponent.getParent();
        Component[] componentArray = container.getComponents();
        int n = 0;
        for (n = 0; n < componentArray.length && componentArray[n] != jComponent; ++n) {
        }
        Rectangle[] rectangleArray = new Rectangle[n];
        for (n = 0; n < rectangleArray.length; ++n) {
            rectangleArray[n] = componentArray[n].getBounds();
        }
        return rectangleArray;
    }

    private void emergencyCleanup(final JComponent jComponent) {
        if (((JInternalFrame)jComponent).danger) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((JInternalFrame)jComponent).isDragging = false;
                    jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
                    ((JInternalFrame)jComponent).isDragging = true;
                }
            });
            ((JInternalFrame)jComponent).danger = false;
        }
    }
}

