/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: ResultSet.cxx,v $
 * $Revision: 1.36.22.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_connectivity.hxx"
#include "java/sql/ResultSet.hxx"
#include "java/math/BigDecimal.hxx"
#include "java/sql/JStatement.hxx"
#include "java/sql/SQLWarning.hxx"
#include "java/sql/Array.hxx"
#include "java/sql/Ref.hxx"
#include "java/sql/Clob.hxx"
#include "java/sql/Timestamp.hxx"
#include "java/sql/Blob.hxx"
#include "java/sql/ResultSetMetaData.hxx"
#include "java/io/InputStream.hxx"
#include "java/io/Reader.hxx"
#include "java/tools.hxx"
#include <comphelper/property.hxx>
#include "connectivity/CommonTools.hxx"
#include <cppuhelper/typeprovider.hxx>
#include <comphelper/sequence.hxx>
#include <com/sun/star/beans/PropertyAttribute.hpp>
#include "TConnection.hxx"
#include <comphelper/types.hxx>
#include "connectivity/dbtools.hxx"
#include "connectivity/dbexception.hxx"
#include "resource/common_res.hrc"
#include "resource/sharedresources.hxx"

#include <rtl/logfile.hxx>
#include <string.h>

using namespace ::comphelper;

using namespace connectivity;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
//	using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;

IMPLEMENT_SERVICE_INFO(java_sql_ResultSet,"com.sun.star.sdbcx.JResultSet","com.sun.star.sdbc.ResultSet");
//**************************************************************
//************ Class: java.sql.ResultSet
//**************************************************************

jclass java_sql_ResultSet::theClass = 0;
java_sql_ResultSet::java_sql_ResultSet( JNIEnv * pEnv, jobject myObj, const java::sql::ConnectionLog& _rParentLogger,java_sql_Connection& _rConnection, java_sql_Statement_Base* pStmt)
    :java_sql_ResultSet_BASE(m_aMutex)
    ,java_lang_Object( pEnv, myObj )
    ,OPropertySetHelper(java_sql_ResultSet_BASE::rBHelper)
    ,m_aLogger( _rParentLogger, java::sql::ConnectionLog::RESULTSET )
    ,m_pConnection(&_rConnection)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::java_sql_ResultSet" );
	SDBThreadAttach::addRef();
	osl_incrementInterlockedCount(&m_refCount);
	if ( pStmt )
		m_xStatement = *pStmt;
	osl_decrementInterlockedCount(&m_refCount);
}
// -----------------------------------------------------------------------------

java_sql_ResultSet::~java_sql_ResultSet()
{
    if ( !java_sql_ResultSet_BASE::rBHelper.bDisposed && !java_sql_ResultSet_BASE::rBHelper.bInDispose )
	{
        // increment ref count to prevent double call of Dtor
        osl_incrementInterlockedCount( &m_refCount );
        dispose();
	}
}

jclass java_sql_ResultSet::getMyClass()
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getMyClass" );
	// die Klasse muss nur einmal geholt werden, daher statisch
	if( !theClass ){
        SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
		if( !t.pEnv ) return (jclass)0;
		jclass tempClass = t.pEnv->FindClass("java/sql/ResultSet"); OSL_ENSURE(tempClass,"Java : FindClass nicht erfolgreich!");
		jclass globClass = (jclass)t.pEnv->NewGlobalRef( tempClass );
		t.pEnv->DeleteLocalRef( tempClass );
		saveClassRef( globClass );
	}
	return theClass;
}

void java_sql_ResultSet::saveClassRef( jclass pClass )
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::saveClassRef" );
	if( pClass==0  )
		return;
	// der uebergebe Klassen-Handle ist schon global, daher einfach speichern
	theClass = pClass;
}
// -------------------------------------------------------------------------
void java_sql_ResultSet::disposing(void)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::disposing" );
	OPropertySetHelper::disposing();

	::osl::MutexGuard aGuard(m_aMutex);
	m_xMetaData		= NULL;
	if( object )
	{
        SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
		if( t.pEnv )
		{
			// temporaere Variable initialisieren
			static const char * cSignature = "()V";
			static const char * cMethodName = "close";
			// Java-Call absetzen
			static jmethodID mID = NULL;
			if ( !mID  )
				mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
			if( mID ){
				t.pEnv->CallVoidMethod( object, mID);
				ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			} //mID
			clearObject(*t.pEnv);
		}
	} //t.pEnv

	SDBThreadAttach::releaseRef();
}
// -------------------------------------------------------------------------
::com::sun::star::uno::Any SAL_CALL java_sql_ResultSet::queryInterface( const ::com::sun::star::uno::Type & rType ) throw(::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::queryInterface" );
	::com::sun::star::uno::Any aRet = OPropertySetHelper::queryInterface(rType);
	return aRet.hasValue() ? aRet : java_sql_ResultSet_BASE::queryInterface(rType);
}
// -------------------------------------------------------------------------
::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL java_sql_ResultSet::getTypes(  ) throw(::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getTypes" );
	::cppu::OTypeCollection aTypes(	::getCppuType( (const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XMultiPropertySet > *)0 ),
									::getCppuType( (const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XFastPropertySet > *)0 ),
									::getCppuType( (const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > *)0 ));

	return ::comphelper::concatSequences(aTypes.getTypes(),java_sql_ResultSet_BASE::getTypes());
}
// -------------------------------------------------------------------------

sal_Int32 SAL_CALL java_sql_ResultSet::findColumn( const ::rtl::OUString& columnName ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::findColumn" );
	jint out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){

		// temporaere Variable initialisieren
		static const char * cSignature = "(Ljava/lang/String;)I";
		static const char * cMethodName = "findColumn";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			// Parameter konvertieren
			jstring str = convertwchar_tToJavaString(t.pEnv,columnName);
			out = t.pEnv->CallIntMethod( object, mID, str );
			// und aufraeumen
			t.pEnv->DeleteLocalRef(str);

			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
// -------------------------------------------------------------------------


Reference< ::com::sun::star::io::XInputStream > SAL_CALL java_sql_ResultSet::getBinaryStream( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getBinaryStream" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/io/InputStream;";
		static const char * cMethodName = "getBinaryStream";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out==0 ? 0 : new java_io_InputStream( t.pEnv, out );
}
// -------------------------------------------------------------------------
Reference< ::com::sun::star::io::XInputStream > SAL_CALL java_sql_ResultSet::getCharacterStream( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getCharacterStream" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/io/Reader;";
		static const char * cMethodName = "getCharacterStream";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out==0 ? 0 : new java_io_Reader( t.pEnv, out );
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL java_sql_ResultSet::getBoolean( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getBoolean" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Z";
		static const char * cMethodName = "getBoolean";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID, columnIndex );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

sal_Int8 SAL_CALL java_sql_ResultSet::getByte( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getByte" );
	jbyte out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)B";
		static const char * cMethodName = "getByte";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallByteMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

Sequence< sal_Int8 > SAL_CALL java_sql_ResultSet::getBytes( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getBytes" );
        Sequence< sal_Int8 > aSeq;
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		static const char * cSignature = "(I)[B";
		static const char * cMethodName = "getBytes";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jbyteArray out = (jbyteArray)t.pEnv->CallObjectMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			if (out)
			{
				jboolean p = sal_False;
				aSeq.realloc(t.pEnv->GetArrayLength(out));
				memcpy(aSeq.getArray(),t.pEnv->GetByteArrayElements(out,&p),aSeq.getLength());
				t.pEnv->DeleteLocalRef(out);
			}
			// und aufraeumen
		} //mID
	} //t.pEnv
	return aSeq;
}
// -------------------------------------------------------------------------

::com::sun::star::util::Date SAL_CALL java_sql_ResultSet::getDate( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getDate" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/sql/Date;";
		static const char * cMethodName = "getDate";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID, columnIndex );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out ? static_cast <com::sun::star::util::Date> (java_sql_Date( t.pEnv, out )) : ::com::sun::star::util::Date();
}
// -------------------------------------------------------------------------

double SAL_CALL java_sql_ResultSet::getDouble( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getDouble" );
	jdouble out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)D";
		static const char * cMethodName = "getDouble";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallDoubleMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

float SAL_CALL java_sql_ResultSet::getFloat( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getFloat" );
	jfloat out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)F";
		static const char * cMethodName = "getFloat";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallFloatMethod( object, mID, columnIndex );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

sal_Int32 SAL_CALL java_sql_ResultSet::getInt( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getInt" );
	jint out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)I";
		static const char * cMethodName = "getInt";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID, columnIndex );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
// -------------------------------------------------------------------------

sal_Int32 SAL_CALL java_sql_ResultSet::getRow(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getRow" );
	jint out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "()I";
		static const char * cMethodName = "getRow";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
// -------------------------------------------------------------------------

sal_Int64 SAL_CALL java_sql_ResultSet::getLong( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getLong" );
	jlong out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)J";
		static const char * cMethodName = "getLong";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallLongMethod( object, mID, columnIndex );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XResultSetMetaData > SAL_CALL java_sql_ResultSet::getMetaData(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getMetaData" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )

	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Ljava/sql/ResultSetMetaData;";
		static const char * cMethodName = "getMetaData";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}

	return out==0 ? 0 : new java_sql_ResultSetMetaData( t.pEnv, out, m_aLogger,*m_pConnection );
}
// -------------------------------------------------------------------------
Reference< XArray > SAL_CALL java_sql_ResultSet::getArray( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getArray" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/sql/Array;";
		static const char * cMethodName = "getArray";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out==0 ? 0 : new java_sql_Array( t.pEnv, out );
}
// -------------------------------------------------------------------------

Reference< XClob > SAL_CALL java_sql_ResultSet::getClob( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getClob" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/sql/Clob;";
		static const char * cMethodName = "getClob";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out==0 ? 0 : new java_sql_Clob( t.pEnv, out );
}
// -------------------------------------------------------------------------
Reference< XBlob > SAL_CALL java_sql_ResultSet::getBlob( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getBlob" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/sql/Blob;";
		static const char * cMethodName = "getBlob";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out==0 ? 0 : new java_sql_Blob( t.pEnv, out );
}
// -------------------------------------------------------------------------

Reference< XRef > SAL_CALL java_sql_ResultSet::getRef( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getRef" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/sql/Ref;";
		static const char * cMethodName = "getRef";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out==0 ? 0 : new java_sql_Ref( t.pEnv, out );
}
// -------------------------------------------------------------------------

Any SAL_CALL java_sql_ResultSet::getObject( sal_Int32 columnIndex, const Reference< ::com::sun::star::container::XNameAccess >& typeMap ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getObject" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		jvalue args[2];
		// Parameter konvertieren
		args[0].i = (sal_Int32)columnIndex;
		args[1].l = convertTypeMapToJavaMap(t.pEnv,typeMap);
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/lang/Object;";
		static const char * cMethodName = "getObject";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethodA( object, mID, args);
			t.pEnv->DeleteLocalRef((jstring)args[1].l);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
    return out==0 ? Any() : Any();//new java_lang_Object( t.pEnv, out );
}
// -------------------------------------------------------------------------

sal_Int16 SAL_CALL java_sql_ResultSet::getShort( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getShort" );
	jshort out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)S";
		static const char * cMethodName = "getShort";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallShortMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	return (sal_Int16)out;
}
// -------------------------------------------------------------------------


::rtl::OUString SAL_CALL java_sql_ResultSet::getString( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getString" );
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	::rtl::OUString aStr;
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/lang/String;";
		static const char * cMethodName = "getString";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jstring out = (jstring)t.pEnv->CallObjectMethod( object, mID, columnIndex );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			aStr = JavaString2String(t.pEnv,out);
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return 	aStr;
}
// -------------------------------------------------------------------------


::com::sun::star::util::Time SAL_CALL java_sql_ResultSet::getTime( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getTime" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/sql/Time;";
		static const char * cMethodName = "getTime";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out ? static_cast <com::sun::star::util::Time> (java_sql_Time( t.pEnv, out )) : ::com::sun::star::util::Time();
}
// -------------------------------------------------------------------------


::com::sun::star::util::DateTime SAL_CALL java_sql_ResultSet::getTimestamp( sal_Int32 columnIndex ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getTimestamp" );
	jobject out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Ljava/sql/Timestamp;";
		static const char * cMethodName = "getTimestamp";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID, columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
			// und aufraeumen
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	return out ? static_cast <com::sun::star::util::DateTime> (java_sql_Timestamp( t.pEnv, out )) : ::com::sun::star::util::DateTime();
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL java_sql_ResultSet::isAfterLast(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::isAfterLast" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )

	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "isAfterLast";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_ResultSet::isFirst(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::isFirst" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )

	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "isFirst";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_ResultSet::isLast(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::isLast" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )

	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "isLast";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::beforeFirst(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::beforeFirst" );
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )

	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "isBeforeFirst";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
}
// -------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::afterLast(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::afterLast" );
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )

	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "afterLast";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::close(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::close" );
	dispose();
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL java_sql_ResultSet::first(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::first" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "first";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL java_sql_ResultSet::last(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::last" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "last";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_ResultSet::absolute( sal_Int32 row ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::absolute" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Z";
		static const char * cMethodName = "absolute";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID,row);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_ResultSet::relative( sal_Int32 row ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::relative" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)Z";
		static const char * cMethodName = "relative";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID,row);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_ResultSet::previous(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::previous" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )

	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "previous";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------
Reference< XInterface > SAL_CALL java_sql_ResultSet::getStatement(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getStatement" );
	return m_xStatement;
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL java_sql_ResultSet::rowDeleted(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::rowDeleted" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "rowDeleted";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_ResultSet::rowInserted(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::rowInserted" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "rowInserted";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL java_sql_ResultSet::rowUpdated(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::rowUpdated" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "rowUpdated";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL java_sql_ResultSet::isBeforeFirst(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::isBeforeFirst" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "isBeforeFirst";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL java_sql_ResultSet::next(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::next" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )

	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "next";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

sal_Bool SAL_CALL java_sql_ResultSet::wasNull(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::wasNull" );
	jboolean out(sal_False);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Z";
		static const char * cMethodName = "wasNull";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallBooleanMethod( object, mID );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	return out;
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::cancel(  ) throw(::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::cancel" );
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "cancel";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID );
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
}
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::clearWarnings(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::clearWarnings" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "clearWarnings";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------
::com::sun::star::uno::Any SAL_CALL java_sql_ResultSet::getWarnings(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getWarnings" );
	jobject out(NULL);
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Ljava/sql/SQLWarning;";
		static const char * cMethodName = "getWarnings";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallObjectMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
	// ACHTUNG: der Aufrufer wird Eigentuemer des zurueckgelieferten Zeigers !!!
	if( out )
	{
		java_sql_SQLWarning_BASE		warn_base( t.pEnv, out );
		return makeAny(
            static_cast< starsdbc::SQLException >(
                java_sql_SQLWarning(warn_base,*this)));
	}

	return ::com::sun::star::uno::Any();
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::insertRow(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::insertRow" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "insertRow";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::updateRow(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateRow" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "updateRow";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::deleteRow(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::deleteRow" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "deleteRow";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::cancelRowUpdates(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::cancelRowUpdates" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "cancelRowUpdates";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::moveToInsertRow(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::moveToInsertRow" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "moveToInsertRow";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::moveToCurrentRow(  ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::moveToCurrentRow" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "moveToCurrentRow";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateNull( sal_Int32 columnIndex ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateNull" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)V";
		static const char * cMethodName = "updateNull";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,columnIndex);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateBoolean( sal_Int32 columnIndex, sal_Bool x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateBoolean" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(IZ)V";
		static const char * cMethodName = "updateBoolean";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,columnIndex,x);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::updateByte( sal_Int32 columnIndex, sal_Int8 x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateByte" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(IB)V";
		static const char * cMethodName = "updateByte";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,columnIndex,x);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateShort( sal_Int32 columnIndex, sal_Int16 x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateShort" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(IS)V";
		static const char * cMethodName = "updateShort";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,columnIndex,x);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::updateInt( sal_Int32 columnIndex, sal_Int32 x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateInt" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(II)V";
		static const char * cMethodName = "updateInt";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,columnIndex,x);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::updateLong( sal_Int32 columnIndex, sal_Int64 x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateLong" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(IJ)V";
		static const char * cMethodName = "updateLong";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,columnIndex,x);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

// -----------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::updateFloat( sal_Int32 columnIndex, float x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateFloat" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(IF)V";
		static const char * cMethodName = "updateFloat";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,columnIndex,x);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateDouble( sal_Int32 columnIndex, double x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateDouble" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(ID)V";
		static const char * cMethodName = "updateDouble";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,columnIndex,x);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateString( sal_Int32 columnIndex, const ::rtl::OUString& x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateString" );
	SDBThreadAttach t;
	if( t.pEnv )
	{

		// temporaere Variable initialisieren
		static const char * cSignature = "(ILjava/lang/String;)V";
		static const char * cMethodName = "updateString";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID )
		{
			// Parameter konvertieren
			jstring str = convertwchar_tToJavaString(t.pEnv,x);
			t.pEnv->CallVoidMethod( object, mID,columnIndex,str);
			t.pEnv->DeleteLocalRef(str);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateBytes( sal_Int32 columnIndex, const ::com::sun::star::uno::Sequence< sal_Int8 >& x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateBytes" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I[B)V";
		static const char * cMethodName = "updateBytes";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID )
		{
			jbyteArray aArray = t.pEnv->NewByteArray(x.getLength());
			t.pEnv->SetByteArrayRegion(aArray,0,x.getLength(),(jbyte*)x.getConstArray());
			// Parameter konvertieren
			t.pEnv->CallVoidMethod( object, mID,columnIndex,aArray);
			t.pEnv->DeleteLocalRef(aArray);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateDate( sal_Int32 columnIndex, const ::com::sun::star::util::Date& x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateDate" );
	SDBThreadAttach t;
	if( t.pEnv )
	{

		// temporaere Variable initialisieren
		static const char * cSignature = "(ILjava/sql/Date;)V";
		static const char * cMethodName = "updateDate";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID )
		{
			jvalue args[1];
			// Parameter konvertieren
			java_sql_Date aD(x);
			args[0].l = aD.getJavaObject();
			t.pEnv->CallVoidMethod( object, mID,columnIndex,args[0].l);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateTime( sal_Int32 columnIndex, const ::com::sun::star::util::Time& x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateTime" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(ILjava/sql/Time;)V";
		static const char * cMethodName = "updateTime";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID )
		{
			jvalue args[1];
			// Parameter konvertieren
			java_sql_Time aD(x);
			args[0].l = aD.getJavaObject();
			t.pEnv->CallVoidMethod( object, mID,columnIndex,args[0].l);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateTimestamp( sal_Int32 columnIndex, const ::com::sun::star::util::DateTime& x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateTimestamp" );
	SDBThreadAttach t;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "(I;Ljava/sql/Timestamp;)V";
		static const char * cMethodName = "updateTimestamp";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID )
		{
			jvalue args[1];
			java_sql_Timestamp aD(x);
			// Parameter konvertieren
			args[0].l = aD.getJavaObject();
			t.pEnv->CallVoidMethod( object, mID,columnIndex,args[0].l);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		}
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateBinaryStream( sal_Int32 /*columnIndex*/, const ::com::sun::star::uno::Reference< ::com::sun::star::io::XInputStream >& /*x*/, sal_Int32 /*length*/ ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateBinaryStream" );
    ::dbtools::throwFeatureNotImplementedException( "XParameters::updateBinaryStream", *this );
}
// -------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::updateCharacterStream( sal_Int32 /*columnIndex*/, const ::com::sun::star::uno::Reference< ::com::sun::star::io::XInputStream >& /*x*/, sal_Int32 /*length*/ ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateCharacterStream" );
    ::dbtools::throwFeatureNotImplementedException( "XRowUpdate::updateCharacterStream", *this );
}
// -------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::updateObject( sal_Int32 columnIndex, const ::com::sun::star::uno::Any& x ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateObject" );
	if(!::dbtools::implUpdateObject(this,columnIndex,x))
	{
        ::connectivity::SharedResources aResources;
        const ::rtl::OUString sError( aResources.getResourceStringWithSubstitution(
                STR_UNKNOWN_COLUMN_TYPE,
                "$position$", ::rtl::OUString::valueOf(columnIndex)
             ) );
		::dbtools::throwGenericSQLException(sError,*this);
	}
}
// -------------------------------------------------------------------------

void SAL_CALL java_sql_ResultSet::updateNumericObject( sal_Int32 columnIndex, const ::com::sun::star::uno::Any& x, sal_Int32 scale ) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::updateNumericObject" );
	//	OSL_ENSURE(0,"java_sql_ResultSet::updateNumericObject: NYI");
    try
    {
        SDBThreadAttach t;
	    if( t.pEnv )
	    {

		    // temporaere Variable initialisieren
		    static const char * cSignature = "(ILjava/lang/Object;I)V";
		    static const char * cMethodName = "updateObject";
		    // Java-Call absetzen
		    static jmethodID mID = NULL;
		    if ( !mID  )
			    mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		    if( mID )
		    {
			    // Parameter konvertieren
                double nTemp = 0.0;
                ::std::auto_ptr<java_math_BigDecimal> pBigDecimal;
                if ( x >>= nTemp)
                {
                    pBigDecimal.reset(new java_math_BigDecimal(nTemp));
                }
                else
                    pBigDecimal.reset(new java_math_BigDecimal(::comphelper::getString(x)));
                    //obj = convertwchar_tToJavaString(t.pEnv,::comphelper::getString(x));
                t.pEnv->CallVoidMethod( object, mID, columnIndex,pBigDecimal->getJavaObject(),scale);
                ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		    }
	    }
    }
    catch(Exception)
    {
	    updateObject( columnIndex,x);
    }
}
//------------------------------------------------------------------------------
sal_Int32 java_sql_ResultSet::getResultSetConcurrency() const throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getResultSetConcurrency" );
	jint out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "()I";
		static const char * cMethodName = "getConcurrency";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			// special case here most JDBC 1.x doesn't support this feature so we just clear the exception when they occured
			isExceptionOccured(t.pEnv,sal_True);

		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
// -------------------------------------------------------------------------
//------------------------------------------------------------------------------
sal_Int32 java_sql_ResultSet::getResultSetType() const throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getResultSetType" );
	jint out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "()I";
		static const char * cMethodName = "getType";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			// special case here most JDBC 1.x doesn't support this feature so we just clear the exception when they occured
			isExceptionOccured(t.pEnv,sal_True);

		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
//------------------------------------------------------------------------------
sal_Int32 java_sql_ResultSet::getFetchDirection() const	throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getFetchDirection" );
	jint out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "()I";
		static const char * cMethodName = "getFetchDirection";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			// special case here most JDBC 1.x doesn't support this feature so we just clear the exception when they occured
			isExceptionOccured(t.pEnv,sal_True);

		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
//------------------------------------------------------------------------------
sal_Int32 java_sql_ResultSet::getFetchSize() const throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getFetchSize" );
	jint out(0);
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "()I";
		static const char * cMethodName = "getFetchSize";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			out = t.pEnv->CallIntMethod( object, mID);
			// special case here most JDBC 1.x doesn't support this feature so we just clear the exception when they occured
			isExceptionOccured(t.pEnv,sal_True);

		} //mID
	} //t.pEnv
	return (sal_Int32)out;
}
//------------------------------------------------------------------------------
::rtl::OUString java_sql_ResultSet::getCursorName() const throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getCursorName" );
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	::rtl::OUString aStr;
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()Ljava/lang/String;";
		static const char * cMethodName = "getCursorName";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			jstring out = (jstring)t.pEnv->CallObjectMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *const_cast< java_sql_ResultSet* >( this ) );
			aStr = JavaString2String(t.pEnv,out);
		}
	}

	return aStr;
}

//------------------------------------------------------------------------------
void java_sql_ResultSet::setFetchDirection(sal_Int32 _par0) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::setFetchDirection" );
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)V";
		static const char * cMethodName = "setFetchDirection";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,_par0);
			// special case here most JDBC 1.x doesn't support this feature so we just clear the exception when they occured
			isExceptionOccured(t.pEnv,sal_True);

		} //mID
	} //t.pEnv

}
//------------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::refreshRow(  ) throw(SQLException, RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::refreshRow" );
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv )
	{
		// temporaere Variable initialisieren
		static const char * cSignature = "()V";
		static const char * cMethodName = "refreshRow";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID);
			ThrowLoggedSQLException( m_aLogger, t.pEnv, *this );
		} //mID
	} //t.pEnv
}
//------------------------------------------------------------------------------
void java_sql_ResultSet::setFetchSize(sal_Int32 _par0) throw(::com::sun::star::sdbc::SQLException, ::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::setFetchSize" );
    SDBThreadAttach t; OSL_ENSURE(t.pEnv,"Java Enviroment geloescht worden!");
	if( t.pEnv ){
		// temporaere Variable initialisieren
		static const char * cSignature = "(I)V";
		static const char * cMethodName = "setFetchSize";
		// Java-Call absetzen
		static jmethodID mID = NULL;
		if ( !mID  )
			mID  = t.pEnv->GetMethodID( getMyClass(), cMethodName, cSignature );OSL_ENSURE(mID,"Unknown method id!");
		if( mID ){
			t.pEnv->CallVoidMethod( object, mID,_par0);
			// special case here most JDBC 1.x doesn't support this feature so we just clear the exception when they occured
			isExceptionOccured(t.pEnv,sal_True);
		} //mID
	} //t.pEnv

}
// -------------------------------------------------------------------------
::cppu::IPropertyArrayHelper* java_sql_ResultSet::createArrayHelper( ) const
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::createArrayHelper" );
	Sequence< Property > aProps(5);
    Property* pProperties = aProps.getArray();
	sal_Int32 nPos = 0;
	DECL_PROP1IMPL(CURSORNAME,			::rtl::OUString) PropertyAttribute::READONLY);
	DECL_PROP0(FETCHDIRECTION,		sal_Int32);
	DECL_PROP0(FETCHSIZE,			sal_Int32);
	DECL_PROP1IMPL(RESULTSETCONCURRENCY,sal_Int32) PropertyAttribute::READONLY);
	DECL_PROP1IMPL(RESULTSETTYPE,		sal_Int32) PropertyAttribute::READONLY);

	return new ::cppu::OPropertyArrayHelper(aProps);
}
// -------------------------------------------------------------------------
::cppu::IPropertyArrayHelper & java_sql_ResultSet::getInfoHelper()
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getInfoHelper" );
	return *const_cast<java_sql_ResultSet*>(this)->getArrayHelper();
}
// -------------------------------------------------------------------------
sal_Bool java_sql_ResultSet::convertFastPropertyValue(
							::com::sun::star::uno::Any & rConvertedValue,
							::com::sun::star::uno::Any & rOldValue,
							sal_Int32 nHandle,
							const ::com::sun::star::uno::Any& rValue )
								throw (::com::sun::star::lang::IllegalArgumentException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::convertFastPropertyValue" );
	sal_Bool bRet = sal_False;
	switch(nHandle)
	{
		case PROPERTY_ID_CURSORNAME:
		case PROPERTY_ID_RESULTSETCONCURRENCY:
		case PROPERTY_ID_RESULTSETTYPE:
			throw ::com::sun::star::lang::IllegalArgumentException();
		case PROPERTY_ID_FETCHDIRECTION:
			bRet = ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, getFetchDirection());
			break;
		case PROPERTY_ID_FETCHSIZE:
			bRet = ::comphelper::tryPropertyValue(rConvertedValue, rOldValue, rValue, getFetchSize());
		default:
			;
	}
	return bRet;
}

// -------------------------------------------------------------------------
void java_sql_ResultSet::setFastPropertyValue_NoBroadcast(
								sal_Int32 nHandle,
								const ::com::sun::star::uno::Any& rValue
												 )
												 throw (::com::sun::star::uno::Exception)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::setFastPropertyValue_NoBroadcast" );
	switch(nHandle)
	{
		case PROPERTY_ID_CURSORNAME:
		case PROPERTY_ID_RESULTSETCONCURRENCY:
		case PROPERTY_ID_RESULTSETTYPE:
			throw ::com::sun::star::uno::Exception();
		case PROPERTY_ID_FETCHDIRECTION:
			setFetchDirection(comphelper::getINT32(rValue));
			break;
		case PROPERTY_ID_FETCHSIZE:
			setFetchSize(comphelper::getINT32(rValue));
			break;
		default:
			;
	}
}
// -------------------------------------------------------------------------
void java_sql_ResultSet::getFastPropertyValue(
								::com::sun::star::uno::Any& rValue,
								sal_Int32 nHandle
									 ) const
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getFastPropertyValue" );
	try
	{
		switch(nHandle)
		{
			case PROPERTY_ID_CURSORNAME:
				rValue <<= getCursorName();
				break;
			case PROPERTY_ID_RESULTSETCONCURRENCY:
				rValue <<= getResultSetConcurrency();
				break;
			case PROPERTY_ID_RESULTSETTYPE:
				rValue <<= getResultSetType();
				break;
			case PROPERTY_ID_FETCHDIRECTION:
				rValue <<= getFetchDirection();
				break;
			case PROPERTY_ID_FETCHSIZE:
				rValue <<= getFetchSize();
				break;
		}
	}
	catch(Exception&)
	{
	}
}
// -----------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::acquire() throw()
{
	java_sql_ResultSet_BASE::acquire();
}
// -----------------------------------------------------------------------------
void SAL_CALL java_sql_ResultSet::release() throw()
{
	java_sql_ResultSet_BASE::release();
}
// -----------------------------------------------------------------------------
::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL java_sql_ResultSet::getPropertySetInfo(  ) throw(::com::sun::star::uno::RuntimeException)
{
    RTL_LOGFILE_CONTEXT_AUTHOR( aLogger, "jdbc", "Ocke.Janssen@sun.com", "java_sql_ResultSet::getPropertySetInfo" );
	return ::cppu::OPropertySetHelper::createPropertySetInfo(getInfoHelper());
}
// -----------------------------------------------------------------------------



