/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: unoobj.hxx,v $
 * $Revision: 1.13 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _UNOOBJ_HXX
#define _UNOOBJ_HXX

#include <com/sun/star/beans/XPropertyState.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/lang/XServiceInfo.hpp>
#include <com/sun/star/drawing/XShape.hpp>
#include <com/sun/star/document/XEventsSupplier.hpp>
#include <com/sun/star/document/XEventsSupplier.hpp>
#include <com/sun/star/lang/XTypeProvider.hpp>
#include <svx/svdpool.hxx>
#include <svx/unomaster.hxx>

#include <svx/unoipset.hxx>

#include <cppuhelper/implbase2.hxx>

class SdrObject;
class SdXImpressDocument;
class SdAnimationInfo;

class SdXShape : public SvxShapeMaster,
				 public ::com::sun::star::document::XEventsSupplier
{
	friend class SdUnoEventsAccess;

private:
	SvxShape* mpShape;
	const SvxItemPropertySet*	mpPropSet;
	const SfxItemPropertyMapEntry* mpMap;
	SdXImpressDocument* mpModel;

	void SetStyleSheet( const ::com::sun::star::uno::Any& rAny ) throw( ::com::sun::star::lang::IllegalArgumentException );
	::com::sun::star::uno::Any GetStyleSheet() const throw( ::com::sun::star::beans::UnknownPropertyException  );

	// Intern
	SdAnimationInfo* GetAnimationInfo( sal_Bool bCreate = sal_False ) const throw();
	sal_Bool IsPresObj() const throw();
	void SetPresObj( sal_Bool bPresObj ) throw();

	sal_Bool IsEmptyPresObj() const throw();
	void SetEmptyPresObj( sal_Bool bEmpty ) throw();

	sal_Bool IsMasterDepend() const throw();
	void SetMasterDepend( sal_Bool bDepend ) throw();

	SdrObject* GetSdrObject() const throw();

	com::sun::star::uno::Sequence< sal_Int8 >* mpImplementationId;

public:
	SdXShape() throw();
	SdXShape(SvxShape* pShape, SdXImpressDocument* pModel) throw();
	virtual ~SdXShape() throw();

	virtual sal_Bool queryAggregation( const com::sun::star::uno::Type & rType, com::sun::star::uno::Any& aAny );
	virtual void dispose();
	virtual void modelChanged( SdrModel* pNewModel );
	virtual void pageChanged( SdrPage* pNewPage );
	virtual void objectChanged( SdrObject* pNewObj );

	// XInterface
	virtual ::com::sun::star::uno::Any SAL_CALL queryAggregation( const ::com::sun::star::uno::Type & rType ) throw(::com::sun::star::uno::RuntimeException);
	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type & rType ) throw(::com::sun::star::uno::RuntimeException);
	virtual void SAL_CALL acquire() throw();
	virtual void SAL_CALL release() throw();

    // XServiceInfo
    virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames() throw(::com::sun::star::uno::RuntimeException);

	//XPropertySet
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL getPropertySetInfo(  ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setPropertyValue( const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Any& aValue ) throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::beans::PropertyVetoException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Any SAL_CALL getPropertyValue( const ::rtl::OUString& PropertyName ) throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException); 

    //XPropertyState
    virtual ::com::sun::star::beans::PropertyState SAL_CALL getPropertyState( const ::rtl::OUString& PropertyName ) throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setPropertyToDefault( const ::rtl::OUString& PropertyName ) throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Any SAL_CALL getPropertyDefault( const ::rtl::OUString& aPropertyName ) throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException);

	// XTypeProvider
    virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes(  ) throw(::com::sun::star::uno::RuntimeException);

	// XEventsSupplier
    virtual ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameReplace > SAL_CALL getEvents(  ) throw(::com::sun::star::uno::RuntimeException);

private:
	void setOldEffect( const com::sun::star::uno::Any& aValue );
	void setOldTextEffect( const com::sun::star::uno::Any& aValue );
	void setOldSpeed( const com::sun::star::uno::Any& aValue );
	void setOldDimColor( const com::sun::star::uno::Any& aValue );
	void setOldDimHide( const com::sun::star::uno::Any& aValue );
	void setOldDimPrevious( const com::sun::star::uno::Any& aValue );
	void setOldPresOrder( const com::sun::star::uno::Any& aValue );
	void updateOldSoundEffect( SdAnimationInfo* pInfo );

	void getOldEffect( com::sun::star::uno::Any& rValue ) const;
	void getOldTextEffect( com::sun::star::uno::Any& rValue ) const;
	void getOldSpeed( com::sun::star::uno::Any& rValue ) const;
	void getOldSoundFile( com::sun::star::uno::Any& rValue ) const;
	void getOldSoundOn( com::sun::star::uno::Any& rValue ) const;
	void getOldDimColor( com::sun::star::uno::Any& rValue ) const;
	void getOldDimHide( com::sun::star::uno::Any& rValue ) const;
	void getOldDimPrev( com::sun::star::uno::Any& rValue ) const;
	void getOldPresOrder( com::sun::star::uno::Any& rValue ) const;
};

struct SvEventDescription;
const SvEventDescription* ImplGetSupportedMacroItems();

#endif


