/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _HTMLKYWD_HXX
#define _HTMLKYWD_HXX

#include "sal/config.h"

#define OOO_STRING_SVTOOLS_HTML_doctype32 \
    "HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\""
#define OOO_STRING_SVTOOLS_HTML_doctype40 \
    "HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\""

// diese werden nur eingeschaltet
#define OOO_STRING_SVTOOLS_HTML_area "AREA"
#define OOO_STRING_SVTOOLS_HTML_base "BASE"
#define OOO_STRING_SVTOOLS_HTML_comment "!--"
#define OOO_STRING_SVTOOLS_HTML_doctype "!DOCTYPE"
#define OOO_STRING_SVTOOLS_HTML_embed "EMBED"
#define OOO_STRING_SVTOOLS_HTML_figureoverlay "OVERLAY"
#define OOO_STRING_SVTOOLS_HTML_horzrule "HR"
#define OOO_STRING_SVTOOLS_HTML_horztab "TAB"
#define OOO_STRING_SVTOOLS_HTML_image "IMG"
#define OOO_STRING_SVTOOLS_HTML_image2 "IMAGE"
#define OOO_STRING_SVTOOLS_HTML_input "INPUT"
#define OOO_STRING_SVTOOLS_HTML_isindex "ISINDEX"
#define OOO_STRING_SVTOOLS_HTML_linebreak "BR"
#define OOO_STRING_SVTOOLS_HTML_li "LI"
#define OOO_STRING_SVTOOLS_HTML_link "LINK"
#define OOO_STRING_SVTOOLS_HTML_meta "META"
#define OOO_STRING_SVTOOLS_HTML_nextid "NEXTID"
#define OOO_STRING_SVTOOLS_HTML_nobr "NOBR"
#define OOO_STRING_SVTOOLS_HTML_of "OF"
#define OOO_STRING_SVTOOLS_HTML_option "OPTION"
#define OOO_STRING_SVTOOLS_HTML_param "PARAM"
#define OOO_STRING_SVTOOLS_HTML_range "RANGE"
#define OOO_STRING_SVTOOLS_HTML_spacer "SPACER"
#define OOO_STRING_SVTOOLS_HTML_wbr "WBR"

// diese werden wieder abgeschaltet
#define OOO_STRING_SVTOOLS_HTML_abbreviation "ABBREV"
#define OOO_STRING_SVTOOLS_HTML_above "ABOVE"
#define OOO_STRING_SVTOOLS_HTML_acronym "ACRONYM"
#define OOO_STRING_SVTOOLS_HTML_address "ADDRESS"
#define OOO_STRING_SVTOOLS_HTML_anchor "A"
#define OOO_STRING_SVTOOLS_HTML_applet "APPLET"
#define OOO_STRING_SVTOOLS_HTML_array "ARRAY"
#define OOO_STRING_SVTOOLS_HTML_author "AU"
#define OOO_STRING_SVTOOLS_HTML_banner "BANNER"
#define OOO_STRING_SVTOOLS_HTML_bar "BAR"
#define OOO_STRING_SVTOOLS_HTML_basefont "BASEFONT"
#define OOO_STRING_SVTOOLS_HTML_below "BELOW"
#define OOO_STRING_SVTOOLS_HTML_bigprint "BIG"
#define OOO_STRING_SVTOOLS_HTML_blink "BLINK"
#define OOO_STRING_SVTOOLS_HTML_blockquote "BLOCKQUOTE"
#define OOO_STRING_SVTOOLS_HTML_blockquote30 "BQ"
#define OOO_STRING_SVTOOLS_HTML_body "BODY"
#define OOO_STRING_SVTOOLS_HTML_bold "B"
#define OOO_STRING_SVTOOLS_HTML_boldtext "BT"
#define OOO_STRING_SVTOOLS_HTML_box "BOX"
#define OOO_STRING_SVTOOLS_HTML_caption "CAPTION"
#define OOO_STRING_SVTOOLS_HTML_center "CENTER"
#define OOO_STRING_SVTOOLS_HTML_citiation "CITE"
#define OOO_STRING_SVTOOLS_HTML_code "CODE"
#define OOO_STRING_SVTOOLS_HTML_col "COL"
#define OOO_STRING_SVTOOLS_HTML_colgroup "COLGROUP"
#define OOO_STRING_SVTOOLS_HTML_credit "CREDIT"
#define OOO_STRING_SVTOOLS_HTML_dd "DD"
#define OOO_STRING_SVTOOLS_HTML_deflist "DL"
#define OOO_STRING_SVTOOLS_HTML_deletedtext "DEL"
#define OOO_STRING_SVTOOLS_HTML_dirlist "DIR"
#define OOO_STRING_SVTOOLS_HTML_division "DIV"
#define OOO_STRING_SVTOOLS_HTML_dot "DOT"
#define OOO_STRING_SVTOOLS_HTML_doubledot "DDOT"
#define OOO_STRING_SVTOOLS_HTML_dt "DT"
#define OOO_STRING_SVTOOLS_HTML_emphasis "EM"
#define OOO_STRING_SVTOOLS_HTML_figure "FIG"
#define OOO_STRING_SVTOOLS_HTML_font "FONT"
#define OOO_STRING_SVTOOLS_HTML_footnote "FN"
#define OOO_STRING_SVTOOLS_HTML_form "FORM"
#define OOO_STRING_SVTOOLS_HTML_frame "FRAME"
#define OOO_STRING_SVTOOLS_HTML_frameset "FRAMESET"
#define OOO_STRING_SVTOOLS_HTML_hat "HAT"
#define OOO_STRING_SVTOOLS_HTML_head1 "H1"
#define OOO_STRING_SVTOOLS_HTML_head2 "H2"
#define OOO_STRING_SVTOOLS_HTML_head3 "H3"
#define OOO_STRING_SVTOOLS_HTML_head4 "H4"
#define OOO_STRING_SVTOOLS_HTML_head5 "H5"
#define OOO_STRING_SVTOOLS_HTML_head6 "H6"
#define OOO_STRING_SVTOOLS_HTML_head "HEAD"
#define OOO_STRING_SVTOOLS_HTML_html "HTML"
#define OOO_STRING_SVTOOLS_HTML_iframe "IFRAME"
#define OOO_STRING_SVTOOLS_HTML_ilayer "ILAYER"
#define OOO_STRING_SVTOOLS_HTML_insertedtext "INS"
#define OOO_STRING_SVTOOLS_HTML_italic "I"
#define OOO_STRING_SVTOOLS_HTML_item "ITEM"
#define OOO_STRING_SVTOOLS_HTML_keyboard "KBD"
#define OOO_STRING_SVTOOLS_HTML_language "LANG"
#define OOO_STRING_SVTOOLS_HTML_layer "LAYER"
#define OOO_STRING_SVTOOLS_HTML_listheader "LH"
#define OOO_STRING_SVTOOLS_HTML_map "MAP"
#define OOO_STRING_SVTOOLS_HTML_math "MATH"
#define OOO_STRING_SVTOOLS_HTML_menulist "MENU"
#define OOO_STRING_SVTOOLS_HTML_multicol "MULTICOL"
#define OOO_STRING_SVTOOLS_HTML_noembed "NOEMBED"
#define OOO_STRING_SVTOOLS_HTML_noframe "NOFRAME"
#define OOO_STRING_SVTOOLS_HTML_noframes "NOFRAMES"
#define OOO_STRING_SVTOOLS_HTML_noscript "NOSCRIPT"
#define OOO_STRING_SVTOOLS_HTML_note "NOTE"
#define OOO_STRING_SVTOOLS_HTML_object "OBJECT"
#define OOO_STRING_SVTOOLS_HTML_orderlist "OL"
#define OOO_STRING_SVTOOLS_HTML_parabreak "P"
#define OOO_STRING_SVTOOLS_HTML_person "PERSON"
#define OOO_STRING_SVTOOLS_HTML_plaintext "T"
#define OOO_STRING_SVTOOLS_HTML_preformtxt "PRE"
#define OOO_STRING_SVTOOLS_HTML_root "ROOT"
#define OOO_STRING_SVTOOLS_HTML_row "ROW"
#define OOO_STRING_SVTOOLS_HTML_sample "SAMP"
#define OOO_STRING_SVTOOLS_HTML_script "SCRIPT"
#define OOO_STRING_SVTOOLS_HTML_select "SELECT"
#define OOO_STRING_SVTOOLS_HTML_shortquote "Q"
#define OOO_STRING_SVTOOLS_HTML_smallprint "SMALL"
#define OOO_STRING_SVTOOLS_HTML_span "SPAN"
#define OOO_STRING_SVTOOLS_HTML_squareroot "AQRT"
#define OOO_STRING_SVTOOLS_HTML_strikethrough "S"
#define OOO_STRING_SVTOOLS_HTML_strong "STRONG"
#define OOO_STRING_SVTOOLS_HTML_style "STYLE"
#define OOO_STRING_SVTOOLS_HTML_subscript "SUB"
#define OOO_STRING_SVTOOLS_HTML_superscript "SUP"
#define OOO_STRING_SVTOOLS_HTML_table "TABLE"
#define OOO_STRING_SVTOOLS_HTML_tablerow "TR"
#define OOO_STRING_SVTOOLS_HTML_tabledata "TD"
#define OOO_STRING_SVTOOLS_HTML_tableheader "TH"
#define OOO_STRING_SVTOOLS_HTML_tbody "TBODY"
#define OOO_STRING_SVTOOLS_HTML_teletype "TT"
#define OOO_STRING_SVTOOLS_HTML_text "TEXT"
#define OOO_STRING_SVTOOLS_HTML_textarea "TEXTAREA"
#define OOO_STRING_SVTOOLS_HTML_textflow "TEXTFLOW"
#define OOO_STRING_SVTOOLS_HTML_tfoot "TFOOT"
#define OOO_STRING_SVTOOLS_HTML_thead "THEAD"
#define OOO_STRING_SVTOOLS_HTML_tilde "TILDE"
#define OOO_STRING_SVTOOLS_HTML_title "TITLE"
#define OOO_STRING_SVTOOLS_HTML_underline "U"
#define OOO_STRING_SVTOOLS_HTML_unorderlist "UL"
#define OOO_STRING_SVTOOLS_HTML_variable "VAR"
#define OOO_STRING_SVTOOLS_HTML_vector "VEC"

// obsolete features
#define OOO_STRING_SVTOOLS_HTML_xmp "XMP"
#define OOO_STRING_SVTOOLS_HTML_listing "LISTING"

// proposed features
#define OOO_STRING_SVTOOLS_HTML_definstance "DFN"
#define OOO_STRING_SVTOOLS_HTML_strike "STRIKE"
#define OOO_STRING_SVTOOLS_HTML_bgsound "BGSOUND"
#define OOO_STRING_SVTOOLS_HTML_comment2 "COMMENT"
#define OOO_STRING_SVTOOLS_HTML_marquee "MARQUEE"
#define OOO_STRING_SVTOOLS_HTML_plaintext2 "PLAINTEXT"
#define OOO_STRING_SVTOOLS_HTML_sdfield "SDFIELD"

// die Namen fuer alle Zeichen
#define OOO_STRING_SVTOOLS_HTML_C_lt "lt"
#define OOO_STRING_SVTOOLS_HTML_C_gt "gt"
#define OOO_STRING_SVTOOLS_HTML_C_amp "amp"
#define OOO_STRING_SVTOOLS_HTML_C_quot "quot"
#define OOO_STRING_SVTOOLS_HTML_C_Aacute "Aacute"
#define OOO_STRING_SVTOOLS_HTML_C_Agrave "Agrave"
#define OOO_STRING_SVTOOLS_HTML_C_Acirc "Acirc"
#define OOO_STRING_SVTOOLS_HTML_C_Atilde "Atilde"
#define OOO_STRING_SVTOOLS_HTML_C_Aring "Aring"
#define OOO_STRING_SVTOOLS_HTML_C_Auml "Auml"
#define OOO_STRING_SVTOOLS_HTML_C_AElig "AElig"
#define OOO_STRING_SVTOOLS_HTML_C_Ccedil "Ccedil"
#define OOO_STRING_SVTOOLS_HTML_C_Eacute "Eacute"
#define OOO_STRING_SVTOOLS_HTML_C_Egrave "Egrave"
#define OOO_STRING_SVTOOLS_HTML_C_Ecirc "Ecirc"
#define OOO_STRING_SVTOOLS_HTML_C_Euml "Euml"
#define OOO_STRING_SVTOOLS_HTML_C_Iacute "Iacute"
#define OOO_STRING_SVTOOLS_HTML_C_Igrave "Igrave"
#define OOO_STRING_SVTOOLS_HTML_C_Icirc "Icirc"
#define OOO_STRING_SVTOOLS_HTML_C_Iuml "Iuml"
#define OOO_STRING_SVTOOLS_HTML_C_ETH "ETH"
#define OOO_STRING_SVTOOLS_HTML_C_Ntilde "Ntilde"
#define OOO_STRING_SVTOOLS_HTML_C_Oacute "Oacute"
#define OOO_STRING_SVTOOLS_HTML_C_Ograve "Ograve"
#define OOO_STRING_SVTOOLS_HTML_C_Ocirc "Ocirc"
#define OOO_STRING_SVTOOLS_HTML_C_Otilde "Otilde"
#define OOO_STRING_SVTOOLS_HTML_C_Ouml "Ouml"
#define OOO_STRING_SVTOOLS_HTML_C_Oslash "Oslash"
#define OOO_STRING_SVTOOLS_HTML_C_Uacute "Uacute"
#define OOO_STRING_SVTOOLS_HTML_C_Ugrave "Ugrave"
#define OOO_STRING_SVTOOLS_HTML_C_Ucirc "Ucirc"
#define OOO_STRING_SVTOOLS_HTML_C_Uuml "Uuml"
#define OOO_STRING_SVTOOLS_HTML_C_Yacute "Yacute"
#define OOO_STRING_SVTOOLS_HTML_C_THORN "THORN"
#define OOO_STRING_SVTOOLS_HTML_C_szlig "szlig"
#define OOO_STRING_SVTOOLS_HTML_S_aacute "aacute"
#define OOO_STRING_SVTOOLS_HTML_S_agrave "agrave"
#define OOO_STRING_SVTOOLS_HTML_S_acirc "acirc"
#define OOO_STRING_SVTOOLS_HTML_S_atilde "atilde"
#define OOO_STRING_SVTOOLS_HTML_S_aring "aring"
#define OOO_STRING_SVTOOLS_HTML_S_auml "auml"
#define OOO_STRING_SVTOOLS_HTML_S_aelig "aelig"
#define OOO_STRING_SVTOOLS_HTML_S_ccedil "ccedil"
#define OOO_STRING_SVTOOLS_HTML_S_eacute "eacute"
#define OOO_STRING_SVTOOLS_HTML_S_egrave "egrave"
#define OOO_STRING_SVTOOLS_HTML_S_ecirc "ecirc"
#define OOO_STRING_SVTOOLS_HTML_S_euml "euml"
#define OOO_STRING_SVTOOLS_HTML_S_iacute "iacute"
#define OOO_STRING_SVTOOLS_HTML_S_igrave "igrave"
#define OOO_STRING_SVTOOLS_HTML_S_icirc "icirc"
#define OOO_STRING_SVTOOLS_HTML_S_iuml "iuml"
#define OOO_STRING_SVTOOLS_HTML_S_eth "eth"
#define OOO_STRING_SVTOOLS_HTML_S_ntilde "ntilde"
#define OOO_STRING_SVTOOLS_HTML_S_oacute "oacute"
#define OOO_STRING_SVTOOLS_HTML_S_ograve "ograve"
#define OOO_STRING_SVTOOLS_HTML_S_ocirc "ocirc"
#define OOO_STRING_SVTOOLS_HTML_S_otilde "otilde"
#define OOO_STRING_SVTOOLS_HTML_S_ouml "ouml"
#define OOO_STRING_SVTOOLS_HTML_S_oslash "oslash"
#define OOO_STRING_SVTOOLS_HTML_S_uacute "uacute"
#define OOO_STRING_SVTOOLS_HTML_S_ugrave "ugrave"
#define OOO_STRING_SVTOOLS_HTML_S_ucirc "ucirc"
#define OOO_STRING_SVTOOLS_HTML_S_uuml "uuml"
#define OOO_STRING_SVTOOLS_HTML_S_yacute "yacute"
#define OOO_STRING_SVTOOLS_HTML_S_thorn "thorn"
#define OOO_STRING_SVTOOLS_HTML_S_yuml "yuml"
#define OOO_STRING_SVTOOLS_HTML_S_acute "acute"
#define OOO_STRING_SVTOOLS_HTML_S_brvbar "brvbar"
#define OOO_STRING_SVTOOLS_HTML_S_cedil "cedil"
#define OOO_STRING_SVTOOLS_HTML_S_cent "cent"
#define OOO_STRING_SVTOOLS_HTML_S_copy "copy"
#define OOO_STRING_SVTOOLS_HTML_S_curren "curren"
#define OOO_STRING_SVTOOLS_HTML_S_deg "deg"
#define OOO_STRING_SVTOOLS_HTML_S_divide "divide"
#define OOO_STRING_SVTOOLS_HTML_S_frac12 "frac12"
#define OOO_STRING_SVTOOLS_HTML_S_frac14 "frac14"
#define OOO_STRING_SVTOOLS_HTML_S_frac34 "frac34"
#define OOO_STRING_SVTOOLS_HTML_S_iexcl "iexcl"
#define OOO_STRING_SVTOOLS_HTML_S_iquest "iquest"
#define OOO_STRING_SVTOOLS_HTML_S_laquo "laquo"
#define OOO_STRING_SVTOOLS_HTML_S_macr "macr"
#define OOO_STRING_SVTOOLS_HTML_S_micro "micro"
#define OOO_STRING_SVTOOLS_HTML_S_middot "middot"
#define OOO_STRING_SVTOOLS_HTML_S_nbsp "nbsp"
#define OOO_STRING_SVTOOLS_HTML_S_not "not"
#define OOO_STRING_SVTOOLS_HTML_S_ordf "ordf"
#define OOO_STRING_SVTOOLS_HTML_S_ordm "ordm"
#define OOO_STRING_SVTOOLS_HTML_S_para "para"
#define OOO_STRING_SVTOOLS_HTML_S_plusmn "plusmn"
#define OOO_STRING_SVTOOLS_HTML_S_pound "pound"
#define OOO_STRING_SVTOOLS_HTML_S_raquo "raquo"
#define OOO_STRING_SVTOOLS_HTML_S_reg "reg"
#define OOO_STRING_SVTOOLS_HTML_S_sect "sect"
#define OOO_STRING_SVTOOLS_HTML_S_shy "shy"
#define OOO_STRING_SVTOOLS_HTML_S_sup1 "sup1"
#define OOO_STRING_SVTOOLS_HTML_S_sup2 "sup2"
#define OOO_STRING_SVTOOLS_HTML_S_sup3 "sup3"
#define OOO_STRING_SVTOOLS_HTML_S_times "times"
#define OOO_STRING_SVTOOLS_HTML_S_uml "uml"
#define OOO_STRING_SVTOOLS_HTML_S_yen "yen"

// Netscape kennt noch ein paar in Grossbuchstaben ...
#define OOO_STRING_SVTOOLS_HTML_C_LT "LT"
#define OOO_STRING_SVTOOLS_HTML_C_GT "GT"
#define OOO_STRING_SVTOOLS_HTML_C_AMP "AMP"
#define OOO_STRING_SVTOOLS_HTML_C_QUOT "QUOT"
#define OOO_STRING_SVTOOLS_HTML_S_COPY "COPY"
#define OOO_STRING_SVTOOLS_HTML_S_REG "REG"

// HTML4
#define OOO_STRING_SVTOOLS_HTML_S_alefsym "alefsym"
#define OOO_STRING_SVTOOLS_HTML_S_Alpha "Alpha"
#define OOO_STRING_SVTOOLS_HTML_S_alpha "alpha"
#define OOO_STRING_SVTOOLS_HTML_S_and "and"
#define OOO_STRING_SVTOOLS_HTML_S_ang "ang"
#define OOO_STRING_SVTOOLS_HTML_S_asymp "asymp"
#define OOO_STRING_SVTOOLS_HTML_S_bdquo "bdquo"
#define OOO_STRING_SVTOOLS_HTML_S_Beta "Beta"
#define OOO_STRING_SVTOOLS_HTML_S_beta "beta"
#define OOO_STRING_SVTOOLS_HTML_S_bull "bull"
#define OOO_STRING_SVTOOLS_HTML_S_cap "cap"
#define OOO_STRING_SVTOOLS_HTML_S_chi "chi"
#define OOO_STRING_SVTOOLS_HTML_S_Chi "Chi"
#define OOO_STRING_SVTOOLS_HTML_S_circ "circ"
#define OOO_STRING_SVTOOLS_HTML_S_clubs "clubs"
#define OOO_STRING_SVTOOLS_HTML_S_cong "cong"
#define OOO_STRING_SVTOOLS_HTML_S_crarr "crarr"
#define OOO_STRING_SVTOOLS_HTML_S_cup "cup"
#define OOO_STRING_SVTOOLS_HTML_S_dagger "dagger"
#define OOO_STRING_SVTOOLS_HTML_S_Dagger "Dagger"
#define OOO_STRING_SVTOOLS_HTML_S_darr "darr"
#define OOO_STRING_SVTOOLS_HTML_S_dArr "dArr"
#define OOO_STRING_SVTOOLS_HTML_S_Delta "Delta"
#define OOO_STRING_SVTOOLS_HTML_S_delta "delta"
#define OOO_STRING_SVTOOLS_HTML_S_diams "diams"
#define OOO_STRING_SVTOOLS_HTML_S_empty "empty"
#define OOO_STRING_SVTOOLS_HTML_S_emsp "emsp"
#define OOO_STRING_SVTOOLS_HTML_S_ensp "ensp"
#define OOO_STRING_SVTOOLS_HTML_S_Epsilon "Epsilon"
#define OOO_STRING_SVTOOLS_HTML_S_epsilon "epsilon"
#define OOO_STRING_SVTOOLS_HTML_S_equiv "equiv"
#define OOO_STRING_SVTOOLS_HTML_S_Eta "Eta"
#define OOO_STRING_SVTOOLS_HTML_S_eta "eta"
#define OOO_STRING_SVTOOLS_HTML_S_euro "euro"
#define OOO_STRING_SVTOOLS_HTML_S_exist "exist"
#define OOO_STRING_SVTOOLS_HTML_S_fnof "fnof"
#define OOO_STRING_SVTOOLS_HTML_S_forall "forall"
#define OOO_STRING_SVTOOLS_HTML_S_frasl "frasl"
#define OOO_STRING_SVTOOLS_HTML_S_Gamma "Gamma"
#define OOO_STRING_SVTOOLS_HTML_S_gamma "gamma"
#define OOO_STRING_SVTOOLS_HTML_S_ge "ge"
#define OOO_STRING_SVTOOLS_HTML_S_harr "harr"
#define OOO_STRING_SVTOOLS_HTML_S_hArr "hArr"
#define OOO_STRING_SVTOOLS_HTML_S_hearts "hearts"
#define OOO_STRING_SVTOOLS_HTML_S_hellip "hellip"
#define OOO_STRING_SVTOOLS_HTML_S_image "image"
#define OOO_STRING_SVTOOLS_HTML_S_infin "infin"
#define OOO_STRING_SVTOOLS_HTML_S_int "int"
#define OOO_STRING_SVTOOLS_HTML_S_Iota "Iota"
#define OOO_STRING_SVTOOLS_HTML_S_iota "iota"
#define OOO_STRING_SVTOOLS_HTML_S_isin "isin"
#define OOO_STRING_SVTOOLS_HTML_S_Kappa "Kappa"
#define OOO_STRING_SVTOOLS_HTML_S_kappa "kappa"
#define OOO_STRING_SVTOOLS_HTML_S_Lambda "Lambda"
#define OOO_STRING_SVTOOLS_HTML_S_lambda "lambda"
#define OOO_STRING_SVTOOLS_HTML_S_lang "lang"
#define OOO_STRING_SVTOOLS_HTML_S_larr "larr"
#define OOO_STRING_SVTOOLS_HTML_S_lArr "lArr"
#define OOO_STRING_SVTOOLS_HTML_S_lceil "lceil"
#define OOO_STRING_SVTOOLS_HTML_S_ldquo "ldquo"
#define OOO_STRING_SVTOOLS_HTML_S_le "le"
#define OOO_STRING_SVTOOLS_HTML_S_lfloor "lfloor"
#define OOO_STRING_SVTOOLS_HTML_S_lowast "lowast"
#define OOO_STRING_SVTOOLS_HTML_S_loz "loz"
#define OOO_STRING_SVTOOLS_HTML_S_lrm "lrm"
#define OOO_STRING_SVTOOLS_HTML_S_lsaquo "lsaquo"
#define OOO_STRING_SVTOOLS_HTML_S_lsquo "lsquo"
#define OOO_STRING_SVTOOLS_HTML_S_mdash "mdash"
#define OOO_STRING_SVTOOLS_HTML_S_minus "minus"
#define OOO_STRING_SVTOOLS_HTML_S_Mu "Mu"
#define OOO_STRING_SVTOOLS_HTML_S_mu "mu"
#define OOO_STRING_SVTOOLS_HTML_S_nabla "nabla"
#define OOO_STRING_SVTOOLS_HTML_S_ndash "ndash"
#define OOO_STRING_SVTOOLS_HTML_S_ne "ne"
#define OOO_STRING_SVTOOLS_HTML_S_ni "ni"
#define OOO_STRING_SVTOOLS_HTML_S_notin "notin"
#define OOO_STRING_SVTOOLS_HTML_S_nsub "nsub"
#define OOO_STRING_SVTOOLS_HTML_S_Nu "Nu"
#define OOO_STRING_SVTOOLS_HTML_S_nu "nu"
#define OOO_STRING_SVTOOLS_HTML_S_OElig "OElig"
#define OOO_STRING_SVTOOLS_HTML_S_oelig "oelig"
#define OOO_STRING_SVTOOLS_HTML_S_oline "oline"
#define OOO_STRING_SVTOOLS_HTML_S_Omega "Omega"
#define OOO_STRING_SVTOOLS_HTML_S_omega "omega"
#define OOO_STRING_SVTOOLS_HTML_S_Omicron "Omicron"
#define OOO_STRING_SVTOOLS_HTML_S_omicron "omicron"
#define OOO_STRING_SVTOOLS_HTML_S_oplus "oplus"
#define OOO_STRING_SVTOOLS_HTML_S_or "or"
#define OOO_STRING_SVTOOLS_HTML_S_otimes "otimes"
#define OOO_STRING_SVTOOLS_HTML_S_part "part"
#define OOO_STRING_SVTOOLS_HTML_S_permil "permil"
#define OOO_STRING_SVTOOLS_HTML_S_perp "perp"
#define OOO_STRING_SVTOOLS_HTML_S_Phi "Phi"
#define OOO_STRING_SVTOOLS_HTML_S_phi "phi"
#define OOO_STRING_SVTOOLS_HTML_S_Pi "Pi"
#define OOO_STRING_SVTOOLS_HTML_S_pi "pi"
#define OOO_STRING_SVTOOLS_HTML_S_piv "piv"
#define OOO_STRING_SVTOOLS_HTML_S_prime "prime"
#define OOO_STRING_SVTOOLS_HTML_S_Prime "Prime"
#define OOO_STRING_SVTOOLS_HTML_S_prod "prod"
#define OOO_STRING_SVTOOLS_HTML_S_prop "prop"
#define OOO_STRING_SVTOOLS_HTML_S_Psi "Psi"
#define OOO_STRING_SVTOOLS_HTML_S_psi "psi"
#define OOO_STRING_SVTOOLS_HTML_S_radic "radic"
#define OOO_STRING_SVTOOLS_HTML_S_rang "rang"
#define OOO_STRING_SVTOOLS_HTML_S_rarr "rarr"
#define OOO_STRING_SVTOOLS_HTML_S_rArr "rArr"
#define OOO_STRING_SVTOOLS_HTML_S_rceil "rceil"
#define OOO_STRING_SVTOOLS_HTML_S_rdquo "rdquo"
#define OOO_STRING_SVTOOLS_HTML_S_real "real"
#define OOO_STRING_SVTOOLS_HTML_S_rfloor "rfloor"
#define OOO_STRING_SVTOOLS_HTML_S_Rho "Rho"
#define OOO_STRING_SVTOOLS_HTML_S_rho "rho"
#define OOO_STRING_SVTOOLS_HTML_S_rlm "rlm"
#define OOO_STRING_SVTOOLS_HTML_S_rsaquo "rsaquo"
#define OOO_STRING_SVTOOLS_HTML_S_rsquo "rsquo"
#define OOO_STRING_SVTOOLS_HTML_S_sbquo "sbquo"
#define OOO_STRING_SVTOOLS_HTML_S_Scaron "Scaron"
#define OOO_STRING_SVTOOLS_HTML_S_scaron "scaron"
#define OOO_STRING_SVTOOLS_HTML_S_sdot "sdot"
#define OOO_STRING_SVTOOLS_HTML_S_Sigma "Sigma"
#define OOO_STRING_SVTOOLS_HTML_S_sigma "sigma"
#define OOO_STRING_SVTOOLS_HTML_S_sigmaf "sigmaf"
#define OOO_STRING_SVTOOLS_HTML_S_sim "sim"
#define OOO_STRING_SVTOOLS_HTML_S_spades "spades"
#define OOO_STRING_SVTOOLS_HTML_S_sub "sub"
#define OOO_STRING_SVTOOLS_HTML_S_sube "sube"
#define OOO_STRING_SVTOOLS_HTML_S_sum "sum"
#define OOO_STRING_SVTOOLS_HTML_S_sup "sup"
#define OOO_STRING_SVTOOLS_HTML_S_supe "supe"
#define OOO_STRING_SVTOOLS_HTML_S_Tau "Tau"
#define OOO_STRING_SVTOOLS_HTML_S_tau "tau"
#define OOO_STRING_SVTOOLS_HTML_S_there4 "there4"
#define OOO_STRING_SVTOOLS_HTML_S_Theta "Theta"
#define OOO_STRING_SVTOOLS_HTML_S_theta "theta"
#define OOO_STRING_SVTOOLS_HTML_S_thetasym "thetasym"
#define OOO_STRING_SVTOOLS_HTML_S_thinsp "thinsp"
#define OOO_STRING_SVTOOLS_HTML_S_tilde "tilde"
#define OOO_STRING_SVTOOLS_HTML_S_trade "trade"
#define OOO_STRING_SVTOOLS_HTML_S_uarr "uarr"
#define OOO_STRING_SVTOOLS_HTML_S_uArr "uArr"
#define OOO_STRING_SVTOOLS_HTML_S_upsih "upsih"
#define OOO_STRING_SVTOOLS_HTML_S_Upsilon "Upsilon"
#define OOO_STRING_SVTOOLS_HTML_S_upsilon "upsilon"
#define OOO_STRING_SVTOOLS_HTML_S_weierp "weierp"
#define OOO_STRING_SVTOOLS_HTML_S_Xi "Xi"
#define OOO_STRING_SVTOOLS_HTML_S_xi "xi"
#define OOO_STRING_SVTOOLS_HTML_S_Yuml "Yuml"
#define OOO_STRING_SVTOOLS_HTML_S_Zeta "Zeta"
#define OOO_STRING_SVTOOLS_HTML_S_zeta "zeta"
#define OOO_STRING_SVTOOLS_HTML_S_zwj "zwj"
#define OOO_STRING_SVTOOLS_HTML_S_zwnj "zwnj"

// HTML Attribut-Token (=Optionen)

// Attribute ohne Wert
#define OOO_STRING_SVTOOLS_HTML_O_box "BOX"
#define OOO_STRING_SVTOOLS_HTML_O_checked "CHECKED"
#define OOO_STRING_SVTOOLS_HTML_O_compact "COMPACT"
#define OOO_STRING_SVTOOLS_HTML_O_continue "CONTINUE"
#define OOO_STRING_SVTOOLS_HTML_O_controls "CONTROLS"
#define OOO_STRING_SVTOOLS_HTML_O_declare "DECLARE"
#define OOO_STRING_SVTOOLS_HTML_O_disabled "DISABLED"
#define OOO_STRING_SVTOOLS_HTML_O_folded "FOLDED"
#define OOO_STRING_SVTOOLS_HTML_O_ismap "ISMAP"
#define OOO_STRING_SVTOOLS_HTML_O_mayscript "MAYSCRIPT"
#define OOO_STRING_SVTOOLS_HTML_O_multiple "MULTIPLE"
#define OOO_STRING_SVTOOLS_HTML_O_noflow "NOFLOW"
#define OOO_STRING_SVTOOLS_HTML_O_nohref "NOHREF"
#define OOO_STRING_SVTOOLS_HTML_O_noresize "NORESIZE"
#define OOO_STRING_SVTOOLS_HTML_O_noshade "NOSHADE"
#define OOO_STRING_SVTOOLS_HTML_O_nowrap "NOWRAP"
#define OOO_STRING_SVTOOLS_HTML_O_plain "PLAIN"
#define OOO_STRING_SVTOOLS_HTML_O_sdfixed "SDFIXED"
#define OOO_STRING_SVTOOLS_HTML_O_selected "SELECTED"
#define OOO_STRING_SVTOOLS_HTML_O_shapes "SHAPES"

// Attribute mit einem String als Wert
#define OOO_STRING_SVTOOLS_HTML_O_above "ABOVE"
#define OOO_STRING_SVTOOLS_HTML_O_accesskey "ACCESSKEY"
#define OOO_STRING_SVTOOLS_HTML_O_accept "ACCEPT"
#define OOO_STRING_SVTOOLS_HTML_O_add_date "ADD_DATE"
#define OOO_STRING_SVTOOLS_HTML_O_alt "ALT"
#define OOO_STRING_SVTOOLS_HTML_O_axes "AXES"
#define OOO_STRING_SVTOOLS_HTML_O_axis "AXIS"
#define OOO_STRING_SVTOOLS_HTML_O_below "BELOW"
#define OOO_STRING_SVTOOLS_HTML_O_char "CHAR"
#define OOO_STRING_SVTOOLS_HTML_O_class "CLASS"
#define OOO_STRING_SVTOOLS_HTML_O_clip "CLIP"
#define OOO_STRING_SVTOOLS_HTML_O_code "CODE"
#define OOO_STRING_SVTOOLS_HTML_O_codetype "CODETYPE"
#define OOO_STRING_SVTOOLS_HTML_O_colspec "COLSPEC"
#define OOO_STRING_SVTOOLS_HTML_O_content "CONTENT"
#define OOO_STRING_SVTOOLS_HTML_O_coords "COORDS"
#define OOO_STRING_SVTOOLS_HTML_O_dp "DP"
#define OOO_STRING_SVTOOLS_HTML_O_enctype "ENCTYPE"
#define OOO_STRING_SVTOOLS_HTML_O_error "ERROR"
#define OOO_STRING_SVTOOLS_HTML_O_face "FACE"
#define OOO_STRING_SVTOOLS_HTML_O_frameborder "FRAMEBORDER"
#define OOO_STRING_SVTOOLS_HTML_O_httpequiv "HTTP-EQUIV"
#define OOO_STRING_SVTOOLS_HTML_O_language "LANGUAGE"
#define OOO_STRING_SVTOOLS_HTML_O_last_modified "LAST_MODIFIED"
#define OOO_STRING_SVTOOLS_HTML_O_last_visit "LAST_VISIT"
#define OOO_STRING_SVTOOLS_HTML_O_md "MD"
#define OOO_STRING_SVTOOLS_HTML_O_n "N"
#define OOO_STRING_SVTOOLS_HTML_O_name "NAME"
#define OOO_STRING_SVTOOLS_HTML_O_notation "NOTATION"
#define OOO_STRING_SVTOOLS_HTML_O_prompt "PROMPT"
#define OOO_STRING_SVTOOLS_HTML_O_shape "SHAPE"
#define OOO_STRING_SVTOOLS_HTML_O_standby "STANDBY"
#define OOO_STRING_SVTOOLS_HTML_O_style "STYLE"
#define OOO_STRING_SVTOOLS_HTML_O_title "TITLE"
#define OOO_STRING_SVTOOLS_HTML_O_value "VALUE"
#define OOO_STRING_SVTOOLS_HTML_O_SDval "SDVAL"
#define OOO_STRING_SVTOOLS_HTML_O_SDnum "SDNUM"
#define OOO_STRING_SVTOOLS_HTML_O_sdlibrary "SDLIBRARY"
#define OOO_STRING_SVTOOLS_HTML_O_sdmodule "SDMODULE"
#define OOO_STRING_SVTOOLS_HTML_O_sdevent "SDEVENT-"
#define OOO_STRING_SVTOOLS_HTML_O_sdaddparam "SDADDPARAM-"

// Attribute mit einem SGML-Identifier als Wert
#define OOO_STRING_SVTOOLS_HTML_O_from "FROM"
#define OOO_STRING_SVTOOLS_HTML_O_id "ID"
#define OOO_STRING_SVTOOLS_HTML_O_target "TARGET"
#define OOO_STRING_SVTOOLS_HTML_O_to "TO"
#define OOO_STRING_SVTOOLS_HTML_O_until "UNTIL"

// Attribute mit einem URI als Wert
#define OOO_STRING_SVTOOLS_HTML_O_action "ACTION"
#define OOO_STRING_SVTOOLS_HTML_O_archive "ARCHIVE"
#define OOO_STRING_SVTOOLS_HTML_O_background "BACKGROUND"
#define OOO_STRING_SVTOOLS_HTML_O_classid "CLASSID"
#define OOO_STRING_SVTOOLS_HTML_O_codebase "CODEBASE"
#define OOO_STRING_SVTOOLS_HTML_O_data "DATA"
#define OOO_STRING_SVTOOLS_HTML_O_dynsrc "DYNSRC"
#define OOO_STRING_SVTOOLS_HTML_O_dynsync "DYNSYNC"
#define OOO_STRING_SVTOOLS_HTML_O_imagemap "IMAGEMAP"
#define OOO_STRING_SVTOOLS_HTML_O_href "HREF"
#define OOO_STRING_SVTOOLS_HTML_O_lowsrc "LOWSRC"
#define OOO_STRING_SVTOOLS_HTML_O_script "SCRIPT"
#define OOO_STRING_SVTOOLS_HTML_O_src "SRC"
#define OOO_STRING_SVTOOLS_HTML_O_usemap "USEMAP"

// Attribute mit Entity-Namen als Wert
#define OOO_STRING_SVTOOLS_HTML_O_dingbat "DINGBAT"
#define OOO_STRING_SVTOOLS_HTML_O_sym "SYM"

// Attribute mit einer Farbe als Wert (alle Netscape)
#define OOO_STRING_SVTOOLS_HTML_O_alink "ALINK"
#define OOO_STRING_SVTOOLS_HTML_O_bgcolor "BGCOLOR"
#define OOO_STRING_SVTOOLS_HTML_O_bordercolor "BORDERCOLOR"
#define OOO_STRING_SVTOOLS_HTML_O_bordercolorlight "BORDERCOLORLIGHT"
#define OOO_STRING_SVTOOLS_HTML_O_bordercolordark "BORDERCOLORDARK"
#define OOO_STRING_SVTOOLS_HTML_O_color "COLOR"
#define OOO_STRING_SVTOOLS_HTML_O_link "LINK"
#define OOO_STRING_SVTOOLS_HTML_O_text "TEXT"
#define OOO_STRING_SVTOOLS_HTML_O_vlink "VLINK"

// Attribute mit einem numerischen Wert
#define OOO_STRING_SVTOOLS_HTML_O_border "BORDER"
#define OOO_STRING_SVTOOLS_HTML_O_cellspacing "CELLSPACING"
#define OOO_STRING_SVTOOLS_HTML_O_cellpadding "CELLPADDING"
#define OOO_STRING_SVTOOLS_HTML_O_charoff "CHAROFF"
#define OOO_STRING_SVTOOLS_HTML_O_colspan "COLSPAN"
#define OOO_STRING_SVTOOLS_HTML_O_framespacing "FRAMESPACING"
#define OOO_STRING_SVTOOLS_HTML_O_gutter "GUTTER"
#define OOO_STRING_SVTOOLS_HTML_O_indent "INDENT"
#define OOO_STRING_SVTOOLS_HTML_O_height "HEIGHT"
#define OOO_STRING_SVTOOLS_HTML_O_hspace "HSPACE"
#define OOO_STRING_SVTOOLS_HTML_O_left "LEFT"
#define OOO_STRING_SVTOOLS_HTML_O_leftmargin "LEFTMARGIN"
#define OOO_STRING_SVTOOLS_HTML_O_loop "LOOP"
#define OOO_STRING_SVTOOLS_HTML_O_marginheight "MARGINHEIGHT"
#define OOO_STRING_SVTOOLS_HTML_O_marginwidth "MARGINWIDTH"
#define OOO_STRING_SVTOOLS_HTML_O_max "MAX"
#define OOO_STRING_SVTOOLS_HTML_O_maxlength "MAXLENGTH"
#define OOO_STRING_SVTOOLS_HTML_O_min "MIN"
#define OOO_STRING_SVTOOLS_HTML_O_pagex "PAGEX"
#define OOO_STRING_SVTOOLS_HTML_O_pagey "PAGEY"
#define OOO_STRING_SVTOOLS_HTML_O_pointsize "POINT-SIZE"
#define OOO_STRING_SVTOOLS_HTML_O_rowspan "ROWSPAN"
#define OOO_STRING_SVTOOLS_HTML_O_scrollamount "SCROLLAMOUNT"
#define OOO_STRING_SVTOOLS_HTML_O_scrolldelay "SCROLLDELAY"
#define OOO_STRING_SVTOOLS_HTML_O_seqnum "SEQNUM"
#define OOO_STRING_SVTOOLS_HTML_O_skip "SKIP"
#define OOO_STRING_SVTOOLS_HTML_O_span "SPAN"
#define OOO_STRING_SVTOOLS_HTML_O_tabindex "TABINDEX"
#define OOO_STRING_SVTOOLS_HTML_O_top "TOP"
#define OOO_STRING_SVTOOLS_HTML_O_topmargin "TOPMARGIN"
#define OOO_STRING_SVTOOLS_HTML_O_vspace "VSPACE"
#define OOO_STRING_SVTOOLS_HTML_O_weight "WEIGHT"
#define OOO_STRING_SVTOOLS_HTML_O_width "WIDTH"
#define OOO_STRING_SVTOOLS_HTML_O_x "X"
#define OOO_STRING_SVTOOLS_HTML_O_y "Y"
#define OOO_STRING_SVTOOLS_HTML_O_zindex "Z-INDEX"

// Attribute mit Enum-Werten
#define OOO_STRING_SVTOOLS_HTML_O_behavior "BEHAVIOR"
#define OOO_STRING_SVTOOLS_HTML_O_bgproperties "BGPROPERTIES"
#define OOO_STRING_SVTOOLS_HTML_O_clear "CLEAR"
#define OOO_STRING_SVTOOLS_HTML_O_dir "DIR"
#define OOO_STRING_SVTOOLS_HTML_O_direction "DIRECTION"
#define OOO_STRING_SVTOOLS_HTML_O_format "FORMAT"
#define OOO_STRING_SVTOOLS_HTML_O_frame "FRAME"
#define OOO_STRING_SVTOOLS_HTML_O_lang "LANG"
#define OOO_STRING_SVTOOLS_HTML_O_method "METHOD"
#define OOO_STRING_SVTOOLS_HTML_O_palette "PALETTE"
#define OOO_STRING_SVTOOLS_HTML_O_rel "REL"
#define OOO_STRING_SVTOOLS_HTML_O_rev "REV"
#define OOO_STRING_SVTOOLS_HTML_O_rules "RULES"
#define OOO_STRING_SVTOOLS_HTML_O_scrolling "SCROLLING"
#define OOO_STRING_SVTOOLS_HTML_O_sdreadonly "READONLY"
#define OOO_STRING_SVTOOLS_HTML_O_subtype "SUBTYPE"
#define OOO_STRING_SVTOOLS_HTML_O_type "TYPE"
#define OOO_STRING_SVTOOLS_HTML_O_valign "VALIGN"
#define OOO_STRING_SVTOOLS_HTML_O_valuetype "VALUETYPE"
#define OOO_STRING_SVTOOLS_HTML_O_visibility "VISIBILITY"
#define OOO_STRING_SVTOOLS_HTML_O_wrap "WRAP"

// Attribute mit Script-Code als Wert
#define OOO_STRING_SVTOOLS_HTML_O_onblur "ONBLUR"
#define OOO_STRING_SVTOOLS_HTML_O_onchange "ONCHANGE"
#define OOO_STRING_SVTOOLS_HTML_O_onclick "ONCLICK"
#define OOO_STRING_SVTOOLS_HTML_O_onfocus "ONFOCUS"
#define OOO_STRING_SVTOOLS_HTML_O_onload "ONLOAD"
#define OOO_STRING_SVTOOLS_HTML_O_onmouseover "ONMOUSEOVER"
#define OOO_STRING_SVTOOLS_HTML_O_onreset "ONRESET"
#define OOO_STRING_SVTOOLS_HTML_O_onselect "ONSELECT"
#define OOO_STRING_SVTOOLS_HTML_O_onsubmit "ONSUBMIT"
#define OOO_STRING_SVTOOLS_HTML_O_onunload "ONUNLOAD"
#define OOO_STRING_SVTOOLS_HTML_O_onabort "ONABORT"
#define OOO_STRING_SVTOOLS_HTML_O_onerror "ONERROR"
#define OOO_STRING_SVTOOLS_HTML_O_onmouseout "ONMOUSEOUT"
#define OOO_STRING_SVTOOLS_HTML_O_SDonblur "SDONBLUR"
#define OOO_STRING_SVTOOLS_HTML_O_SDonchange "SDONCHANGE"
#define OOO_STRING_SVTOOLS_HTML_O_SDonclick "SDONCLICK"
#define OOO_STRING_SVTOOLS_HTML_O_SDonfocus "SDONFOCUS"
#define OOO_STRING_SVTOOLS_HTML_O_SDonload "SDONLOAD"
#define OOO_STRING_SVTOOLS_HTML_O_SDonmouseover "SDONMOUSEOVER"
#define OOO_STRING_SVTOOLS_HTML_O_SDonreset "SDONRESET"
#define OOO_STRING_SVTOOLS_HTML_O_SDonselect "SDONSELECT"
#define OOO_STRING_SVTOOLS_HTML_O_SDonsubmit "SDONSUBMIT"
#define OOO_STRING_SVTOOLS_HTML_O_SDonunload "SDONUNLOAD"
#define OOO_STRING_SVTOOLS_HTML_O_SDonabort "SDONABORT"
#define OOO_STRING_SVTOOLS_HTML_O_SDonerror "SDONERROR"
#define OOO_STRING_SVTOOLS_HTML_O_SDonmouseout "SDONMOUSEOUT"

// Attribute mit Kontext-abhaengigen Werten
#define OOO_STRING_SVTOOLS_HTML_O_align "ALIGN"
#define OOO_STRING_SVTOOLS_HTML_O_cols "COLS"
#define OOO_STRING_SVTOOLS_HTML_O_rows "ROWS"
#define OOO_STRING_SVTOOLS_HTML_O_start "START"
#define OOO_STRING_SVTOOLS_HTML_O_size "SIZE"
#define OOO_STRING_SVTOOLS_HTML_O_units "UNITS"

// Werte von <INPUT TYPE=...>
#define OOO_STRING_SVTOOLS_HTML_IT_text "TEXT"
#define OOO_STRING_SVTOOLS_HTML_IT_password "PASSWORD"
#define OOO_STRING_SVTOOLS_HTML_IT_checkbox "CHECKBOX"
#define OOO_STRING_SVTOOLS_HTML_IT_radio "RADIO"
#define OOO_STRING_SVTOOLS_HTML_IT_range "RANGE"
#define OOO_STRING_SVTOOLS_HTML_IT_scribble "SCRIBBLE"
#define OOO_STRING_SVTOOLS_HTML_IT_file "FILE"
#define OOO_STRING_SVTOOLS_HTML_IT_hidden "HIDDEN"
#define OOO_STRING_SVTOOLS_HTML_IT_submit "SUBMIT"
#define OOO_STRING_SVTOOLS_HTML_IT_image "IMAGE"
#define OOO_STRING_SVTOOLS_HTML_IT_reset "RESET"
#define OOO_STRING_SVTOOLS_HTML_IT_button "BUTTON"

// Werte von <TABLE FRAME=...>
#define OOO_STRING_SVTOOLS_HTML_TF_void "VOID"
#define OOO_STRING_SVTOOLS_HTML_TF_above "ABOVE"
#define OOO_STRING_SVTOOLS_HTML_TF_below "BELOW"
#define OOO_STRING_SVTOOLS_HTML_TF_hsides "HSIDES"
#define OOO_STRING_SVTOOLS_HTML_TF_lhs "LHS"
#define OOO_STRING_SVTOOLS_HTML_TF_rhs "RHS"
#define OOO_STRING_SVTOOLS_HTML_TF_vsides "VSIDES"
#define OOO_STRING_SVTOOLS_HTML_TF_box "BOX"
#define OOO_STRING_SVTOOLS_HTML_TF_border "BORDER"

// Werte von <TABLE RULES=...>
#define OOO_STRING_SVTOOLS_HTML_TR_none "NONE"
#define OOO_STRING_SVTOOLS_HTML_TR_groups "GROUPS"
#define OOO_STRING_SVTOOLS_HTML_TR_rows "ROWS"
#define OOO_STRING_SVTOOLS_HTML_TR_cols "COLS"
#define OOO_STRING_SVTOOLS_HTML_TR_all "ALL"

// Werte von <P, H?, TR, TH, TD ALIGN=...>
#define OOO_STRING_SVTOOLS_HTML_AL_left "LEFT"
#define OOO_STRING_SVTOOLS_HTML_AL_center "CENTER"
#define OOO_STRING_SVTOOLS_HTML_AL_middle "MIDDLE"
#define OOO_STRING_SVTOOLS_HTML_AL_right "RIGHT"
#define OOO_STRING_SVTOOLS_HTML_AL_justify "JUSTIFY"
#define OOO_STRING_SVTOOLS_HTML_AL_char "CHAR"
#define OOO_STRING_SVTOOLS_HTML_AL_all "ALL"
#define OOO_STRING_SVTOOLS_HTML_AL_none "NONE"

// Werte von <TR VALIGN=...>, <IMG ALIGN=...>
#define OOO_STRING_SVTOOLS_HTML_VA_top "TOP"
#define OOO_STRING_SVTOOLS_HTML_VA_middle "MIDDLE"
#define OOO_STRING_SVTOOLS_HTML_VA_bottom "BOTTOM"
#define OOO_STRING_SVTOOLS_HTML_VA_baseline "BASELINE"
#define OOO_STRING_SVTOOLS_HTML_VA_texttop "TEXTTOP"
#define OOO_STRING_SVTOOLS_HTML_VA_absmiddle "ABSMIDDLE"
#define OOO_STRING_SVTOOLS_HTML_VA_absbottom "ABSBOTTOM"

// Werte von <AREA SHAPE=...>
#define OOO_STRING_SVTOOLS_HTML_SH_rect "RECT"
#define OOO_STRING_SVTOOLS_HTML_SH_rectangle "RECTANGLE"
#define OOO_STRING_SVTOOLS_HTML_SH_circ "CIRC"
#define OOO_STRING_SVTOOLS_HTML_SH_circle "CIRCLE"
#define OOO_STRING_SVTOOLS_HTML_SH_poly "POLY"
#define OOO_STRING_SVTOOLS_HTML_SH_polygon "POLYGON"
#define OOO_STRING_SVTOOLS_HTML_SH_default "DEFAULT"

#define OOO_STRING_SVTOOLS_HTML_LG_starbasic "STARBASIC"
#define OOO_STRING_SVTOOLS_HTML_LG_javascript "JAVASCRIPT"
#define OOO_STRING_SVTOOLS_HTML_LG_javascript11 "JAVASCRIPT1.1"
#define OOO_STRING_SVTOOLS_HTML_LG_livescript "LIVESCRIPT"

// ein par Werte fuer unser StarBASIC-Support
#define OOO_STRING_SVTOOLS_HTML_SB_library "$LIBRARY:"
#define OOO_STRING_SVTOOLS_HTML_SB_module "$MODULE:"

// Werte von <FORM METHOD=...>
#define OOO_STRING_SVTOOLS_HTML_METHOD_get "GET"
#define OOO_STRING_SVTOOLS_HTML_METHOD_post "POST"

// Werte von <META CONTENT/HTTP-EQUIV=...>
#define OOO_STRING_SVTOOLS_HTML_META_refresh "REFRESH"
#define OOO_STRING_SVTOOLS_HTML_META_generator "GENERATOR"
#define OOO_STRING_SVTOOLS_HTML_META_author "AUTHOR"
#define OOO_STRING_SVTOOLS_HTML_META_classification "CLASSIFICATION"
#define OOO_STRING_SVTOOLS_HTML_META_description "DESCRIPTION"
#define OOO_STRING_SVTOOLS_HTML_META_keywords "KEYWORDS"
#define OOO_STRING_SVTOOLS_HTML_META_changed "CHANGED"
#define OOO_STRING_SVTOOLS_HTML_META_changedby "CHANGEDBY"
#define OOO_STRING_SVTOOLS_HTML_META_created "CREATED"
#define OOO_STRING_SVTOOLS_HTML_META_content_type "CONTENT-TYPE"
#define OOO_STRING_SVTOOLS_HTML_META_content_script_type "CONTENT-SCRIPT-TYPE"
#define OOO_STRING_SVTOOLS_HTML_META_sdendnote "SDENDNOTE"
#define OOO_STRING_SVTOOLS_HTML_META_sdfootnote "SDFOOTNOTE"

// Werte von <UL TYPE=...>
#define OOO_STRING_SVTOOLS_HTML_ULTYPE_disc "DISC"
#define OOO_STRING_SVTOOLS_HTML_ULTYPE_square "SQUARE"
#define OOO_STRING_SVTOOLS_HTML_ULTYPE_circle "CIRCLE"

// Werte von <FRAMESET SCROLLING=...>
#define OOO_STRING_SVTOOLS_HTML_SCROLL_yes "YES"
#define OOO_STRING_SVTOOLS_HTML_SCROLL_no "NO"
#define OOO_STRING_SVTOOLS_HTML_SCROLL_auto "AUTO"

// Werte von <MULTICOL TYPE=...>
#define OOO_STRING_SVTOOLS_HTML_MCTYPE_horizontal "HORIZONTAL"
#define OOO_STRING_SVTOOLS_HTML_MCTYPE_vertical "VERTICAL"
#define OOO_STRING_SVTOOLS_HTML_MCTYPE_box "BOX"

// Werte von <MARQUEE BEHAVIOUR=...>
#define OOO_STRING_SVTOOLS_HTML_BEHAV_scroll "SCROLL"
#define OOO_STRING_SVTOOLS_HTML_BEHAV_slide "SLIDE"
#define OOO_STRING_SVTOOLS_HTML_BEHAV_alternate "ALTERNATE"

// Werte von <MARQUEE LOOP=...>
#define OOO_STRING_SVTOOLS_HTML_LOOP_infinite "INFINITE"
#define OOO_STRING_SVTOOLS_HTML_SPTYPE_block "BLOCK"
#define OOO_STRING_SVTOOLS_HTML_SPTYPE_horizontal "HORIZONTAL"
#define OOO_STRING_SVTOOLS_HTML_SPTYPE_vertical "VERTICAL"

// interne Grafik-Namen
#define OOO_STRING_SVTOOLS_HTML_private_image "private:image/"
#define OOO_STRING_SVTOOLS_HTML_internal_gopher "internal-gopher-"
#define OOO_STRING_SVTOOLS_HTML_internal_icon "internal-icon-"
#define OOO_STRING_SVTOOLS_HTML_INT_GOPHER_binary "binary"
#define OOO_STRING_SVTOOLS_HTML_INT_GOPHER_image "image"
#define OOO_STRING_SVTOOLS_HTML_INT_GOPHER_index "index"
#define OOO_STRING_SVTOOLS_HTML_INT_GOPHER_menu "menu"
#define OOO_STRING_SVTOOLS_HTML_INT_GOPHER_movie "movie"
#define OOO_STRING_SVTOOLS_HTML_INT_GOPHER_sound "sound"
#define OOO_STRING_SVTOOLS_HTML_INT_GOPHER_telnet "telnet"
#define OOO_STRING_SVTOOLS_HTML_INT_GOPHER_text "text"
#define OOO_STRING_SVTOOLS_HTML_INT_GOPHER_unknown "unknown"
#define OOO_STRING_SVTOOLS_HTML_INT_ICON_baddata "baddata"
#define OOO_STRING_SVTOOLS_HTML_INT_ICON_delayed "delayed"
#define OOO_STRING_SVTOOLS_HTML_INT_ICON_embed "embed"
#define OOO_STRING_SVTOOLS_HTML_INT_ICON_insecure "insecure"
#define OOO_STRING_SVTOOLS_HTML_INT_ICON_notfound "notfound"
#define OOO_STRING_SVTOOLS_HTML_sdendnote "sdendnote"
#define OOO_STRING_SVTOOLS_HTML_sdendnote_anc "sdendnoteanc"
#define OOO_STRING_SVTOOLS_HTML_sdendnote_sym "sdendnotesym"
#define OOO_STRING_SVTOOLS_HTML_sdfootnote "sdfootnote"
#define OOO_STRING_SVTOOLS_HTML_sdfootnote_anc "sdfootnoteanc"
#define OOO_STRING_SVTOOLS_HTML_sdfootnote_sym "sdfootnotesym"
#define OOO_STRING_SVTOOLS_HTML_FTN_anchor "anc"
#define OOO_STRING_SVTOOLS_HTML_FTN_symbol "sym"
#define OOO_STRING_SVTOOLS_HTML_WW_off "OFF"
#define OOO_STRING_SVTOOLS_HTML_WW_hard "HARD"
#define OOO_STRING_SVTOOLS_HTML_WW_soft "SOFT"
#define OOO_STRING_SVTOOLS_HTML_WW_virtual "VIRTUAL"
#define OOO_STRING_SVTOOLS_HTML_WW_physical "PHYSICAL"
#define OOO_STRING_SVTOOLS_HTML_on "on"
#define OOO_STRING_SVTOOLS_HTML_ET_url "application/x-www-form-urlencoded"
#define OOO_STRING_SVTOOLS_HTML_ET_multipart "multipart/form-data"
#define OOO_STRING_SVTOOLS_HTML_ET_text "text/plain"

#endif
