/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_xmloff.hxx"
#include <xmloff/xmlimp.hxx>


#include <xmloff/xmlprcon.hxx>

using ::rtl::OUString;
using ::rtl::OUStringBuffer;

using namespace ::com::sun::star;
using namespace ::std;

SvXMLPropertySetContext::SvXMLPropertySetContext(
	SvXMLImport& rImp, USHORT nPrfx,
	const OUString& rLName,
    const uno::Reference< xml::sax::XAttributeList >& xAttrList,
	sal_uInt32 nFam,
	vector< XMLPropertyState > &rProps,
	const UniReference < SvXMLImportPropertyMapper >  &rMap,
	sal_Int32 nSIdx, sal_Int32 nEIdx )
:	SvXMLImportContext( rImp, nPrfx, rLName )
,	mnStartIdx( nSIdx )
,	mnEndIdx( nEIdx )
,	mnFamily( nFam )
,	mrProperties( rProps )
,	mxMapper( rMap )
{
	mxMapper->importXML( mrProperties, xAttrList,
						GetImport().GetMM100UnitConverter(),
						GetImport().GetNamespaceMap(), mnFamily, 
						mnStartIdx, mnEndIdx );
}

SvXMLPropertySetContext::~SvXMLPropertySetContext()
{
}

SvXMLImportContext *SvXMLPropertySetContext::CreateChildContext(
	USHORT nPrefix,
	const OUString& rLocalName,
	const uno::Reference< xml::sax::XAttributeList >& xAttrList )
{
	UniReference< XMLPropertySetMapper > aSetMapper(
			mxMapper->getPropertySetMapper() );
	sal_Int32 nEntryIndex = aSetMapper->GetEntryIndex( nPrefix, rLocalName,
													   mnFamily, mnStartIdx );

	if( ( nEntryIndex != -1 ) && (-1 == mnEndIdx || nEntryIndex < mnEndIdx ) &&
		( 0 != ( aSetMapper->GetEntryFlags( nEntryIndex )
				 		& MID_FLAG_ELEMENT_ITEM_IMPORT ) ) )
	{
		XMLPropertyState aProp( nEntryIndex );
		return CreateChildContext( nPrefix, rLocalName, xAttrList,
								   mrProperties, aProp );
	}
	else
	{
		return new SvXMLImportContext( GetImport(), nPrefix, rLocalName );
	}
}

/** This method is called from this instance implementation of
	CreateChildContext if the element matches an entry in the
	SvXMLImportItemMapper with the mid flag MID_FLAG_ELEMENT
*/
SvXMLImportContext *SvXMLPropertySetContext::CreateChildContext(
	USHORT nPrefix,
	const rtl::OUString& rLocalName,
	const uno::Reference< xml::sax::XAttributeList >&,
	::std::vector< XMLPropertyState > &,
	const XMLPropertyState& )
{
	return new SvXMLImportContext( GetImport(), nPrefix, rLocalName );
}


