/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;

public abstract class InputStream
implements Closeable {
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static byte[] skipBuffer;

    public abstract int read() throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = this.read();
        if (n4 == -1) {
            return -1;
        }
        byArray[n] = (byte)n4;
        try {
            for (n3 = 1; n3 < n2 && (n4 = this.read()) != -1; ++n3) {
                byArray[n + n3] = (byte)n4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        int n;
        long l2 = l;
        if (skipBuffer == null) {
            skipBuffer = new byte[2048];
        }
        byte[] byArray = skipBuffer;
        if (l <= 0L) {
            return 0L;
        }
        while (l2 > 0L && (n = this.read(byArray, 0, (int)Math.min(2048L, l2))) >= 0) {
            l2 -= (long)n;
        }
        return l - l2;
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }
}

