/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaIndex {
    private static volatile Map<File, MetaIndex> jarMap;
    private String[] contents;
    private boolean isClassOnlyJar;

    public static MetaIndex forJar(File file) {
        return MetaIndex.getJarMap().get(file);
    }

    public static synchronized void registerDirectory(File file) {
        File file2 = new File(file, "meta-index");
        if (file2.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                String string = null;
                String string2 = null;
                boolean bl = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                Map<File, MetaIndex> map = MetaIndex.getJarMap();
                file = file.getCanonicalFile();
                string = bufferedReader.readLine();
                if (string == null || !string.equals("% VERSION 2")) {
                    bufferedReader.close();
                    return;
                }
                block6: while ((string = bufferedReader.readLine()) != null) {
                    switch (string.charAt(0)) {
                        case '!': 
                        case '#': 
                        case '@': {
                            if (string2 != null && arrayList.size() > 0) {
                                map.put(new File(file, string2), new MetaIndex(arrayList, bl));
                                arrayList.clear();
                            }
                            string2 = string.substring(2);
                            if (string.charAt(0) == '!') {
                                bl = true;
                                continue block6;
                            }
                            if (!bl) continue block6;
                            bl = false;
                            continue block6;
                        }
                        case '%': {
                            continue block6;
                        }
                    }
                    arrayList.add(string);
                }
                if (string2 != null && arrayList.size() > 0) {
                    map.put(new File(file, string2), new MetaIndex(arrayList, bl));
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean mayContain(String string) {
        if (this.isClassOnlyJar && !string.endsWith(".class")) {
            return false;
        }
        String[] stringArray = this.contents;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private MetaIndex(List<String> list, boolean bl) throws IllegalArgumentException {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.contents = list.toArray(new String[0]);
        this.isClassOnlyJar = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Map<File, MetaIndex> getJarMap() {
        if (jarMap == null) {
            Class<MetaIndex> clazz = MetaIndex.class;
            // MONITORENTER : sun.misc.MetaIndex.class
            if (jarMap == null) {
                jarMap = new HashMap<File, MetaIndex>();
            }
            // MONITOREXIT : clazz
        }
        if ($assertionsDisabled) return jarMap;
        if (jarMap != null) return jarMap;
        throw new AssertionError();
    }
}

