/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.nimbus;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

class EffectUtils {
    EffectUtils() {
    }

    static void clearImage(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
    }

    static BufferedImage gaussianBlur(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (bufferedImage2 == null || bufferedImage2.getWidth() != n2 || bufferedImage2.getHeight() != n3 || bufferedImage.getType() != bufferedImage2.getType()) {
            bufferedImage2 = EffectUtils.createColorModelCompatibleImage(bufferedImage);
        }
        float[] fArray = EffectUtils.createGaussianKernel(n);
        if (bufferedImage.getType() == 2) {
            int[] nArray = new int[n2 * n3];
            int[] nArray2 = new int[n2 * n3];
            EffectUtils.getPixels(bufferedImage, 0, 0, n2, n3, nArray);
            EffectUtils.blur(nArray, nArray2, n2, n3, fArray, n);
            EffectUtils.blur(nArray2, nArray, n3, n2, fArray, n);
            EffectUtils.setPixels(bufferedImage2, 0, 0, n2, n3, nArray);
        } else if (bufferedImage.getType() == 10) {
            byte[] byArray = new byte[n2 * n3];
            byte[] byArray2 = new byte[n2 * n3];
            EffectUtils.getPixels(bufferedImage, 0, 0, n2, n3, byArray);
            EffectUtils.blur(byArray, byArray2, n2, n3, fArray, n);
            EffectUtils.blur(byArray2, byArray, n3, n2, fArray, n);
            EffectUtils.setPixels(bufferedImage2, 0, 0, n2, n3, byArray);
        } else {
            throw new IllegalArgumentException("EffectUtils.gaussianBlur() src image is not a supported type, type=[" + bufferedImage.getType() + "]");
        }
        return bufferedImage2;
    }

    private static void blur(int[] nArray, int[] nArray2, int n, int n2, float[] fArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            int n4 = i;
            int n5 = i * n;
            for (int j = 0; j < n; ++j) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                for (int k = -n3; k <= n3; ++k) {
                    int n6 = j + k;
                    if (n6 < 0 || n6 >= n) {
                        n6 = (j + n) % n;
                    }
                    int n7 = nArray[n5 + n6];
                    float f5 = fArray[n3 + k];
                    f4 += f5 * (float)(n7 >> 24 & 0xFF);
                    f3 += f5 * (float)(n7 >> 16 & 0xFF);
                    f2 += f5 * (float)(n7 >> 8 & 0xFF);
                    f += f5 * (float)(n7 & 0xFF);
                }
                int n8 = (int)(f4 + 0.5f);
                int n9 = (int)(f3 + 0.5f);
                int n10 = (int)(f2 + 0.5f);
                int n11 = (int)(f + 0.5f);
                nArray2[n4] = (n8 > 255 ? 255 : n8) << 24 | (n9 > 255 ? 255 : n9) << 16 | (n10 > 255 ? 255 : n10) << 8 | (n11 > 255 ? 255 : n11);
                n4 += n2;
            }
        }
    }

    static void blur(byte[] byArray, byte[] byArray2, int n, int n2, float[] fArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            int n4 = i;
            int n5 = i * n;
            for (int j = 0; j < n; ++j) {
                float f = 0.0f;
                for (int k = -n3; k <= n3; ++k) {
                    int n6 = j + k;
                    if (n6 < 0 || n6 >= n) {
                        n6 = (j + n) % n;
                    }
                    int n7 = byArray[n5 + n6] & 0xFF;
                    float f2 = fArray[n3 + k];
                    f += f2 * (float)n7;
                }
                int n8 = (int)(f + 0.5f);
                byArray2[n4] = (byte)(n8 > 255 ? 255 : n8);
                n4 += n2;
            }
        }
    }

    static float[] createGaussianKernel(int n) {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        float[] fArray = new float[n * 2 + 1];
        float f = (float)n / 3.0f;
        float f2 = 2.0f * f * f;
        float f3 = (float)Math.sqrt((double)f2 * Math.PI);
        float f4 = 0.0f;
        for (n2 = -n; n2 <= n; ++n2) {
            float f5 = n2 * n2;
            int n3 = n2 + n;
            fArray[n3] = (float)Math.exp(-f5 / f2) / f3;
            f4 += fArray[n3];
        }
        n2 = 0;
        while (n2 < fArray.length) {
            int n4 = n2++;
            fArray[n4] = fArray[n4] / f4;
        }
        return fArray;
    }

    static byte[] getPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, byte[] byArray) {
        if (n3 == 0 || n4 == 0) {
            return new byte[0];
        }
        if (byArray == null) {
            byArray = new byte[n3 * n4];
        } else if (byArray.length < n3 * n4) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n5 = bufferedImage.getType();
        if (n5 == 10) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            return (byte[])writableRaster.getDataElements(n, n2, n3, n4, byArray);
        }
        throw new IllegalArgumentException("Only type BYTE_GRAY is supported");
    }

    static void setPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, byte[] byArray) {
        if (byArray == null || n3 == 0 || n4 == 0) {
            return;
        }
        if (byArray.length < n3 * n4) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n5 = bufferedImage.getType();
        if (n5 != 10) {
            throw new IllegalArgumentException("Only type BYTE_GRAY is supported");
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        writableRaster.setDataElements(n, n2, n3, n4, byArray);
    }

    public static int[] getPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        if (n3 == 0 || n4 == 0) {
            return new int[0];
        }
        if (nArray == null) {
            nArray = new int[n3 * n4];
        } else if (nArray.length < n3 * n4) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n5 = bufferedImage.getType();
        if (n5 == 2 || n5 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            return (int[])writableRaster.getDataElements(n, n2, n3, n4, nArray);
        }
        return bufferedImage.getRGB(n, n2, n3, n4, nArray, 0, n3);
    }

    public static void setPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        if (nArray == null || n3 == 0 || n4 == 0) {
            return;
        }
        if (nArray.length < n3 * n4) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n5 = bufferedImage.getType();
        if (n5 == 2 || n5 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            writableRaster.setDataElements(n, n2, n3, n4, nArray);
        } else {
            bufferedImage.setRGB(n, n2, n3, n4, nArray, 0, n3);
        }
    }

    public static BufferedImage createColorModelCompatibleImage(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleTranslucentImage(int n, int n2) {
        return EffectUtils.isHeadless() ? new BufferedImage(n, n2, 2) : EffectUtils.getGraphicsConfiguration().createCompatibleImage(n, n2, 3);
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }
}

