/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifBorders;
import com.sun.java.swing.plaf.motif.MotifDesktopIconUI;
import com.sun.java.swing.plaf.motif.MotifInternalFrameTitlePane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class MotifInternalFrameUI
extends BasicInternalFrameUI {
    Color color;
    Color highlight;
    Color shadow;
    MotifInternalFrameTitlePane titlePane;
    @Deprecated
    protected KeyStroke closeMenuKey;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifInternalFrameUI((JInternalFrame)jComponent);
    }

    public MotifInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.setColors((JInternalFrame)jComponent);
    }

    protected void installDefaults() {
        Border border = this.frame.getBorder();
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        if (border == null || border instanceof UIResource) {
            this.frame.setBorder(new MotifBorders.InternalFrameBorder(this.frame));
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.closeMenuKey = KeyStroke.getKeyStroke(27, 0);
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.frame);
        this.frame.setLayout(null);
        this.internalFrameLayout = null;
    }

    private JInternalFrame getFrame() {
        return this.frame;
    }

    public JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new MotifInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        if (this.isKeyBindingRegistered()) {
            JInternalFrame.JDesktopIcon jDesktopIcon = this.frame.getDesktopIcon();
            SwingUtilities.replaceUIActionMap(jDesktopIcon, null);
            SwingUtilities.replaceUIInputMap(jDesktopIcon, 2, null);
        }
    }

    protected void setupMenuOpenKey() {
        super.setupMenuOpenKey();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.frame);
        if (actionMap != null) {
            actionMap.put("showSystemMenu", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MotifInternalFrameUI.this.titlePane.showSystemMenu();
                }

                public boolean isEnabled() {
                    return MotifInternalFrameUI.this.isKeyBindingActive();
                }
            });
        }
    }

    protected void setupMenuCloseKey() {
        Object object;
        JInternalFrame.JDesktopIcon jDesktopIcon;
        InputMap inputMap;
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.frame);
        if (actionMap != null) {
            actionMap.put("hideSystemMenu", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MotifInternalFrameUI.this.titlePane.hideSystemMenu();
                }

                public boolean isEnabled() {
                    return MotifInternalFrameUI.this.isKeyBindingActive();
                }
            });
        }
        if ((inputMap = SwingUtilities.getUIInputMap(jDesktopIcon = this.frame.getDesktopIcon(), 2)) == null && (object = (Object[])UIManager.get("DesktopIcon.windowBindings")) != null) {
            inputMap = LookAndFeel.makeComponentInputMap(jDesktopIcon, (Object[])object);
            SwingUtilities.replaceUIInputMap(jDesktopIcon, 2, inputMap);
        }
        if ((object = SwingUtilities.getUIActionMap(jDesktopIcon)) == null) {
            object = new ActionMapUIResource();
            ((ActionMap)object).put("hideSystemMenu", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JInternalFrame.JDesktopIcon jDesktopIcon = MotifInternalFrameUI.this.getFrame().getDesktopIcon();
                    MotifDesktopIconUI motifDesktopIconUI = (MotifDesktopIconUI)jDesktopIcon.getUI();
                    motifDesktopIconUI.hideSystemMenu();
                }

                public boolean isEnabled() {
                    return MotifInternalFrameUI.this.isKeyBindingActive();
                }
            });
            SwingUtilities.replaceUIActionMap(jDesktopIcon, (ActionMap)object);
        }
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        super.activateFrame(jInternalFrame);
        this.setColors(jInternalFrame);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.setColors(jInternalFrame);
        super.deactivateFrame(jInternalFrame);
    }

    void setColors(JInternalFrame jInternalFrame) {
        this.color = jInternalFrame.isSelected() ? UIManager.getColor("InternalFrame.activeTitleBackground") : UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.highlight = this.color.brighter();
        this.shadow = this.color.darker().darker();
        this.titlePane.setColors(this.color, this.highlight, this.shadow);
    }
}

