/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class JCEMapper {
    static Logger log = Logger.getLogger(JCEMapper.class.getName());
    private static Map uriToJCEName = new HashMap();
    private static Map algorithmsMap = new HashMap();
    private static String providerName = null;

    public static void init(Element element) throws Exception {
        JCEMapper.loadAlgorithms((Element)element.getElementsByTagName("Algorithms").item(0));
    }

    static void loadAlgorithms(Element element) {
        Element[] elementArray = XMLUtils.selectNodes(element.getFirstChild(), "http://www.xmlsecurity.org/NS/#configuration", "Algorithm");
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string = element2.getAttribute("URI");
            String string2 = element2.getAttribute("JCEName");
            uriToJCEName.put(string, string2);
            algorithmsMap.put(string, new Algorithm(element2));
        }
    }

    static Algorithm getAlgorithmMapping(String string) {
        return (Algorithm)algorithmsMap.get(string);
    }

    public static String translateURItoJCEID(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Request for URI " + string);
        }
        String string2 = (String)uriToJCEName.get(string);
        return string2;
    }

    public static String getAlgorithmClassFromURI(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Request for URI " + string);
        }
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)string)).algorithmClass;
    }

    public static int getKeyLengthFromURI(String string) {
        return Integer.parseInt(((Algorithm)JCEMapper.algorithmsMap.get((Object)string)).keyLength);
    }

    public static String getJCEKeyAlgorithmFromURI(String string) {
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)string)).requiredKey;
    }

    public static String getProviderId() {
        return providerName;
    }

    public static void setProviderId(String string) {
        providerName = string;
    }

    public static class Algorithm {
        String algorithmClass;
        String keyLength;
        String requiredKey;

        public Algorithm(Element element) {
            this.algorithmClass = element.getAttribute("AlgorithmClass");
            this.keyLength = element.getAttribute("KeyLength");
            this.requiredKey = element.getAttribute("RequiredKey");
        }
    }
}

