/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import sun.text.normalizer.UCharacter;
import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;

public final class Utility {
    private static final char[] UNESCAPE_MAP = new char[]{'a', '\u0007', 'b', '\b', 'e', '\u001b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t', 'v', '\u000b'};
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static final String escape(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); i += UTF16.getCharCount(n)) {
            n = UTF16.charAt(string, i);
            if (n >= 32 && n <= 127) {
                if (n == 92) {
                    stringBuffer.append("\\\\");
                    continue;
                }
                stringBuffer.append((char)n);
                continue;
            }
            boolean bl = n <= 65535;
            stringBuffer.append(bl ? "\\u" : "\\U");
            Utility.hex(n, bl ? 4 : 8, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public static int unescapeAt(String string, int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 4;
        boolean bl = false;
        int n7 = nArray[0];
        int n8 = string.length();
        if (n7 < 0 || n7 >= n8) {
            return -1;
        }
        int n9 = UTF16.charAt(string, n7);
        n7 += UTF16.getCharCount(n9);
        switch (n9) {
            case 117: {
                n5 = 4;
                n4 = 4;
                break;
            }
            case 85: {
                n5 = 8;
                n4 = 8;
                break;
            }
            case 120: {
                n4 = 1;
                if (n7 < n8 && UTF16.charAt(string, n7) == 123) {
                    ++n7;
                    bl = true;
                    n5 = 8;
                    break;
                }
                n5 = 2;
                break;
            }
            default: {
                n = UCharacter.digit(n9, 8);
                if (n < 0) break;
                n4 = 1;
                n5 = 3;
                n3 = 1;
                n6 = 3;
                n2 = n;
            }
        }
        if (n4 != 0) {
            while (n7 < n8 && n3 < n5 && (n = UCharacter.digit(n9 = UTF16.charAt(string, n7), n6 == 3 ? 8 : 16)) >= 0) {
                n2 = n2 << n6 | n;
                n7 += UTF16.getCharCount(n9);
                ++n3;
            }
            if (n3 < n4) {
                return -1;
            }
            if (bl) {
                if (n9 != 125) {
                    return -1;
                }
                ++n7;
            }
            if (n2 < 0 || n2 >= 0x110000) {
                return -1;
            }
            if (n7 < n8 && UTF16.isLeadSurrogate((char)n2)) {
                int n10 = n7 + 1;
                n9 = string.charAt(n7);
                if (n9 == 92 && n10 < n8) {
                    int[] nArray2 = new int[]{n10};
                    n9 = Utility.unescapeAt(string, nArray2);
                    n10 = nArray2[0];
                }
                if (UTF16.isTrailSurrogate((char)n9)) {
                    n7 = n10;
                    n2 = UCharacterProperty.getRawSupplementary((char)n2, (char)n9);
                }
            }
            nArray[0] = n7;
            return n2;
        }
        for (int i = 0; i < UNESCAPE_MAP.length; i += 2) {
            if (n9 == UNESCAPE_MAP[i]) {
                nArray[0] = n7;
                return UNESCAPE_MAP[i + 1];
            }
            if (n9 < UNESCAPE_MAP[i]) break;
        }
        if (n9 == 99 && n7 < n8) {
            n9 = UTF16.charAt(string, n7);
            nArray[0] = n7 + UTF16.getCharCount(n9);
            return 0x1F & n9;
        }
        nArray[0] = n7;
        return n9;
    }

    public static StringBuffer hex(int n, int n2, StringBuffer stringBuffer) {
        return Utility.appendNumber(stringBuffer, n, 16, n2);
    }

    public static String hex(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        return Utility.appendNumber(stringBuffer, n, 16, n2).toString();
    }

    public static int skipWhitespace(String string, int n) {
        int n2;
        while (n < string.length() && UCharacterProperty.isRuleWhiteSpace(n2 = UTF16.charAt(string, n))) {
            n += UTF16.getCharCount(n2);
        }
        return n;
    }

    private static void recursiveAppendNumber(StringBuffer stringBuffer, int n, int n2, int n3) {
        int n4 = n % n2;
        if (n >= n2 || n3 > 1) {
            Utility.recursiveAppendNumber(stringBuffer, n / n2, n2, n3 - 1);
        }
        stringBuffer.append(DIGITS[n4]);
    }

    public static StringBuffer appendNumber(StringBuffer stringBuffer, int n, int n2, int n3) throws IllegalArgumentException {
        if (n2 < 2 || n2 > 36) {
            throw new IllegalArgumentException("Illegal radix " + n2);
        }
        int n4 = n;
        if (n < 0) {
            n4 = -n;
            stringBuffer.append("-");
        }
        Utility.recursiveAppendNumber(stringBuffer, n4, n2, n3);
        return stringBuffer;
    }

    public static boolean isUnprintable(int n) {
        return n < 32 || n > 126;
    }

    public static boolean escapeUnprintable(StringBuffer stringBuffer, int n) {
        if (Utility.isUnprintable(n)) {
            stringBuffer.append('\\');
            if ((n & 0xFFFF0000) != 0) {
                stringBuffer.append('U');
                stringBuffer.append(DIGITS[0xF & n >> 28]);
                stringBuffer.append(DIGITS[0xF & n >> 24]);
                stringBuffer.append(DIGITS[0xF & n >> 20]);
                stringBuffer.append(DIGITS[0xF & n >> 16]);
            } else {
                stringBuffer.append('u');
            }
            stringBuffer.append(DIGITS[0xF & n >> 12]);
            stringBuffer.append(DIGITS[0xF & n >> 8]);
            stringBuffer.append(DIGITS[0xF & n >> 4]);
            stringBuffer.append(DIGITS[0xF & n]);
            return true;
        }
        return false;
    }

    public static void getChars(StringBuffer stringBuffer, int n, int n2, char[] cArray, int n3) {
        if (n == n2) {
            return;
        }
        stringBuffer.getChars(n, n2, cArray, n3);
    }

    public static final boolean arrayRegionMatches(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        for (int i = n; i < n4; ++i) {
            if (cArray[i] == cArray2[i + n5]) continue;
            return false;
        }
        return true;
    }
}

