/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.Aes256;
import sun.security.krb5.internal.crypto.CksumType;

public class HmacSha1Aes256CksumType
extends CksumType {
    public int confounderSize() {
        return 16;
    }

    public int cksumType() {
        return 16;
    }

    public boolean isSafe() {
        return true;
    }

    public int cksumSize() {
        return 12;
    }

    public int keyType() {
        return 3;
    }

    public int keySize() {
        return 32;
    }

    public byte[] calculateChecksum(byte[] byArray, int n) {
        return null;
    }

    public byte[] calculateKeyedChecksum(byte[] byArray, int n, byte[] byArray2, int n2) throws KrbCryptoException {
        try {
            return Aes256.calculateChecksum(byArray2, n2, byArray, 0, n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    public boolean verifyKeyedChecksum(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) throws KrbCryptoException {
        try {
            byte[] byArray4 = Aes256.calculateChecksum(byArray2, n2, byArray, 0, n);
            return HmacSha1Aes256CksumType.isChecksumEqual(byArray3, byArray4);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }
}

