/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardEmitterMBean
extends StandardMBean
implements NotificationEmitter {
    private final NotificationEmitter emitter;
    private final MBeanNotificationInfo[] notificationInfo;

    public <T> StandardEmitterMBean(T t, Class<T> clazz, NotificationEmitter notificationEmitter) {
        super(t, clazz, false);
        if (notificationEmitter == null) {
            throw new IllegalArgumentException("Null emitter");
        }
        this.emitter = notificationEmitter;
        this.notificationInfo = notificationEmitter.getNotificationInfo();
    }

    public <T> StandardEmitterMBean(T t, Class<T> clazz, boolean bl, NotificationEmitter notificationEmitter) {
        super(t, clazz, bl);
        if (notificationEmitter == null) {
            throw new IllegalArgumentException("Null emitter");
        }
        this.emitter = notificationEmitter;
        this.notificationInfo = notificationEmitter.getNotificationInfo();
    }

    protected StandardEmitterMBean(Class<?> clazz, NotificationEmitter notificationEmitter) {
        super(clazz, false);
        if (notificationEmitter == null) {
            throw new IllegalArgumentException("Null emitter");
        }
        this.emitter = notificationEmitter;
        this.notificationInfo = notificationEmitter.getNotificationInfo();
    }

    protected StandardEmitterMBean(Class<?> clazz, boolean bl, NotificationEmitter notificationEmitter) {
        super(clazz, bl);
        if (notificationEmitter == null) {
            throw new IllegalArgumentException("Null emitter");
        }
        this.emitter = notificationEmitter;
        this.notificationInfo = notificationEmitter.getNotificationInfo();
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.emitter.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notificationInfo;
    }

    public void sendNotification(Notification notification) {
        if (!(this.emitter instanceof NotificationBroadcasterSupport)) {
            String string = "Cannot sendNotification when emitter is not an instance of NotificationBroadcasterSupport: " + this.emitter.getClass().getName();
            throw new ClassCastException(string);
        }
        ((NotificationBroadcasterSupport)this.emitter).sendNotification(notification);
    }

    @Override
    MBeanNotificationInfo[] getNotifications(MBeanInfo mBeanInfo) {
        return this.getNotificationInfo();
    }
}

