/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Image;
import java.awt.MediaEntry;
import java.awt.MediaTracker;
import java.awt.image.ImageObserver;
import java.io.Serializable;

class ImageMediaEntry
extends MediaEntry
implements ImageObserver,
Serializable {
    Image image;
    int width;
    int height;
    private static final long serialVersionUID = 4739377000350280650L;

    ImageMediaEntry(MediaTracker mediaTracker, Image image, int n, int n2, int n3) {
        super(mediaTracker, n);
        this.image = image;
        this.width = n2;
        this.height = n3;
    }

    boolean matches(Image image, int n, int n2) {
        return this.image == image && this.width == n && this.height == n2;
    }

    Object getMedia() {
        return this.image;
    }

    int getStatus(boolean bl, boolean bl2) {
        if (bl2) {
            int n = this.tracker.target.checkImage(this.image, this.width, this.height, null);
            int n2 = this.parseflags(n);
            if (n2 == 0) {
                if ((this.status & 0xC) != 0) {
                    this.setStatus(2);
                }
            } else if (n2 != this.status) {
                this.setStatus(n2);
            }
        }
        return super.getStatus(bl, bl2);
    }

    void startLoad() {
        if (this.tracker.target.prepareImage(this.image, this.width, this.height, this)) {
            this.setStatus(8);
        }
    }

    int parseflags(int n) {
        if ((n & 0x40) != 0) {
            return 4;
        }
        if ((n & 0x80) != 0) {
            return 2;
        }
        if ((n & 0x30) != 0) {
            return 8;
        }
        return 0;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.cancelled) {
            return false;
        }
        int n6 = this.parseflags(n);
        if (n6 != 0 && n6 != this.status) {
            this.setStatus(n6);
        }
        return (this.status & 1) != 0;
    }
}

