/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef SC_LOTRANGE_HXX
#define SC_LOTRANGE_HXX

#include <tools/solar.h>
#include <compiler.hxx>

// --------------------------------------------------------- class LotusRange -

class LotusRangeList;

typedef sal_uInt16	LR_ID;
#define ID_FAIL	0xFFFF

class LotusRange
{
	friend class LotusRangeList;
private:
	sal_uInt32				nHash;
	SCCOL				nColStart;
	SCROW				nRowStart;
	SCCOL				nColEnd;
	SCROW				nRowEnd;
	LR_ID				nId;
	void				MakeHash( void );
	inline void			Copy( const LotusRange& );
	inline void			SetId( LR_ID nId );
public:
						LotusRange( SCCOL nCol, SCROW nRow );
						LotusRange( SCCOL nColS, SCROW nRowS, SCCOL nColE, SCROW nRowE );
						LotusRange( const LotusRange& );
	inline LotusRange	&operator =( const LotusRange& );
	inline sal_Bool			operator ==( const LotusRange& ) const;
	inline sal_Bool			operator !=( const LotusRange& ) const;
	inline sal_Bool			IsSingle( void ) const;
};


inline void LotusRange::Copy( const LotusRange& rCpy )
{
	nColStart = rCpy.nColStart;
	nRowStart = rCpy.nRowStart;
	nColEnd = rCpy.nColEnd;
	nRowEnd = rCpy.nRowEnd;
}


inline void LotusRange::SetId( LR_ID nNewId )
{
	nId = nNewId;
}


inline LotusRange &LotusRange::operator =( const LotusRange& rCpy )
{
	Copy( rCpy );
	return *this;
}


inline sal_Bool LotusRange::operator ==( const LotusRange& rRef ) const
{
	return ( nHash == rRef.nHash && nColStart == rRef.nColStart &&
		nRowStart == rRef.nRowStart && nColEnd == rRef.nColEnd &&
		nRowEnd == rRef.nRowEnd );
}


inline sal_Bool LotusRange::operator !=( const LotusRange& rRef ) const
{
	return ( nHash != rRef.nHash || nColStart != rRef.nColStart ||
		nRowStart != rRef.nRowStart || nColEnd != rRef.nColEnd ||
		nRowEnd != rRef.nRowEnd );
}


inline sal_Bool LotusRange::IsSingle( void ) const
{
	return ( nColStart == nColEnd && nRowStart == nRowEnd );
}



// ----------------------------------------------------- class LotusRangeList -

class LotusRangeList : private List
{
private:
	LR_ID				nIdCnt;
	ScComplexRefData		aComplRef;
	static SCCOL		nEingCol;
	static SCROW		nEingRow;
public:
						LotusRangeList( void );
						~LotusRangeList( void );
	inline sal_uInt16		GetIndex( SCCOL nCol, SCROW nRow );
	inline sal_uInt16		GetIndex( SCCOL nColS, SCROW nRowS, SCCOL nColE, SCROW nRowE );
	sal_uInt16				GetIndex( const LotusRange& );
	inline void			Append( SCCOL nCol, SCROW nRow, const String& );
	inline void			Append( SCCOL nColS, SCROW nRowS, SCCOL nColE, SCROW nRowE, const String& );
	void				Append( LotusRange* pLR, const String& rName );
	inline static void	SetEing( const SCCOL nCol, const SCROW nRow );
};


inline LR_ID LotusRangeList::GetIndex( SCCOL nCol, SCROW nRow )
{
	LotusRange aRef( nCol, nRow );
	return GetIndex( aRef );
}


inline LR_ID LotusRangeList::GetIndex( SCCOL nColS, SCROW nRowS, SCCOL nColE, SCROW nRowE )
{
	LotusRange aRef( nColS, nRowS, nColE, nRowE );
	return GetIndex( aRef );
}


inline void LotusRangeList::Append( SCCOL nCol, SCROW nRow, const String& rName )
{
	Append( new LotusRange( nCol, nRow ), rName );
}


inline void LotusRangeList::Append( SCCOL nColS, SCROW nRowS, SCCOL nColE, SCROW nRowE, const String& r )
{
	Append( new LotusRange( nColS, nRowS, nColE, nRowE ), r );
}


inline void LotusRangeList::SetEing( const SCCOL nCol, const SCROW nRow )
{
	nEingCol = nCol;
	nEingRow = nRow;
}

#endif



