/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.nio.ByteOrder;
import java.security.AccessController;
import sun.misc.Unsafe;
import sun.security.action.GetPropertyAction;

final class ByteArrayAccess {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final boolean littleEndianUnaligned;
    private static final boolean bigEndian;
    private static final int byteArrayOfs;

    private ByteArrayAccess() {
    }

    private static boolean unaligned() {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.arch", ""));
        return string.equals("i386") || string.equals("x86") || string.equals("amd64");
    }

    static void b2iLittle(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        if (littleEndianUnaligned) {
            n3 += (n += byteArrayOfs);
            while (n < n3) {
                nArray[n2++] = unsafe.getInt((Object)byArray, (long)n);
                n += 4;
            }
        } else if (bigEndian && (n & 3) == 0) {
            n3 += (n += byteArrayOfs);
            while (n < n3) {
                nArray[n2++] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)n));
                n += 4;
            }
        } else {
            n3 += n;
            while (n < n3) {
                nArray[n2++] = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
                n += 4;
            }
        }
    }

    static void b2iLittle64(byte[] byArray, int n, int[] nArray) {
        if (littleEndianUnaligned) {
            nArray[0] = unsafe.getInt((Object)byArray, (long)(n += byteArrayOfs));
            nArray[1] = unsafe.getInt((Object)byArray, (long)(n + 4));
            nArray[2] = unsafe.getInt((Object)byArray, (long)(n + 8));
            nArray[3] = unsafe.getInt((Object)byArray, (long)(n + 12));
            nArray[4] = unsafe.getInt((Object)byArray, (long)(n + 16));
            nArray[5] = unsafe.getInt((Object)byArray, (long)(n + 20));
            nArray[6] = unsafe.getInt((Object)byArray, (long)(n + 24));
            nArray[7] = unsafe.getInt((Object)byArray, (long)(n + 28));
            nArray[8] = unsafe.getInt((Object)byArray, (long)(n + 32));
            nArray[9] = unsafe.getInt((Object)byArray, (long)(n + 36));
            nArray[10] = unsafe.getInt((Object)byArray, (long)(n + 40));
            nArray[11] = unsafe.getInt((Object)byArray, (long)(n + 44));
            nArray[12] = unsafe.getInt((Object)byArray, (long)(n + 48));
            nArray[13] = unsafe.getInt((Object)byArray, (long)(n + 52));
            nArray[14] = unsafe.getInt((Object)byArray, (long)(n + 56));
            nArray[15] = unsafe.getInt((Object)byArray, (long)(n + 60));
        } else if (bigEndian && (n & 3) == 0) {
            nArray[0] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n += byteArrayOfs)));
            nArray[1] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 4)));
            nArray[2] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 8)));
            nArray[3] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 12)));
            nArray[4] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 16)));
            nArray[5] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 20)));
            nArray[6] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 24)));
            nArray[7] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 28)));
            nArray[8] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 32)));
            nArray[9] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 36)));
            nArray[10] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 40)));
            nArray[11] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 44)));
            nArray[12] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 48)));
            nArray[13] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 52)));
            nArray[14] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 56)));
            nArray[15] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 60)));
        } else {
            ByteArrayAccess.b2iLittle(byArray, n, nArray, 0, 64);
        }
    }

    static void i2bLittle(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        if (littleEndianUnaligned) {
            n3 += (n2 += byteArrayOfs);
            while (n2 < n3) {
                unsafe.putInt((Object)byArray, (long)n2, nArray[n++]);
                n2 += 4;
            }
        } else if (bigEndian && (n2 & 3) == 0) {
            n3 += (n2 += byteArrayOfs);
            while (n2 < n3) {
                unsafe.putInt((Object)byArray, (long)n2, Integer.reverseBytes(nArray[n++]));
                n2 += 4;
            }
        } else {
            n3 += n2;
            while (n2 < n3) {
                int n4 = nArray[n++];
                byArray[n2++] = (byte)n4;
                byArray[n2++] = (byte)(n4 >> 8);
                byArray[n2++] = (byte)(n4 >> 16);
                byArray[n2++] = (byte)(n4 >> 24);
            }
        }
    }

    static void i2bLittle4(int n, byte[] byArray, int n2) {
        if (littleEndianUnaligned) {
            unsafe.putInt((Object)byArray, (long)(byteArrayOfs + n2), n);
        } else if (bigEndian && (n2 & 3) == 0) {
            unsafe.putInt((Object)byArray, (long)(byteArrayOfs + n2), Integer.reverseBytes(n));
        } else {
            byArray[n2] = (byte)n;
            byArray[n2 + 1] = (byte)(n >> 8);
            byArray[n2 + 2] = (byte)(n >> 16);
            byArray[n2 + 3] = (byte)(n >> 24);
        }
    }

    static void b2iBig(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        if (littleEndianUnaligned) {
            n3 += (n += byteArrayOfs);
            while (n < n3) {
                nArray[n2++] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)n));
                n += 4;
            }
        } else if (bigEndian && (n & 3) == 0) {
            n3 += (n += byteArrayOfs);
            while (n < n3) {
                nArray[n2++] = unsafe.getInt((Object)byArray, (long)n);
                n += 4;
            }
        } else {
            n3 += n;
            while (n < n3) {
                nArray[n2++] = byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | byArray[n] << 24;
                n += 4;
            }
        }
    }

    static void b2iBig64(byte[] byArray, int n, int[] nArray) {
        if (littleEndianUnaligned) {
            nArray[0] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n += byteArrayOfs)));
            nArray[1] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 4)));
            nArray[2] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 8)));
            nArray[3] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 12)));
            nArray[4] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 16)));
            nArray[5] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 20)));
            nArray[6] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 24)));
            nArray[7] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 28)));
            nArray[8] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 32)));
            nArray[9] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 36)));
            nArray[10] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 40)));
            nArray[11] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 44)));
            nArray[12] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 48)));
            nArray[13] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 52)));
            nArray[14] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 56)));
            nArray[15] = Integer.reverseBytes(unsafe.getInt((Object)byArray, (long)(n + 60)));
        } else if (bigEndian && (n & 3) == 0) {
            nArray[0] = unsafe.getInt((Object)byArray, (long)(n += byteArrayOfs));
            nArray[1] = unsafe.getInt((Object)byArray, (long)(n + 4));
            nArray[2] = unsafe.getInt((Object)byArray, (long)(n + 8));
            nArray[3] = unsafe.getInt((Object)byArray, (long)(n + 12));
            nArray[4] = unsafe.getInt((Object)byArray, (long)(n + 16));
            nArray[5] = unsafe.getInt((Object)byArray, (long)(n + 20));
            nArray[6] = unsafe.getInt((Object)byArray, (long)(n + 24));
            nArray[7] = unsafe.getInt((Object)byArray, (long)(n + 28));
            nArray[8] = unsafe.getInt((Object)byArray, (long)(n + 32));
            nArray[9] = unsafe.getInt((Object)byArray, (long)(n + 36));
            nArray[10] = unsafe.getInt((Object)byArray, (long)(n + 40));
            nArray[11] = unsafe.getInt((Object)byArray, (long)(n + 44));
            nArray[12] = unsafe.getInt((Object)byArray, (long)(n + 48));
            nArray[13] = unsafe.getInt((Object)byArray, (long)(n + 52));
            nArray[14] = unsafe.getInt((Object)byArray, (long)(n + 56));
            nArray[15] = unsafe.getInt((Object)byArray, (long)(n + 60));
        } else {
            ByteArrayAccess.b2iBig(byArray, n, nArray, 0, 64);
        }
    }

    static void i2bBig(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        if (littleEndianUnaligned) {
            n3 += (n2 += byteArrayOfs);
            while (n2 < n3) {
                unsafe.putInt((Object)byArray, (long)n2, Integer.reverseBytes(nArray[n++]));
                n2 += 4;
            }
        } else if (bigEndian && (n2 & 3) == 0) {
            n3 += (n2 += byteArrayOfs);
            while (n2 < n3) {
                unsafe.putInt((Object)byArray, (long)n2, nArray[n++]);
                n2 += 4;
            }
        } else {
            n3 += n2;
            while (n2 < n3) {
                int n4 = nArray[n++];
                byArray[n2++] = (byte)(n4 >> 24);
                byArray[n2++] = (byte)(n4 >> 16);
                byArray[n2++] = (byte)(n4 >> 8);
                byArray[n2++] = (byte)n4;
            }
        }
    }

    static void i2bBig4(int n, byte[] byArray, int n2) {
        if (littleEndianUnaligned) {
            unsafe.putInt((Object)byArray, (long)(byteArrayOfs + n2), Integer.reverseBytes(n));
        } else if (bigEndian && (n2 & 3) == 0) {
            unsafe.putInt((Object)byArray, (long)(byteArrayOfs + n2), n);
        } else {
            byArray[n2] = (byte)(n >> 24);
            byArray[n2 + 1] = (byte)(n >> 16);
            byArray[n2 + 2] = (byte)(n >> 8);
            byArray[n2 + 3] = (byte)n;
        }
    }

    static void b2lBig(byte[] byArray, int n, long[] lArray, int n2, int n3) {
        if (littleEndianUnaligned) {
            n3 += (n += byteArrayOfs);
            while (n < n3) {
                lArray[n2++] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)n));
                n += 8;
            }
        } else if (bigEndian && (n & 3) == 0) {
            n3 += (n += byteArrayOfs);
            while (n < n3) {
                lArray[n2++] = (long)unsafe.getInt((Object)byArray, (long)n) << 32 | (long)unsafe.getInt((Object)byArray, (long)(n + 4)) & 0xFFFFFFFFL;
                n += 8;
            }
        } else {
            n3 += n;
            while (n < n3) {
                int n4 = byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | byArray[n] << 24;
                int n5 = byArray[(n += 4) + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | byArray[n] << 24;
                lArray[n2++] = (long)n4 << 32 | (long)n5 & 0xFFFFFFFFL;
                n += 4;
            }
        }
    }

    static void b2lBig128(byte[] byArray, int n, long[] lArray) {
        if (littleEndianUnaligned) {
            lArray[0] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n += byteArrayOfs)));
            lArray[1] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 8)));
            lArray[2] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 16)));
            lArray[3] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 24)));
            lArray[4] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 32)));
            lArray[5] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 40)));
            lArray[6] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 48)));
            lArray[7] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 56)));
            lArray[8] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 64)));
            lArray[9] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 72)));
            lArray[10] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 80)));
            lArray[11] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 88)));
            lArray[12] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 96)));
            lArray[13] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 104)));
            lArray[14] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 112)));
            lArray[15] = Long.reverseBytes(unsafe.getLong((Object)byArray, (long)(n + 120)));
        } else {
            ByteArrayAccess.b2lBig(byArray, n, lArray, 0, 128);
        }
    }

    static void l2bBig(long[] lArray, int n, byte[] byArray, int n2, int n3) {
        n3 += n2;
        while (n2 < n3) {
            long l = lArray[n++];
            byArray[n2++] = (byte)(l >> 56);
            byArray[n2++] = (byte)(l >> 48);
            byArray[n2++] = (byte)(l >> 40);
            byArray[n2++] = (byte)(l >> 32);
            byArray[n2++] = (byte)(l >> 24);
            byArray[n2++] = (byte)(l >> 16);
            byArray[n2++] = (byte)(l >> 8);
            byArray[n2++] = (byte)l;
        }
    }

    static {
        byteArrayOfs = unsafe.arrayBaseOffset(byte[].class);
        boolean bl = unsafe.arrayIndexScale(byte[].class) == 1 && unsafe.arrayIndexScale(int[].class) == 4 && unsafe.arrayIndexScale(long[].class) == 8 && (byteArrayOfs & 3) == 0;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        littleEndianUnaligned = bl && ByteArrayAccess.unaligned() && byteOrder == ByteOrder.LITTLE_ENDIAN;
        bigEndian = bl && byteOrder == ByteOrder.BIG_ENDIAN;
    }
}

