/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.MessageToken;

class MicToken
extends MessageToken {
    public MicToken(Krb5Context krb5Context, byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        super(257, krb5Context, byArray, n, n2, messageProp);
    }

    public MicToken(Krb5Context krb5Context, InputStream inputStream, MessageProp messageProp) throws GSSException {
        super(257, krb5Context, inputStream, messageProp);
    }

    public void verify(byte[] byArray, int n, int n2) throws GSSException {
        if (!this.verifySignAndSeqNumber(null, byArray, n, n2, null)) {
            throw new GSSException(6, -1, "Corrupt checksum or sequence number in MIC token");
        }
    }

    public void verify(InputStream inputStream) throws GSSException {
        byte[] byArray = null;
        try {
            byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new GSSException(6, -1, "Corrupt checksum or sequence number in MIC token");
        }
        this.verify(byArray, 0, byArray.length);
    }

    public MicToken(Krb5Context krb5Context, MessageProp messageProp, byte[] byArray, int n, int n2) throws GSSException {
        super(257, krb5Context);
        if (messageProp == null) {
            messageProp = new MessageProp(0, false);
        }
        this.genSignAndSeqNumber(messageProp, null, byArray, n, n2, null);
    }

    public MicToken(Krb5Context krb5Context, MessageProp messageProp, InputStream inputStream) throws GSSException, IOException {
        super(257, krb5Context);
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        if (messageProp == null) {
            messageProp = new MessageProp(0, false);
        }
        this.genSignAndSeqNumber(messageProp, null, byArray, 0, byArray.length, null);
    }

    protected int getSealAlg(boolean bl, int n) {
        return 65535;
    }

    public int encode(byte[] byArray, int n) throws IOException, GSSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.encode(byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    public byte[] encode() throws IOException, GSSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50);
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

