/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public final class SplashScreen {
    private BufferedImage image;
    private long splashPtr;
    private boolean wasClosed;
    private URL imageURL;
    private static SplashScreen theInstance = null;

    SplashScreen(long l) {
        this.splashPtr = l;
        this.wasClosed = false;
    }

    public static synchronized SplashScreen getSplashScreen() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (theInstance == null) {
            AccessController.doPrivileged(new LoadLibraryAction("splashscreen"));
            long l = SplashScreen._getInstance();
            if (l == 0L) {
                return null;
            }
            if (!SplashScreen._isVisible(l)) {
                return null;
            }
            theInstance = new SplashScreen(l);
        }
        return theInstance.isVisible() ? theInstance : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageURL(URL uRL) throws NullPointerException, IOException, IllegalStateException {
        this.checkVisible();
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        int n = uRLConnection.getContentLength();
        InputStream inputStream = uRLConnection.getInputStream();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (true) {
            int n3;
            int n4;
            if ((n4 = inputStream.available()) <= 0) {
                n4 = 1;
            }
            if (n2 + n4 > n) {
                n = n2 * 2;
                if (n2 + n4 > n) {
                    n = n4 + n2;
                }
                byte[] byArray2 = byArray;
                byArray = new byte[n];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
            if ((n3 = inputStream.read(byArray, n2, n4)) < 0) break;
            n2 += n3;
        }
        SplashScreen splashScreen = this;
        synchronized (splashScreen) {
            if (!SplashScreen._setImageData(this.splashPtr, byArray)) {
                throw new IOException("Bad image format or i/o error when loading image");
            }
            this.imageURL = uRL;
        }
    }

    private void checkVisible() {
        if (!this.isVisible()) {
            throw new IllegalStateException("no splash screen available");
        }
    }

    public synchronized URL getImageURL() throws IllegalStateException {
        this.checkVisible();
        if (this.imageURL == null) {
            try {
                String string = SplashScreen._getImageFileName(this.splashPtr);
                String string2 = SplashScreen._getImageJarName(this.splashPtr);
                if (string != null) {
                    this.imageURL = string2 != null ? new URL("jar:" + new File(string2).toURL().toString() + "!/" + string) : new File(string).toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.imageURL;
    }

    public Rectangle getBounds() throws IllegalStateException {
        this.checkVisible();
        return SplashScreen._getBounds(this.splashPtr);
    }

    public Dimension getSize() throws IllegalStateException {
        return this.getBounds().getSize();
    }

    public Graphics2D createGraphics() throws IllegalStateException {
        if (this.image == null) {
            Dimension dimension = this.getSize();
            this.image = new BufferedImage(dimension.width, dimension.height, 2);
        }
        return this.image.createGraphics();
    }

    public void update() throws IllegalStateException {
        this.checkVisible();
        if (this.image == null) {
            throw new IllegalStateException("no overlay image available");
        }
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        if (!(dataBuffer instanceof DataBufferInt)) {
            throw new AssertionError((Object)("Overlay image DataBuffer is of invalid type == " + dataBuffer.getClass().getName()));
        }
        int n = dataBuffer.getNumBanks();
        if (n != 1) {
            throw new AssertionError((Object)("Invalid number of banks ==" + n + " in overlay image DataBuffer"));
        }
        if (!(this.image.getSampleModel() instanceof SinglePixelPackedSampleModel)) {
            throw new AssertionError((Object)("Overlay image has invalid sample model == " + this.image.getSampleModel().getClass().getName()));
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.image.getSampleModel();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        Rectangle rectangle = this.image.getRaster().getBounds();
        int[] nArray = ((DataBufferInt)dataBuffer).getData();
        SplashScreen._update(this.splashPtr, nArray, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
    }

    public synchronized void close() throws IllegalStateException {
        this.checkVisible();
        SplashScreen._close(this.splashPtr);
        this.image = null;
        this.wasClosed = true;
    }

    public boolean isVisible() {
        return !this.wasClosed && SplashScreen._isVisible(this.splashPtr);
    }

    private static native void _update(long var0, int[] var2, int var3, int var4, int var5, int var6, int var7);

    private static native boolean _isVisible(long var0);

    private static native Rectangle _getBounds(long var0);

    private static native long _getInstance();

    private static native void _close(long var0);

    private static native String _getImageFileName(long var0);

    private static native String _getImageJarName(long var0);

    private static native boolean _setImageData(long var0, byte[] var2);
}

