/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.image.SunWritableRaster;
import sun.awt.image.SurfaceManager;
import sun.java2d.SurfaceData;

public class ImagingLib {
    static boolean useLib = true;
    static boolean verbose = false;
    private static final int NUM_NATIVE_OPS = 3;
    private static final int LOOKUP_OP = 0;
    private static final int AFFINE_OP = 1;
    private static final int CONVOLVE_OP = 2;
    private static Class[] nativeOpClass = new Class[3];

    private static native boolean init();

    public static native int transformBI(BufferedImage var0, BufferedImage var1, double[] var2, int var3);

    public static native int transformRaster(Raster var0, Raster var1, double[] var2, int var3);

    public static native int convolveBI(BufferedImage var0, BufferedImage var1, Kernel var2, int var3);

    public static native int convolveRaster(Raster var0, Raster var1, Kernel var2, int var3);

    public static native int lookupByteBI(BufferedImage var0, BufferedImage var1, byte[][] var2);

    public static native int lookupByteRaster(Raster var0, Raster var1, byte[][] var2);

    private static int getNativeOpIndex(Class clazz) {
        int n = -1;
        for (int i = 0; i < 3; ++i) {
            if (clazz != nativeOpClass[i]) continue;
            n = i;
            break;
        }
        return n;
    }

    public static WritableRaster filter(RasterOp rasterOp, Raster raster, WritableRaster writableRaster) {
        if (!useLib) {
            return null;
        }
        if (writableRaster == null) {
            writableRaster = rasterOp.createCompatibleDestRaster(raster);
        }
        WritableRaster writableRaster2 = null;
        switch (ImagingLib.getNativeOpIndex(rasterOp.getClass())) {
            case 0: {
                ByteLookupTable byteLookupTable;
                LookupTable lookupTable = ((LookupOp)rasterOp).getTable();
                if (lookupTable.getOffset() != 0) {
                    return null;
                }
                if (!(lookupTable instanceof ByteLookupTable) || ImagingLib.lookupByteRaster(raster, writableRaster, (byteLookupTable = (ByteLookupTable)lookupTable).getTable()) <= 0) break;
                writableRaster2 = writableRaster;
                break;
            }
            case 1: {
                AffineTransformOp affineTransformOp = (AffineTransformOp)rasterOp;
                double[] dArray = new double[6];
                affineTransformOp.getTransform().getMatrix(dArray);
                if (ImagingLib.transformRaster(raster, writableRaster, dArray, affineTransformOp.getInterpolationType()) <= 0) break;
                writableRaster2 = writableRaster;
                break;
            }
            case 2: {
                ConvolveOp convolveOp = (ConvolveOp)rasterOp;
                if (ImagingLib.convolveRaster(raster, writableRaster, convolveOp.getKernel(), convolveOp.getEdgeCondition()) <= 0) break;
                writableRaster2 = writableRaster;
                break;
            }
        }
        if (writableRaster2 instanceof SunWritableRaster) {
            ((SunWritableRaster)writableRaster2).notifyChanged();
        }
        return writableRaster2;
    }

    public static BufferedImage filter(BufferedImageOp bufferedImageOp, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        Object object2;
        if (verbose) {
            System.out.println("in filter and op is " + bufferedImageOp + "bufimage is " + bufferedImage + " and " + bufferedImage2);
        }
        if (!useLib) {
            return null;
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = bufferedImageOp.createCompatibleDestImage(bufferedImage, null);
        }
        BufferedImage bufferedImage3 = null;
        switch (ImagingLib.getNativeOpIndex(bufferedImageOp.getClass())) {
            case 0: {
                object2 = ((LookupOp)bufferedImageOp).getTable();
                if (((LookupTable)object2).getOffset() != 0) {
                    return null;
                }
                if (!(object2 instanceof ByteLookupTable) || ImagingLib.lookupByteBI(bufferedImage, bufferedImage2, ((ByteLookupTable)(object = (ByteLookupTable)object2)).getTable()) <= 0) break;
                bufferedImage3 = bufferedImage2;
                break;
            }
            case 1: {
                object = (AffineTransformOp)bufferedImageOp;
                double[] dArray = new double[6];
                AffineTransform affineTransform = ((AffineTransformOp)object).getTransform();
                ((AffineTransformOp)object).getTransform().getMatrix(dArray);
                if (ImagingLib.transformBI(bufferedImage, bufferedImage2, dArray, ((AffineTransformOp)object).getInterpolationType()) <= 0) break;
                bufferedImage3 = bufferedImage2;
                break;
            }
            case 2: {
                ConvolveOp convolveOp = (ConvolveOp)bufferedImageOp;
                if (ImagingLib.convolveBI(bufferedImage, bufferedImage2, convolveOp.getKernel(), convolveOp.getEdgeCondition()) <= 0) break;
                bufferedImage3 = bufferedImage2;
                break;
            }
        }
        if (bufferedImage3 != null) {
            object2 = SurfaceManager.getManager(bufferedImage3);
            object = ((SurfaceManager)object2).getDestSurfaceData();
            ((SurfaceData)object).setNeedsBackup(true);
        }
        return bufferedImage3;
    }

    static {
        PrivilegedAction<Boolean> privilegedAction = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String string = System.getProperty("os.arch");
                if (string == null || !string.startsWith("sparc")) {
                    try {
                        System.loadLibrary("mlib_image");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        return Boolean.FALSE;
                    }
                }
                boolean bl = ImagingLib.init();
                return bl;
            }
        };
        useLib = AccessController.doPrivileged(privilegedAction);
        try {
            ImagingLib.nativeOpClass[0] = Class.forName("java.awt.image.LookupOp");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find class: " + classNotFoundException);
        }
        try {
            ImagingLib.nativeOpClass[1] = Class.forName("java.awt.image.AffineTransformOp");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find class: " + classNotFoundException);
        }
        try {
            ImagingLib.nativeOpClass[2] = Class.forName("java.awt.image.ConvolveOp");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find class: " + classNotFoundException);
        }
    }
}

