/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.action.GetPropertyAction;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.LDAPCertStore;
import sun.security.util.Cache;
import sun.security.util.Debug;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.DistributionPointName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IssuingDistributionPointExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.RDN;
import sun.security.x509.ReasonFlags;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DistributionPointFetcher {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private static final boolean USE_CRLDP = DistributionPointFetcher.getBooleanProperty("com.sun.security.enableCRLDP", false);
    private static final DistributionPointFetcher INSTANCE = new DistributionPointFetcher();
    private static final int CHECK_INTERVAL = 30000;
    private static final int CACHE_SIZE = 185;
    private final CertificateFactory factory;
    private final Cache cache;

    public static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = AccessController.doPrivileged(new GetPropertyAction(string));
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("Value of " + string + " must either be 'true' or 'false'");
    }

    private DistributionPointFetcher() {
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException();
        }
        this.cache = Cache.newSoftMemoryCache(185);
    }

    static DistributionPointFetcher getInstance() {
        return INSTANCE;
    }

    Collection<X509CRL> getCRLs(CRLSelector cRLSelector, PublicKey publicKey, String string, List<CertStore> list, boolean[] blArray) throws CertStoreException {
        if (!USE_CRLDP) {
            return Collections.emptySet();
        }
        if (!(cRLSelector instanceof X509CRLSelector)) {
            return Collections.emptySet();
        }
        X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
        X509Certificate x509Certificate = x509CRLSelector.getCertificateChecking();
        if (x509Certificate == null) {
            return Collections.emptySet();
        }
        try {
            CRLDistributionPointsExtension cRLDistributionPointsExtension;
            X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
            if (debug != null) {
                debug.println("DistributionPointFetcher.getCRLs: Checking CRLDPs for " + x509CertImpl.getSubjectX500Principal());
            }
            if ((cRLDistributionPointsExtension = x509CertImpl.getCRLDistributionPointsExtension()) == null) {
                if (debug != null) {
                    debug.println("No CRLDP ext");
                }
                return Collections.emptySet();
            }
            List list2 = (List)cRLDistributionPointsExtension.get("points");
            HashSet<X509CRL> hashSet = new HashSet<X509CRL>();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext() && !Arrays.equals(blArray, ALL_REASONS)) {
                DistributionPoint distributionPoint = (DistributionPoint)iterator.next();
                Collection<X509CRL> collection = this.getCRLs(x509CRLSelector, x509CertImpl, distributionPoint, blArray, publicKey, string, list);
                hashSet.addAll(collection);
            }
            if (debug != null) {
                debug.println("Returning " + hashSet.size() + " CRLs");
            }
            return hashSet;
        }
        catch (CertificateException certificateException) {
            return Collections.emptySet();
        }
        catch (IOException iOException) {
            return Collections.emptySet();
        }
    }

    private Collection<X509CRL> getCRLs(X509CRLSelector x509CRLSelector, X509CertImpl x509CertImpl, DistributionPoint distributionPoint, boolean[] blArray, PublicKey publicKey, String string, List<CertStore> list) {
        GeneralNames generalNames = distributionPoint.getFullName();
        if (generalNames == null) {
            return Collections.emptySet();
        }
        ArrayList<X509CRL> arrayList = new ArrayList<X509CRL>();
        ArrayList<X509CRL> arrayList2 = new ArrayList<X509CRL>(2);
        Iterator<GeneralName> iterator = generalNames.iterator();
        while (iterator.hasNext()) {
            X509CRL x509CRL;
            GeneralNameInterface generalNameInterface;
            GeneralName object = iterator.next();
            if (object.getType() == 4) {
                generalNameInterface = (X500Name)object.getName();
                arrayList.addAll(this.getCRLs((X500Name)generalNameInterface, x509CertImpl.getIssuerX500Principal(), list));
                continue;
            }
            if (object.getType() != 6 || (x509CRL = this.getCRL((URIName)(generalNameInterface = (URIName)object.getName()))) == null) continue;
            arrayList.add(x509CRL);
        }
        for (X509CRL x509CRL : arrayList) {
            try {
                x509CRLSelector.setIssuerNames(null);
                if (!x509CRLSelector.match(x509CRL) || !this.verifyCRL(x509CertImpl, distributionPoint, x509CRL, blArray, publicKey, string)) continue;
                arrayList2.add(x509CRL);
            }
            catch (Exception exception) {
                if (debug == null) continue;
                debug.println("Exception verifying CRL: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return arrayList2;
    }

    private X509CRL getCRL(URIName uRIName) {
        URI uRI = uRIName.getURI();
        if (debug != null) {
            debug.println("Trying to fetch CRL from DP " + uRI);
        }
        if (uRI.getScheme().toLowerCase().equals("ldap")) {
            String string = uRI.getPath();
            if (debug != null) {
                debug.println("authority:" + uRI.getAuthority());
                debug.println("path:" + string);
            }
            if (string.charAt(0) == '/') {
                string = string.substring(1);
            }
            try {
                LDAPCertStore.LDAPCRLSelector lDAPCRLSelector = new LDAPCertStore.LDAPCRLSelector();
                lDAPCRLSelector.addIssuerName(string);
                CertStore certStore = LDAPCertStore.getInstance(LDAPCertStore.getParameters(uRI));
                Collection<? extends CRL> collection = certStore.getCRLs(lDAPCRLSelector);
                if (collection.isEmpty()) {
                    return null;
                }
                return (X509CRL)collection.iterator().next();
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.println("Exception getting CRL from CertStore: " + exception);
                    exception.printStackTrace();
                }
                return null;
            }
        }
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(uRI);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            this.cache.put(uRI, cacheEntry);
        }
        return cacheEntry.getCRL(this.factory, uRI);
    }

    private Collection<X509CRL> getCRLs(X500Name x500Name, X500Principal x500Principal, List<CertStore> list) {
        if (debug != null) {
            debug.println("Trying to fetch CRL from DP " + x500Name);
        }
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        x509CRLSelector.addIssuer(x500Name.asX500Principal());
        x509CRLSelector.addIssuer(x500Principal);
        ArrayList<X509CRL> arrayList = new ArrayList<X509CRL>();
        for (CertStore certStore : list) {
            try {
                arrayList.addAll(certStore.getCRLs(x509CRLSelector));
            }
            catch (CertStoreException certStoreException) {
                if (debug == null) continue;
                debug.println("Non-fatal exception while retrieving CRLs: " + certStoreException);
                certStoreException.printStackTrace();
            }
        }
        return arrayList;
    }

    boolean verifyCRL(X509CertImpl x509CertImpl, DistributionPoint distributionPoint, X509CRL x509CRL, boolean[] blArray, PublicKey publicKey, String string) throws CRLException, IOException {
        Iterator<String> iterator;
        Object object;
        Object object2;
        X509CRLImpl x509CRLImpl = X509CRLImpl.toImpl(x509CRL);
        IssuingDistributionPointExtension issuingDistributionPointExtension = x509CRLImpl.getIssuingDistributionPointExtension();
        X500Name x500Name = (X500Name)x509CertImpl.getIssuerDN();
        X500Name x500Name2 = (X500Name)x509CRLImpl.getIssuerDN();
        try {
            AlgorithmChecker.check(x509CRL);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            if (debug != null) {
                debug.println("CRL signature algorithm check failed: " + certPathValidatorException);
            }
            return false;
        }
        GeneralNames generalNames = distributionPoint.getCRLIssuer();
        if (generalNames != null) {
            if (issuingDistributionPointExtension == null || ((Boolean)issuingDistributionPointExtension.get("indirect_crl")).equals(Boolean.FALSE)) {
                return false;
            }
            boolean bl = false;
            object2 = generalNames.iterator();
            while (!bl && object2.hasNext()) {
                object = ((GeneralName)object2.next()).getName();
                if (!x500Name2.equals(object)) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
        } else if (!x500Name2.equals(x500Name)) {
            if (debug != null) {
                debug.println("crl issuer does not equal cert issuer");
            }
            return false;
        }
        if (issuingDistributionPointExtension != null) {
            DistributionPointName distributionPointName = (DistributionPointName)issuingDistributionPointExtension.get("point");
            if (distributionPointName != null) {
                Object object3;
                Object object4;
                object2 = distributionPointName.getFullName();
                if (object2 == null) {
                    object = distributionPointName.getRelativeName();
                    if (object == null) {
                        if (debug != null) {
                            debug.println("IDP must be relative or full DN");
                        }
                        return false;
                    }
                    if (debug != null) {
                        debug.println("IDP relativeName:" + object);
                    }
                    object2 = this.getFullNames(x500Name2, (RDN)object);
                }
                if (distributionPoint.getFullName() != null || distributionPoint.getRelativeName() != null) {
                    object = distributionPoint.getFullName();
                    if (object == null) {
                        RDN rDN = distributionPoint.getRelativeName();
                        if (rDN == null) {
                            if (debug != null) {
                                debug.println("DP must be relative or full DN");
                            }
                            return false;
                        }
                        if (debug != null) {
                            debug.println("DP relativeName:" + rDN);
                        }
                        object = this.getFullNames(x500Name, rDN);
                    }
                    boolean bl = false;
                    object4 = ((GeneralNames)object2).iterator();
                    while (!bl && object4.hasNext()) {
                        iterator = object4.next().getName();
                        if (debug != null) {
                            debug.println("idpName: " + iterator);
                        }
                        object3 = ((GeneralNames)object).iterator();
                        while (!bl && object3.hasNext()) {
                            GeneralNameInterface generalNameInterface = ((GeneralName)object3.next()).getName();
                            if (debug != null) {
                                debug.println("pointName: " + generalNameInterface);
                            }
                            bl = iterator.equals(generalNameInterface);
                        }
                    }
                    if (!bl) {
                        if (debug != null) {
                            debug.println("IDP name does not match DP name");
                        }
                        return false;
                    }
                } else {
                    boolean bl = false;
                    Iterator<GeneralName> iterator2 = generalNames.iterator();
                    while (!bl && iterator2.hasNext()) {
                        object4 = iterator2.next().getName();
                        iterator = ((GeneralNames)object2).iterator();
                        while (!bl && iterator.hasNext()) {
                            object3 = ((GeneralName)iterator.next()).getName();
                            bl = object4.equals(object3);
                        }
                    }
                    if (!bl) {
                        return false;
                    }
                }
            }
            if (((Boolean)(object2 = (Boolean)issuingDistributionPointExtension.get("only_user_certs"))).equals(Boolean.TRUE) && x509CertImpl.getBasicConstraints() != -1) {
                if (debug != null) {
                    debug.println("cert must be a EE cert");
                }
                return false;
            }
            object2 = (Boolean)issuingDistributionPointExtension.get("only_ca_certs");
            if (((Boolean)object2).equals(Boolean.TRUE) && x509CertImpl.getBasicConstraints() == -1) {
                if (debug != null) {
                    debug.println("cert must be a CA cert");
                }
                return false;
            }
            object2 = (Boolean)issuingDistributionPointExtension.get("only_attribute_certs");
            if (((Boolean)object2).equals(Boolean.TRUE)) {
                if (debug != null) {
                    debug.println("cert must not be an AA cert");
                }
                return false;
            }
        }
        boolean[] blArray2 = new boolean[9];
        object2 = null;
        if (issuingDistributionPointExtension != null) {
            object2 = (ReasonFlags)issuingDistributionPointExtension.get("reasons");
        }
        boolean[] blArray3 = distributionPoint.getReasonFlags();
        if (object2 != null) {
            if (blArray3 != null) {
                boolean[] blArray4 = ((ReasonFlags)object2).getFlags();
                for (int i = 0; i < blArray4.length; ++i) {
                    if (!blArray4[i] || !blArray3[i]) continue;
                    blArray2[i] = true;
                }
            } else {
                blArray2 = (boolean[])((ReasonFlags)object2).getFlags().clone();
            }
        } else if (issuingDistributionPointExtension == null || object2 == null) {
            if (blArray3 != null) {
                blArray2 = (boolean[])blArray3.clone();
            } else {
                blArray2 = new boolean[9];
                Arrays.fill(blArray2, true);
            }
        }
        boolean bl = false;
        for (int i = 0; i < blArray2.length && !bl; ++i) {
            if (blArray[i] || !blArray2[i]) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            x509CRL.verify(publicKey, string);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("CRL signature failed to verify");
            }
            return false;
        }
        Set<String> set = x509CRL.getCriticalExtensionOIDs();
        if (set != null) {
            set.remove(PKIXExtensions.IssuingDistributionPoint_Id.toString());
            if (!set.isEmpty()) {
                if (debug != null) {
                    debug.println("Unrecognized critical extension(s) in CRL: " + set);
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        debug.println(iterator.next());
                    }
                }
                return false;
            }
        }
        for (int i = 0; i < blArray2.length; ++i) {
            if (blArray[i] || !blArray2[i]) continue;
            blArray[i] = true;
        }
        return true;
    }

    private GeneralNames getFullNames(X500Name x500Name, RDN rDN) throws IOException {
        ArrayList<RDN> arrayList = new ArrayList<RDN>(x500Name.rdns());
        arrayList.add(rDN);
        X500Name x500Name2 = new X500Name(arrayList.toArray(new RDN[0]));
        GeneralNames generalNames = new GeneralNames();
        generalNames.add(new GeneralName(x500Name2));
        return generalNames;
    }

    private static class CacheEntry {
        private X509CRL crl;
        private long lastChecked;
        private long lastModified;

        CacheEntry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        synchronized X509CRL getCRL(CertificateFactory certificateFactory, URI uRI) {
            long l = System.currentTimeMillis();
            if (l - this.lastChecked < 30000L) {
                if (debug == null) return this.crl;
                debug.println("Returning CRL from cache");
                return this.crl;
            }
            this.lastChecked = l;
            InputStream inputStream = null;
            try {
                Object object;
                URL uRL = uRI.toURL();
                URLConnection uRLConnection = uRL.openConnection();
                if (this.lastModified != 0L) {
                    uRLConnection.setIfModifiedSince(this.lastModified);
                }
                inputStream = uRLConnection.getInputStream();
                long l2 = this.lastModified;
                this.lastModified = uRLConnection.getLastModified();
                if (l2 != 0L) {
                    if (l2 == this.lastModified) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        X509CRL x509CRL = this.crl;
                        return x509CRL;
                    }
                    if (uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)(object = (HttpURLConnection)uRLConnection)).getResponseCode() == 304) {
                        if (debug != null) {
                            debug.println("Not modified, using cached copy");
                        }
                        X509CRL x509CRL = this.crl;
                        return x509CRL;
                    }
                }
                if (debug != null) {
                    debug.println("Downloading new CRL...");
                }
                this.crl = (X509CRL)certificateFactory.generateCRL(inputStream);
                object = this.crl;
                return object;
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("Exception fetching CRLDP:");
                    iOException.printStackTrace();
                }
            }
            catch (CRLException cRLException) {
                if (debug != null) {
                    debug.println("Exception fetching CRLDP:");
                    cRLException.printStackTrace();
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.lastModified = 0L;
            this.crl = null;
            return null;
        }
    }
}

