/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XRenderDirectFormat;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XRenderPictFormat
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 32 : 40;
    }

    public int getDataSize() {
        return XRenderPictFormat.getSize();
    }

    public long getPData() {
        return this.pData;
    }

    XRenderPictFormat(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    XRenderPictFormat() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XRenderPictFormat.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_id() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_id(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public int get_type() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_type(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), n);
    }

    public int get_depth() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 12));
    }

    public void set_depth(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 12), n);
    }

    public XRenderDirectFormat get_direct() {
        log.finest("");
        return new XRenderDirectFormat(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 16));
    }

    public long get_colormap() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 32));
    }

    public void set_colormap(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 32), l);
    }

    String getName() {
        return "XRenderPictFormat";
    }

    String getFieldsAsString() {
        String string = "";
        string = string + "id = " + this.get_id() + ", ";
        string = string + "type = " + XlibWrapper.eventToString[this.get_type()] + ", ";
        string = string + "depth = " + this.get_depth() + ", ";
        string = string + "direct = " + this.get_direct() + ", ";
        string = string + "colormap = " + this.get_colormap() + ", ";
        return string;
    }
}

