/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;
import java.util.NoSuchElementException;

class RoundRectIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    double aw;
    double ah;
    AffineTransform affine;
    int index;
    private static final double angle = 0.7853981633974483;
    private static final double a = 1.0 - Math.cos(0.7853981633974483);
    private static final double b = Math.tan(0.7853981633974483);
    private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
    private static final double cv = 1.3333333333333333 * a * b / c;
    private static final double acv = (1.0 - cv) / 2.0;
    private static double[][] ctrlpts = new double[][]{{0.0, 0.0, 0.0, 0.5}, {0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 1.0, -acv, 0.0, acv, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0}, {1.0, -0.5, 1.0, 0.0}, {1.0, -acv, 1.0, 0.0, 1.0, 0.0, 1.0, -acv, 1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 0.0, acv, 1.0, -acv, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}, {0.0, acv, 0.0, 0.0, 0.0, 0.0, 0.0, acv, 0.0, 0.0, 0.0, 0.5}, new double[0]};
    private static int[] types = new int[]{0, 1, 3, 1, 3, 1, 3, 1, 3, 4};

    RoundRectIterator(RoundRectangle2D roundRectangle2D, AffineTransform affineTransform) {
        this.x = roundRectangle2D.getX();
        this.y = roundRectangle2D.getY();
        this.w = roundRectangle2D.getWidth();
        this.h = roundRectangle2D.getHeight();
        this.aw = Math.min(this.w, Math.abs(roundRectangle2D.getArcWidth()));
        this.ah = Math.min(this.h, Math.abs(roundRectangle2D.getArcHeight()));
        this.affine = affineTransform;
        if (this.aw < 0.0 || this.ah < 0.0) {
            this.index = ctrlpts.length;
        }
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.index >= ctrlpts.length;
    }

    public void next() {
        ++this.index;
    }

    public int currentSegment(float[] fArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("roundrect iterator out of bounds");
        }
        double[] dArray = ctrlpts[this.index];
        int n = 0;
        for (int i = 0; i < dArray.length; i += 4) {
            fArray[n++] = (float)(this.x + dArray[i + 0] * this.w + dArray[i + 1] * this.aw);
            fArray[n++] = (float)(this.y + dArray[i + 2] * this.h + dArray[i + 3] * this.ah);
        }
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, n / 2);
        }
        return types[this.index];
    }

    public int currentSegment(double[] dArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("roundrect iterator out of bounds");
        }
        double[] dArray2 = ctrlpts[this.index];
        int n = 0;
        for (int i = 0; i < dArray2.length; i += 4) {
            dArray[n++] = this.x + dArray2[i + 0] * this.w + dArray2[i + 1] * this.aw;
            dArray[n++] = this.y + dArray2[i + 2] * this.h + dArray2[i + 3] * this.ah;
        }
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, n / 2);
        }
        return types[this.index];
    }
}

