/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.BrowserKeystore;
import com.sun.deploy.security.MozillaJSSDSAPrivateKey;
import com.sun.deploy.security.MozillaJSSPrivateKey;
import com.sun.deploy.security.MozillaJSSRSAPrivateKey;
import com.sun.deploy.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecurityPermission;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

public final class MozillaMyKeyStore
extends KeyStoreSpi {
    private Collection keyEntries = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (cArray != null && cArray.length > 0) {
            throw new UnrecoverableKeyException("Password is not required for Mozilla MY keystore.");
        }
        if (!this.engineIsKeyEntry(string)) {
            return null;
        }
        Iterator iterator = this.keyEntries.iterator();
        while (iterator.hasNext()) {
            KeyEntry keyEntry = (KeyEntry)iterator.next();
            if (!string.equals(keyEntry.getAlias())) continue;
            return keyEntry.getPrivateKey();
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Iterator iterator = this.keyEntries.iterator();
        while (iterator.hasNext()) {
            KeyEntry keyEntry = (KeyEntry)iterator.next();
            if (!string.equals(keyEntry.getAlias())) continue;
            X509Certificate[] x509CertificateArray = keyEntry.getCertificateChain();
            Certificate[] certificateArray = (X509Certificate[])x509CertificateArray.clone();
            return certificateArray;
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        Iterator iterator = this.keyEntries.iterator();
        while (iterator.hasNext()) {
            KeyEntry keyEntry = (KeyEntry)iterator.next();
            if (!string.equals(keyEntry.getAlias())) continue;
            X509Certificate[] x509CertificateArray = keyEntry.getCertificateChain();
            return x509CertificateArray[0];
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        return new Date();
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given key to the given alias.");
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given key to the given alias.");
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given certificate to the given alias.");
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        throw new KeyStoreException("Mozilla does not support alias removal.");
    }

    public Enumeration engineAliases() {
        final Iterator iterator = this.keyEntries.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                KeyEntry keyEntry = (KeyEntry)iterator.next();
                return keyEntry.getAlias();
            }
        };
    }

    public boolean engineContainsAlias(String string) {
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public int engineSize() {
        return this.keyEntries.size();
    }

    public boolean engineIsKeyEntry(String string) {
        return string.startsWith("MozillaJSSRSAPrivateKey") || string.startsWith("MozillaJSSDSAPrivateKey");
    }

    public boolean engineIsCertificateEntry(String string) {
        return false;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Iterator iterator = this.keyEntries.iterator();
        while (iterator.hasNext()) {
            KeyEntry keyEntry = (KeyEntry)iterator.next();
            if (keyEntry.certChain == null || !keyEntry.certChain[0].equals(certificate)) continue;
            return keyEntry.getAlias();
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("Mozilla cert store cannot be stored into stream.");
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("authProvider.SunDeploy-MozillaJSS"));
        }
        if (inputStream != null) {
            throw new IOException("Mozilla cert store cannot be loaded from stream.");
        }
        this.keyEntries.clear();
        try {
            Class<?> clazz = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
            Object object = BrowserKeystore.getJSSCryptoManager();
            Method method = clazz.getMethod("getInternalKeyStorageToken", null);
            Object object2 = method.invoke(object, null);
            this.generateKeyAndCertificateFromToken(object, object2);
            Method method2 = clazz.getMethod("getExternalTokens", null);
            Enumeration enumeration = (Enumeration)method2.invoke(object, null);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.generateKeyAndCertificateFromToken(object, e);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void generateKeyAndCertificateFromToken(Object object, Object object2) throws Throwable {
        Class<?> clazz = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
        Class<?> clazz2 = Class.forName("org.mozilla.jss.crypto.CryptoToken", true, ClassLoader.getSystemClassLoader());
        Method method = clazz2.getMethod("getCryptoStore", null);
        Object object3 = method.invoke(object2, null);
        Class<?> clazz3 = Class.forName("org.mozilla.jss.crypto.CryptoStore", true, ClassLoader.getSystemClassLoader());
        Method method2 = clazz3.getMethod("getCertificates", null);
        Object[] objectArray = (Object[])method2.invoke(object3, null);
        for (int i = 0; i < objectArray.length; ++i) {
            Field field;
            Object[] objectArray2;
            Class<?> clazz4 = Class.forName("org.mozilla.jss.crypto.X509Certificate", true, ClassLoader.getSystemClassLoader());
            Method method3 = clazz4.getMethod("getNickname", null);
            String string = (String)method3.invoke(objectArray[i], null);
            if (string == null) continue;
            Class<?> clazz5 = Class.forName("org.mozilla.jss.CryptoManager$CertUsage", true, ClassLoader.getSystemClassLoader());
            Class[] classArray = new Class[]{class$java$lang$String == null ? MozillaMyKeyStore.class$("java.lang.String") : class$java$lang$String, Boolean.TYPE, clazz5};
            Method method4 = clazz.getMethod("isCertValid", classArray);
            Boolean bl = (Boolean)method4.invoke(object, objectArray2 = new Object[]{string, Boolean.FALSE, (field = clazz5.getField("SSLClient")).get(objectArray[i])});
            if (!bl.booleanValue()) continue;
            try {
                Object object4;
                Class[] classArray2 = new Class[]{clazz4};
                Method method5 = clazz.getMethod("findPrivKeyByCert", classArray2);
                Object[] objectArray3 = new Object[]{objectArray[i]};
                Object object5 = method5.invoke(object, objectArray3);
                Class<?> clazz6 = Class.forName("org.mozilla.jss.crypto.PrivateKey", true, ClassLoader.getSystemClassLoader());
                Method method6 = clazz6.getMethod("getType", null);
                Object object6 = method6.invoke(object5, null);
                Class<?> clazz7 = Class.forName("org.mozilla.jss.crypto.PrivateKey$Type", true, ClassLoader.getSystemClassLoader());
                Field field2 = clazz7.getField("RSA");
                Field field3 = clazz7.getField("DSA");
                Object object7 = field2.get(null);
                Object object8 = field3.get(null);
                if (!object6.equals(object7) && !object6.equals(object8)) continue;
                Class[] classArray3 = new Class[]{clazz4};
                Method method7 = clazz.getMethod("buildCertificateChain", classArray3);
                Object[] objectArray4 = new Object[]{objectArray[i]};
                Object[] objectArray5 = (Object[])method7.invoke(object, objectArray4);
                ArrayList arrayList = new ArrayList();
                for (int j = 0; j < objectArray5.length; ++j) {
                    object4 = clazz4.getMethod("getEncoded", null);
                    Object object9 = ((Method)object4).invoke(objectArray5[j], null);
                    this.generateCertificate((byte[])object9, arrayList);
                }
                Method method8 = clazz6.getMethod("getStrength", null);
                object4 = (Integer)method8.invoke(object5, null);
                if (object6.equals(object7)) {
                    this.generateRSAKeyAndCertificateChain(object5, (Integer)object4, arrayList, this.keyEntries);
                    continue;
                }
                this.generateDSAKeyAndCertificateChain(object5, (Integer)object4, arrayList, this.keyEntries);
                continue;
            }
            catch (Throwable throwable) {
                Trace.msgSecurityPrintln("mozillamykeystore.priv.notfound", new Object[]{string});
            }
        }
    }

    private void generateRSAKeyAndCertificateChain(Object object, int n, Collection collection, Collection collection2) {
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
            int n2 = 0;
            Object object2 = collection.iterator();
            while (object2.hasNext()) {
                x509CertificateArray[n2] = (X509Certificate)object2.next();
                ++n2;
            }
            object2 = new KeyEntry(new MozillaJSSRSAPrivateKey(object, n), x509CertificateArray);
            collection2.add(object2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void generateDSAKeyAndCertificateChain(Object object, int n, Collection collection, Collection collection2) {
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
            int n2 = 0;
            Object object2 = collection.iterator();
            while (object2.hasNext()) {
                x509CertificateArray[n2] = (X509Certificate)object2.next();
                ++n2;
            }
            object2 = new KeyEntry(new MozillaJSSDSAPrivateKey(object, n), x509CertificateArray);
            collection2.add(object2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void generateCertificate(byte[] byArray, Collection collection) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection2 = certificateFactory.generateCertificates(byteArrayInputStream);
            Iterator<? extends Certificate> iterator = collection2.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                collection.add(x509Certificate);
            }
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected String getName() {
        return "MY";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class KeyEntry {
        private MozillaJSSPrivateKey privateKey;
        private X509Certificate[] certChain;

        KeyEntry(MozillaJSSPrivateKey mozillaJSSPrivateKey, X509Certificate[] x509CertificateArray) {
            this.privateKey = mozillaJSSPrivateKey;
            this.certChain = x509CertificateArray;
        }

        String getAlias() {
            return this.privateKey.toString();
        }

        Key getPrivateKey() {
            return this.privateKey;
        }

        X509Certificate[] getCertificateChain() {
            return this.certChain;
        }
    }
}

