/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.CertFileFilter;
import com.sun.deploy.panel.CertificateTabPanel;
import com.sun.deploy.panel.CertificatesInfo;
import com.sun.deploy.panel.ReadOnlyTableModel;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sun.misc.BASE64Encoder;

public class CertificatesDialog
extends JDialog
implements ListSelectionListener,
ChangeListener {
    public static final int USER_LEVEL = 0;
    public static final int SYSTEM_LEVEL = 1;
    private JComboBox certsComboBox;
    private JButton importButton;
    private JButton exportButton;
    private JButton removeButton;
    private JButton detailsButton;
    private JButton closeButton;
    private CertificatesInfo model;
    private JTabbedPane tabbedPane;
    private CertificateTabPanel userTab;
    private CertificateTabPanel systemTab;
    private String strTrustedCerts = CertificatesDialog.getMessage("cert.type.trusted_certs");
    private String strSecureSite = CertificatesDialog.getMessage("cert.type.secure_site");
    private String strSignerCa = CertificatesDialog.getMessage("cert.type.signer_ca");
    private String strSecureSiteCa = CertificatesDialog.getMessage("cert.type.secure_site_ca");
    private String strClientAuth = CertificatesDialog.getMessage("cert.type.client_auth");
    private String[] certTypeName = new String[]{this.strTrustedCerts, this.strSecureSite, this.strSignerCa, this.strSecureSiteCa, this.strClientAuth};

    public CertificatesDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.model = new CertificatesInfo();
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle(CertificatesDialog.getMessage("cert.settings"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CertificatesDialog.this.closeDialog(windowEvent);
            }
        });
        JPanel jPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = 300;
                if (dimension.width < 500) {
                    dimension.width = 500;
                }
                return dimension;
            }
        };
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        jPanel3.add(Box.createHorizontalStrut(60));
        this.certsComboBox = new JComboBox();
        this.certsComboBox.setModel(new DefaultComboBoxModel<String>(this.certTypeName));
        this.certsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CertificatesDialog.this.certsComboBoxActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this.certsComboBox);
        jPanel2.add(new JLabel(CertificatesDialog.getMessage("cert.dialog.certtype")));
        jPanel2.add(jPanel3);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel.add(jPanel2);
        this.tabbedPane = new JTabbedPane();
        this.userTab = new CertificateTabPanel(this.model, 0);
        this.systemTab = new CertificateTabPanel(this.model, 1);
        this.userTab.registerSelectionListener(this);
        this.systemTab.registerSelectionListener(this);
        this.tabbedPane.setName(" ");
        this.tabbedPane.addTab(CertificatesDialog.getMessage("cert.dialog.user.level"), this.userTab);
        this.tabbedPane.addTab(CertificatesDialog.getMessage("cert.dialog.system.level"), this.systemTab);
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(this);
        jPanel.add(this.tabbedPane);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 10));
        this.importButton = new JButton(CertificatesDialog.getMessage("cert.import_button"));
        this.importButton.setMnemonic(ResourceManager.getVKCode("cert.import_button.mnemonic"));
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CertificatesDialog.this.importButtonActionPerformed(actionEvent);
            }
        });
        this.importButton.setToolTipText(CertificatesDialog.getMessage("cert.import_btn.tooltip"));
        jPanel4.add(this.importButton);
        this.exportButton = new JButton(CertificatesDialog.getMessage("cert.export_button"));
        this.exportButton.setMnemonic(ResourceManager.getVKCode("cert.export_button.mnemonic"));
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CertificatesDialog.this.exportButtonActionPerformed(actionEvent);
            }
        });
        this.exportButton.setToolTipText(CertificatesDialog.getMessage("cert.export_btn.tooltip"));
        jPanel4.add(this.exportButton);
        this.removeButton = new JButton(CertificatesDialog.getMessage("cert.remove_button"));
        this.removeButton.setMnemonic(ResourceManager.getVKCode("cert.remove_button.mnemonic"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CertificatesDialog.this.removeButtonActionPerformed(actionEvent);
            }
        });
        this.removeButton.setToolTipText(CertificatesDialog.getMessage("cert.remove_btn.tooltip"));
        jPanel4.add(this.removeButton);
        this.detailsButton = new JButton(CertificatesDialog.getMessage("cert.details_button"));
        this.detailsButton.setMnemonic(ResourceManager.getVKCode("cert.details_button.mnemonic"));
        this.detailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CertificatesDialog.this.detailsButtonActionPerformed(actionEvent);
            }
        });
        this.detailsButton.setToolTipText(CertificatesDialog.getMessage("cert.details_btn.tooltip"));
        jPanel4.add(this.detailsButton);
        JButton[] jButtonArray = new JButton[]{this.importButton, this.exportButton, this.detailsButton, this.removeButton};
        DialogTemplate.resizeButtons(jButtonArray);
        jPanel.add(jPanel4);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.closeButton = new JButton(CertificatesDialog.getMessage("cert.close_button"));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CertificatesDialog.this.closeButtonActionPerformed(actionEvent);
            }
        };
        this.closeButton.addActionListener(abstractAction);
        if (Config.isJavaVersionAtLeast13()) {
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            this.getRootPane().getActionMap().put("cancel", abstractAction);
        }
        jPanel5.add(this.closeButton);
        this.getContentPane().add((Component)jPanel5, "South");
        this.updateButtonState();
        this.getRootPane().setDefaultButton(this.closeButton);
        this.pack();
        this.setResizable(false);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.updateButtonState();
    }

    private void certsComboBoxActionPerformed(ActionEvent actionEvent) {
        this.reset();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void importButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        CertFileFilter certFileFilter = new CertFileFilter();
        certFileFilter.addExtension("csr");
        certFileFilter.addExtension("p12");
        certFileFilter.setDescription("Certificate Files");
        jFileChooser.setFileFilter(certFileFilter);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogType(0);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            try {
                InputStream inputStream = System.in;
                inputStream = new FileInputStream(file);
                boolean bl = false;
                bl = this.importCertificate(inputStream);
                if (!bl) {
                    InputStream inputStream2 = System.in;
                    inputStream2 = new FileInputStream(file);
                    String string = (String)this.certsComboBox.getSelectedItem();
                    if (string.equals(this.strClientAuth)) {
                        this.importPKCS12CertKey(inputStream2);
                    } else {
                        this.importPKCS12Certificate(inputStream2);
                    }
                }
            }
            catch (Throwable throwable) {
                String string = CertificatesDialog.getMessage("cert.dialog.import.file.masthead");
                String string2 = CertificatesDialog.getMessage("cert.dialog.import.file.text");
                String string3 = CertificatesDialog.getMessage("cert.dialog.import.error.caption");
                UIFactory.showExceptionDialog(this.getParent(), throwable, string, string2, string3);
            }
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.certsComboBox.getSelectedItem();
        int n = -1;
        int n2 = 0;
        if (this.isUserLevelSelected()) {
            n2 = 0;
            n = this.userTab.getSelectedCertificateTableRow();
        } else {
            n2 = 1;
            n = this.systemTab.getSelectedCertificateTableRow();
        }
        if (n == -1) return;
        Collection collection = null;
        X509Certificate x509Certificate = null;
        Certificate[] certificateArray = new Certificate[]{null};
        if (string.equals(this.strTrustedCerts)) {
            collection = this.model.getTrustedCertificates(n2);
        } else if (string.equals(this.strSecureSite)) {
            collection = this.model.getHttpsCertificates(n2);
        } else if (string.equals(this.strSignerCa)) {
            collection = this.model.getRootCACertificates(n2);
        } else if (string.equals(this.strSecureSiteCa)) {
            collection = this.model.getHttpsRootCACertificates(n2);
        } else if (string.equals(this.strClientAuth)) {
            collection = this.model.getClientAuthCertificates(n2);
        }
        Object[] objectArray = collection.toArray();
        if (string.equals(this.strClientAuth)) {
            certificateArray = (Certificate[])objectArray[n];
            x509Certificate = (X509Certificate)certificateArray[0];
        } else {
            x509Certificate = (X509Certificate)objectArray[n];
        }
        if (x509Certificate != null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogType(1);
            jFileChooser.setMultiSelectionEnabled(false);
            int n3 = jFileChooser.showSaveDialog(this);
            if (n3 != 0) return;
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            PrintStream printStream = null;
            try {
                block20: {
                    try {
                        if (string.equals(this.strClientAuth)) {
                            this.exportPKCS12Cert(certificateArray, file, n2);
                            break block20;
                        }
                        printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                        this.exportCertificate(x509Certificate, printStream);
                    }
                    catch (Throwable throwable) {
                        String string2 = CertificatesDialog.getMessage("cert.dialog.export.masthead");
                        String string3 = CertificatesDialog.getMessage("cert.dialog.export.text");
                        String string4 = CertificatesDialog.getMessage("cert.dialog.export.error.caption");
                        UIFactory.showExceptionDialog(this.getParent(), throwable, string2, string3, string4);
                        Object var18_16 = null;
                        if (printStream == null) return;
                        printStream.close();
                        return;
                    }
                }
                Object var18_15 = null;
                if (printStream == null) return;
                printStream.close();
                return;
            }
            catch (Throwable throwable) {
                Object var18_17 = null;
                if (printStream == null) throw throwable;
                printStream.close();
                throw throwable;
            }
        }
        String string5 = CertificatesDialog.getMessage("cert.dialog.export.text");
        String string6 = CertificatesDialog.getMessage("cert.dialog.export.error.caption");
        UIFactory.showErrorDialog(this, string5, string6);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        String string;
        String string2;
        String string3;
        int n;
        String string4 = (String)this.certsComboBox.getSelectedItem();
        int[] nArray = null;
        int n2 = 0;
        if (this.isUserLevelSelected()) {
            n2 = 0;
            nArray = this.userTab.getSelectedCertificateTableRows();
        } else {
            n2 = 1;
            nArray = this.systemTab.getSelectedCertificateTableRows();
        }
        if (nArray.length != 0 && (n = UIFactory.showWarningDialog(this, null, string3 = CertificatesDialog.getMessage("cert.dialog.remove.masthead"), string2 = CertificatesDialog.getMessage("cert.dialog.remove.text"), string = CertificatesDialog.getMessage("cert.dialog.remove.caption"))) == 0) {
            if (string4.equals(this.strTrustedCerts)) {
                Collection collection = this.model.getTrustedCertificates(n2);
                Object[] objectArray = collection.toArray();
                for (int i = 0; i < nArray.length; ++i) {
                    this.model.removeTrustedCertificate((Certificate)objectArray[nArray[i]]);
                }
            } else if (string4.equals(this.strSecureSite)) {
                Collection collection = this.model.getHttpsCertificates(n2);
                Object[] objectArray = collection.toArray();
                for (int i = 0; i < nArray.length; ++i) {
                    this.model.removeHttpsCertificate((Certificate)objectArray[nArray[i]]);
                }
            } else if (string4.equals(this.strSignerCa)) {
                Collection collection = this.model.getRootCACertificates(n2);
                Object[] objectArray = collection.toArray();
                for (int i = 0; i < nArray.length; ++i) {
                    this.model.removeRootCACertificate((Certificate)objectArray[nArray[i]]);
                }
            } else if (string4.equals(this.strSecureSiteCa)) {
                Collection collection = this.model.getHttpsRootCACertificates(n2);
                Object[] objectArray = collection.toArray();
                for (int i = 0; i < nArray.length; ++i) {
                    this.model.removeHttpsRootCACertificate((Certificate)objectArray[nArray[i]]);
                }
            } else if (string4.equals(this.strClientAuth)) {
                Collection collection = this.model.getClientAuthCertificates(n2);
                Object[] objectArray = collection.toArray();
                Certificate[][] certificateArray = new Certificate[nArray.length][];
                for (int i = 0; i < nArray.length; ++i) {
                    certificateArray[i] = (Certificate[])objectArray[nArray[i]];
                }
                this.model.removeClientAuthCertificate(this, certificateArray);
            }
            this.reset();
        }
    }

    private void detailsButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.certsComboBox.getSelectedItem();
        int n = -1;
        n = this.isUserLevelSelected() ? this.userTab.getSelectedCertificateTableRow() : this.systemTab.getSelectedCertificateTableRow();
        if (n != -1) {
            Collection collection = null;
            Object var5_5 = null;
            Certificate[] certificateArray = new Certificate[]{null};
            int n2 = 0;
            if (!this.isUserLevelSelected()) {
                n2 = 1;
            }
            if (string.equals(this.strTrustedCerts)) {
                collection = this.model.getTrustedCertificates(n2);
            } else if (string.equals(this.strSecureSite)) {
                collection = this.model.getHttpsCertificates(n2);
            } else if (string.equals(this.strSignerCa)) {
                collection = this.model.getRootCACertificates(n2);
            } else if (string.equals(this.strSecureSiteCa)) {
                collection = this.model.getHttpsRootCACertificates(n2);
            } else if (string.equals(this.strClientAuth)) {
                collection = this.model.getClientAuthCertificates(n2);
            }
            Object[] objectArray = collection.toArray();
            certificateArray = string.equals(this.strClientAuth) ? (Certificate[])objectArray[n] : new Certificate[]{(Certificate)objectArray[n]};
            if (certificateArray[0] != null) {
                CertificateDialog.showCertificates(this, certificateArray, 0, certificateArray.length);
            }
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void exportPKCS12Cert(Certificate[] certificateArray, File file, int n) {
        char[] cArray = null;
        char[] cArray2 = null;
        String string = null;
        try {
            string = n == 0 ? Config.getUserClientAuthCertFile() : Config.getSystemClientAuthCertFile();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream fileInputStream = new FileInputStream(string);
            cArray = this.getPasswordDialog("cert.dialog.exportpassword.text", "password.dialog.title");
            keyStore.load(fileInputStream, cArray);
            if (cArray != null) {
                String string2 = keyStore.getCertificateAlias(certificateArray[0]);
                Key key = keyStore.getKey(string2, cArray);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                KeyStore keyStore2 = KeyStore.getInstance("PKCS12");
                keyStore2.load(null, null);
                cArray2 = this.getPasswordDialog("cert.dialog.savepassword.text", "password.dialog.title");
                if (cArray2 != null) {
                    keyStore2.setKeyEntry(string2, key, cArray2, certificateArray);
                    keyStore2.store(fileOutputStream, cArray2);
                }
            }
        }
        catch (Exception exception) {
            String string3 = CertificatesDialog.getMessage("cert.dialog.export.password.masthead");
            String string4 = CertificatesDialog.getMessage("cert.dialog.export.password.text");
            String string5 = CertificatesDialog.getMessage("cert.dialog.export.error.caption");
            UIFactory.showExceptionDialog(this.getParent(), exception, string3, string4, string5);
        }
    }

    private void exportCertificate(X509Certificate x509Certificate, PrintStream printStream) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        printStream.println("-----BEGIN CERTIFICATE-----");
        try {
            bASE64Encoder.encodeBuffer(x509Certificate.getEncoded(), (OutputStream)printStream);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        printStream.println("-----END CERTIFICATE-----");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void importPKCS12Certificate(InputStream inputStream) {
        char[] cArray = null;
        try {
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                cArray = this.getPasswordDialog("cert.dialog.password.text", "password.dialog.title");
                if (cArray != null) {
                    keyStore.load(inputStream, cArray);
                    Enumeration<String> enumeration = keyStore.aliases();
                    String string = (String)this.certsComboBox.getSelectedItem();
                    while (enumeration.hasMoreElements()) {
                        String string2 = enumeration.nextElement();
                        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
                        if (string.equals(this.strTrustedCerts)) {
                            this.model.addTrustedCertificate(x509Certificate);
                        } else if (string.equals(this.strSecureSite)) {
                            this.model.addHttpsCertificate(x509Certificate);
                        } else if (string.equals(this.strSignerCa)) {
                            this.model.addCACertificate(x509Certificate);
                        } else if (string.equals(this.strSecureSiteCa)) {
                            this.model.addHttpsCACertificate(x509Certificate);
                        }
                        this.reset();
                    }
                }
                Object var9_13 = null;
                if (cArray == null) return;
            }
            catch (Throwable throwable) {
                String string = "uninitializedValue";
                if (!this.compareCharArray(cArray, string.toCharArray())) {
                    String string3 = CertificatesDialog.getMessage("cert.dialog.import.password.masthead");
                    String string4 = CertificatesDialog.getMessage("cert.dialog.import.password.text");
                    String string5 = CertificatesDialog.getMessage("cert.dialog.import.error.caption");
                    UIFactory.showExceptionDialog(this.getParent(), throwable, string3, string4, string5);
                }
                Object var9_14 = null;
                if (cArray == null) return;
                Arrays.fill(cArray, ' ');
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (cArray == null) throw throwable;
            Arrays.fill(cArray, ' ');
            throw throwable;
        }
        Arrays.fill(cArray, ' ');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void importPKCS12CertKey(InputStream inputStream) {
        char[] cArray = null;
        try {
            try {
                cArray = this.getPasswordDialog("cert.dialog.password.text", "password.dialog.title");
                if (cArray != null) {
                    KeyStore keyStore = KeyStore.getInstance("PKCS12");
                    keyStore.load(inputStream, cArray);
                    Enumeration<String> enumeration = keyStore.aliases();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement();
                        Certificate[] certificateArray = keyStore.getCertificateChain(string);
                        Key key = keyStore.getKey(string, cArray);
                        this.model.addClientAuthCertChain(this, certificateArray, key);
                    }
                }
                Object var9_12 = null;
                if (cArray == null) return;
            }
            catch (Throwable throwable) {
                String string = CertificatesDialog.getMessage("cert.dialog.import.password.masthead");
                String string2 = CertificatesDialog.getMessage("cert.dialog.import.password.text");
                String string3 = CertificatesDialog.getMessage("cert.dialog.import.error.caption");
                UIFactory.showExceptionDialog(this.getParent(), throwable, string, string2, string3);
                Object var9_13 = null;
                if (cArray == null) return;
                Arrays.fill(cArray, ' ');
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (cArray == null) throw throwable;
            Arrays.fill(cArray, ' ');
            throw throwable;
        }
        Arrays.fill(cArray, ' ');
    }

    private boolean compareCharArray(char[] cArray, char[] cArray2) {
        if (cArray.length != cArray2.length) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    boolean importCertificate(InputStream inputStream) {
        CertificateFactory certificateFactory = null;
        X509Certificate x509Certificate = null;
        try {
            String string = (String)this.certsComboBox.getSelectedItem();
            certificateFactory = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            if (string.equals(this.strTrustedCerts)) {
                this.model.addTrustedCertificate(x509Certificate);
            } else if (string.equals(this.strSecureSite)) {
                this.model.addHttpsCertificate(x509Certificate);
            } else if (string.equals(this.strSignerCa)) {
                this.model.addCACertificate(x509Certificate);
            } else if (string.equals(this.strSecureSiteCa)) {
                this.model.addHttpsCACertificate(x509Certificate);
            } else if (string.equals(this.strClientAuth)) {
                return false;
            }
            this.reset();
        }
        catch (CertificateParsingException certificateParsingException) {
            return false;
        }
        catch (CertificateException certificateException) {
            String string = CertificatesDialog.getMessage("cert.dialog.import.format.masthead");
            String string2 = CertificatesDialog.getMessage("cert.dialog.import.format.text");
            String string3 = CertificatesDialog.getMessage("cert.dialog.import.error.caption");
            UIFactory.showExceptionDialog(this.getParent(), certificateException, string, string2, string3);
        }
        return true;
    }

    private void reset() {
        ReadOnlyTableModel readOnlyTableModel;
        String string = (String)this.certsComboBox.getSelectedItem();
        Collection collection = null;
        if (this.isUserLevelSelected()) {
            if (string.equals(this.strTrustedCerts)) {
                collection = this.model.getTrustedCertificates(0);
            } else if (string.equals(this.strSecureSite)) {
                collection = this.model.getHttpsCertificates(0);
            } else if (string.equals(this.strSignerCa)) {
                collection = this.model.getRootCACertificates(0);
            } else if (string.equals(this.strSecureSiteCa)) {
                collection = this.model.getHttpsRootCACertificates(0);
            } else if (string.equals(this.strClientAuth)) {
                collection = this.model.getClientAuthCertificates(0);
            }
        } else if (string.equals(this.strTrustedCerts)) {
            collection = this.model.getTrustedCertificates(1);
        } else if (string.equals(this.strSecureSite)) {
            collection = this.model.getHttpsCertificates(1);
        } else if (string.equals(this.strSignerCa)) {
            collection = this.model.getRootCACertificates(1);
        } else if (string.equals(this.strSecureSiteCa)) {
            collection = this.model.getHttpsRootCACertificates(1);
        } else if (string.equals(this.strClientAuth)) {
            collection = this.model.getClientAuthCertificates(1);
        }
        if (collection == null || collection.size() == 0) {
            readOnlyTableModel = new ReadOnlyTableModel();
        } else {
            readOnlyTableModel = new ReadOnlyTableModel(collection.size());
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = null;
                if (string.equals(this.strClientAuth)) {
                    Certificate[] certificateArray = (Certificate[])iterator.next();
                    x509Certificate = (X509Certificate)certificateArray[0];
                } else {
                    x509Certificate = (X509Certificate)iterator.next();
                }
                readOnlyTableModel.setValueAt(CertUtils.extractSubjectAliasName(x509Certificate), n, 0);
                readOnlyTableModel.setValueAt(CertUtils.extractIssuerAliasName(x509Certificate), n, 1);
                ++n;
            }
        }
        if (this.isUserLevelSelected()) {
            this.userTab.setCertificateTableModel(readOnlyTableModel);
        } else {
            this.systemTab.setCertificateTableModel(readOnlyTableModel);
        }
        this.updateButtonState();
    }

    boolean isUserLevelSelected() {
        return this.tabbedPane.getSelectedIndex() == 0;
    }

    private void setEnabled(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        jComponent.repaint();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.reset();
    }

    private void updateButtonState() {
        if (this.isUserLevelSelected()) {
            int[] nArray = this.userTab.getSelectedCertificateTableRows();
            if (nArray.length == 0) {
                this.setEnabled(this.removeButton, false);
                this.setEnabled(this.exportButton, false);
                this.setEnabled(this.importButton, true);
                this.setEnabled(this.detailsButton, false);
            } else if (nArray.length == 1) {
                this.setEnabled(this.removeButton, true);
                this.setEnabled(this.exportButton, true);
                this.setEnabled(this.importButton, true);
                this.setEnabled(this.detailsButton, true);
            } else {
                this.setEnabled(this.removeButton, true);
                this.setEnabled(this.exportButton, false);
                this.setEnabled(this.importButton, false);
                this.setEnabled(this.detailsButton, false);
            }
        } else {
            boolean bl = this.systemTab.isCertificateSelected();
            this.setEnabled(this.removeButton, false);
            this.setEnabled(this.exportButton, bl);
            this.setEnabled(this.importButton, false);
            this.setEnabled(this.detailsButton, bl);
        }
    }

    private char[] getPasswordDialog(String string, String string2) {
        try {
            CredentialInfo credentialInfo = UIFactory.showPasswordDialog(this, CertificatesDialog.getMessage(string2), CertificatesDialog.getMessage(string), false, false, null, false);
            if (credentialInfo != null) {
                return credentialInfo.getPassword();
            }
            return null;
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            return null;
        }
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }
}

