/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ExtensionType;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.HelloExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLProtocolException;

final class ServerNameExtension
extends HelloExtension {
    static final int NAME_HOST_NAME = 0;
    private List<ServerName> names = new ArrayList<ServerName>();

    ServerNameExtension(HandshakeInStream handshakeInStream, int n) throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        while (n > 0) {
            ServerName serverName = new ServerName(handshakeInStream);
            this.names.add(serverName);
            n -= serverName.length + 2;
        }
        if (n != 0) {
            throw new SSLProtocolException("Invalid server_name extension");
        }
    }

    int length() {
        throw new RuntimeException("not yet supported");
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        throw new RuntimeException("not yet supported");
    }

    public String toString() {
        return "Unsupported extension " + this.type + ", " + this.names.toString();
    }

    static class ServerName {
        final int length;
        final int type;
        final byte[] data;
        final String hostname;

        ServerName(HandshakeInStream handshakeInStream) throws IOException {
            this.length = handshakeInStream.getInt16();
            this.type = handshakeInStream.getInt8();
            this.data = handshakeInStream.getBytes16();
            this.hostname = this.type == 0 ? new String(this.data, "UTF8") : null;
        }

        public String toString() {
            if (this.type == 0) {
                return "host_name: " + this.hostname;
            }
            return "unknown-" + this.type + ": " + Debug.toString(this.data);
        }
    }
}

