/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.encoding.DataSourceStreamingDataHandler;
import com.sun.xml.internal.ws.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public final class ByteArrayAttachment
implements Attachment {
    private final String contentId;
    private byte[] data;
    private int start;
    private final int len;
    private final String mimeType;

    public ByteArrayAttachment(@NotNull String string, byte[] byArray, int n, int n2, String string2) {
        this.contentId = string;
        this.data = byArray;
        this.start = n;
        this.len = n2;
        this.mimeType = string2;
    }

    public ByteArrayAttachment(@NotNull String string, byte[] byArray, String string2) {
        this(string, byArray, 0, byArray.length, string2);
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getContentType() {
        return this.mimeType;
    }

    public byte[] asByteArray() {
        if (this.start != 0 || this.len != this.data.length) {
            byte[] byArray = new byte[this.len];
            System.arraycopy(this.data, this.start, byArray, 0, this.len);
            this.start = 0;
            this.data = byArray;
        }
        return this.data;
    }

    public DataHandler asDataHandler() {
        return new DataSourceStreamingDataHandler(new ByteArrayDataSource(this.data, this.start, this.len, this.getContentType()));
    }

    public Source asSource() {
        return new StreamSource(this.asInputStream());
    }

    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.data, this.start, this.len);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.asByteArray());
    }

    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
        attachmentPart.setDataHandler(this.asDataHandler());
        attachmentPart.setContentId(this.contentId);
        sOAPMessage.addAttachmentPart(attachmentPart);
    }
}

