/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.PropertySet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.server.TransportBackChannel;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.util.Pool;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerAsyncTransport<T> {
    private final WSEndpoint endpoint;
    private final CodecPool codecPool;

    public AbstractServerAsyncTransport(WSEndpoint wSEndpoint) {
        this.endpoint = wSEndpoint;
        this.codecPool = new CodecPool(wSEndpoint);
    }

    protected Packet decodePacket(T t, @NotNull Codec codec) throws IOException {
        Packet packet = new Packet();
        packet.acceptableMimeTypes = this.getAcceptableMimeTypes(t);
        packet.addSatellite(this.getPropertySet(t));
        packet.transportBackChannel = this.getTransportBackChannel(t);
        return packet;
    }

    protected abstract void encodePacket(T var1, @NotNull Packet var2, @NotNull Codec var3) throws IOException;

    @Nullable
    protected abstract String getAcceptableMimeTypes(T var1);

    @Nullable
    protected abstract TransportBackChannel getTransportBackChannel(T var1);

    @NotNull
    protected abstract PropertySet getPropertySet(T var1);

    @NotNull
    protected abstract WebServiceContextDelegate getWebServiceContextDelegate(T var1);

    protected void handle(final T t) throws IOException {
        final Codec codec = (Codec)this.codecPool.take();
        Packet packet = this.decodePacket(t, codec);
        if (!packet.getMessage().isFault()) {
            this.endpoint.schedule(packet, new WSEndpoint.CompletionCallback(){

                public void onCompletion(@NotNull Packet packet) {
                    try {
                        AbstractServerAsyncTransport.this.encodePacket(t, packet, codec);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    AbstractServerAsyncTransport.this.codecPool.recycle(codec);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CodecPool
    extends Pool<Codec> {
        WSEndpoint endpoint;

        CodecPool(WSEndpoint wSEndpoint) {
            this.endpoint = wSEndpoint;
        }

        @Override
        protected Codec create() {
            return this.endpoint.createCodec();
        }
    }
}

