/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.net.URL;

public class JREDesc
implements ResourceType {
    private String _version;
    private long _maxHeap;
    private long _minHeap;
    private String _vmargs;
    private URL _href;
    private boolean _isSelected;
    private ResourcesDesc _resourceDesc;
    private LaunchDesc _extensioDesc;

    public JREDesc(String string, long l, long l2, String string2, URL uRL, ResourcesDesc resourcesDesc) {
        this._version = string;
        this._maxHeap = l2;
        this._minHeap = l;
        this._vmargs = string2;
        this._href = uRL;
        this._isSelected = false;
        this._resourceDesc = resourcesDesc;
        this._extensioDesc = null;
    }

    public String toString() {
        return "JREDesc[version " + this._version + ", heap=" + this._minHeap + "-" + this._maxHeap + ", args=" + this._vmargs + ", href=" + this._href + ", sel=" + this._isSelected + ", " + this._resourceDesc + ", " + this._extensioDesc + "]";
    }

    public String getVersion() {
        return this._version;
    }

    public URL getHref() {
        return this._href;
    }

    public long getMinHeap() {
        return this._minHeap;
    }

    public long getMaxHeap() {
        return this._maxHeap;
    }

    public String getVmArgs() {
        return this._vmargs;
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void markAsSelected() {
        this._isSelected = true;
    }

    public ResourcesDesc getNestedResources() {
        return this._resourceDesc;
    }

    public LaunchDesc getExtensionDesc() {
        return this._extensioDesc;
    }

    public void setExtensionDesc(LaunchDesc launchDesc) {
        this._extensioDesc = launchDesc;
    }

    public void visit(ResourceVisitor resourceVisitor) {
        resourceVisitor.visitJREDesc(this);
    }

    public String getSource() {
        if (this._href != null) {
            return this._href.getHost();
        }
        try {
            URL uRL = new URL(Config.getProperty((String)"deployment.javaws.installURL"));
            return uRL.getHost();
        }
        catch (Throwable throwable) {
            Trace.ignored((Throwable)throwable);
            return "";
        }
    }

    public XMLNode asXML() {
        XMLNode xMLNode;
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        if (this._minHeap > 0L) {
            xMLAttributeBuilder.add("initial-heap-size", this._minHeap);
        }
        if (this._maxHeap > 0L) {
            xMLAttributeBuilder.add("max-heap-size", this._maxHeap);
        }
        if (this._vmargs != null) {
            xMLAttributeBuilder.add("java-vm-args", this._vmargs);
        }
        xMLAttributeBuilder.add("href", this._href);
        if (this._version != null) {
            xMLAttributeBuilder.add("version", this._version);
        }
        XMLNode xMLNode2 = xMLNode = this._extensioDesc != null ? this._extensioDesc.asXML() : null;
        if (this._resourceDesc != null) {
            xMLNode = this._resourceDesc.asXML();
        }
        return new XMLNode("java", xMLAttributeBuilder.getAttributeList(), xMLNode, null);
    }
}

