/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.api.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NameUtil {
    protected static final int UPPER_LETTER = 0;
    protected static final int LOWER_LETTER = 1;
    protected static final int OTHER_LETTER = 2;
    protected static final int DIGIT = 3;
    protected static final int OTHER = 4;
    private static final byte[] actionTable;
    private static final byte ACTION_CHECK_PUNCT = 0;
    private static final byte ACTION_CHECK_C2 = 1;
    private static final byte ACTION_BREAK = 2;
    private static final byte ACTION_NOBREAK = 3;
    private static HashSet<String> reservedKeywords;

    NameUtil() {
    }

    protected boolean isPunct(char c) {
        return c == '-' || c == '.' || c == ':' || c == '_' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de';
    }

    protected static boolean isDigit(char c) {
        return c >= '0' && c <= '9' || Character.isDigit(c);
    }

    protected static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z' || Character.isUpperCase(c);
    }

    protected static boolean isLower(char c) {
        return c >= 'a' && c <= 'z' || Character.isLowerCase(c);
    }

    protected boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c);
    }

    private String toLowerCase(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    private String toUpperCase(char c) {
        return String.valueOf(c).toUpperCase(Locale.ENGLISH);
    }

    private String toUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public String capitalize(String string) {
        if (!NameUtil.isLower(string.charAt(0))) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(this.toUpperCase(string.charAt(0)));
        stringBuilder.append(this.toLowerCase(string.substring(1)));
        return stringBuilder.toString();
    }

    private int nextBreak(String string, int n) {
        int n2 = string.length();
        char c = string.charAt(n);
        int n3 = this.classify(c);
        block5: for (int i = n + 1; i < n2; ++i) {
            int n4 = n3;
            c = string.charAt(i);
            n3 = this.classify(c);
            switch (actionTable[n4 * 5 + n3]) {
                case 0: {
                    if (!this.isPunct(c)) continue block5;
                    return i;
                }
                case 1: {
                    char c2;
                    if (i >= n2 - 1 || !NameUtil.isLower(c2 = string.charAt(i + 1))) continue block5;
                    return i;
                }
                case 2: {
                    return i;
                }
            }
        }
        return -1;
    }

    private static byte decideAction(int n, int n2) {
        if (n == 4 && n2 == 4) {
            return 0;
        }
        if (!NameUtil.xor(n == 3, n2 == 3)) {
            return 2;
        }
        if (n == 1 && n2 != 1) {
            return 2;
        }
        if (!NameUtil.xor(n <= 2, n2 <= 2)) {
            return 2;
        }
        if (!NameUtil.xor(n == 2, n2 == 2)) {
            return 2;
        }
        if (n == 0 && n2 == 0) {
            return 1;
        }
        return 3;
    }

    private static boolean xor(boolean bl, boolean bl2) {
        return bl && bl2 || !bl && !bl2;
    }

    protected int classify(char c) {
        switch (Character.getType(c)) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 9: {
                return 3;
            }
        }
        return 4;
    }

    public List<String> toWordList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            while (n2 < n && this.isPunct(string.charAt(n2))) {
                ++n2;
            }
            if (n2 >= n) break;
            int n3 = this.nextBreak(string, n2);
            String string2 = n3 == -1 ? string.substring(n2) : string.substring(n2, n3);
            arrayList.add(NameUtil.escape(this.capitalize(string2)));
            if (n3 == -1) break;
            n2 = n3;
        }
        return arrayList;
    }

    protected String toMixedCaseName(List<String> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!list.isEmpty()) {
            stringBuilder.append(bl ? list.get(0) : this.toLowerCase(list.get(0)));
            for (int i = 1; i < list.size(); ++i) {
                stringBuilder.append(list.get(i));
            }
        }
        return stringBuilder.toString();
    }

    protected String toMixedCaseVariableName(String[] stringArray, boolean bl, boolean bl2) {
        if (bl2) {
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray[i] = this.capitalize(stringArray[i]);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder.append(bl ? stringArray[0] : this.toLowerCase(stringArray[0]));
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    public String toConstantName(String string) {
        return this.toConstantName(this.toWordList(string));
    }

    public String toConstantName(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!list.isEmpty()) {
            stringBuilder.append(this.toUpperCase(list.get(0)));
            for (int i = 1; i < list.size(); ++i) {
                stringBuilder.append('_');
                stringBuilder.append(this.toUpperCase(list.get(i)));
            }
        }
        return stringBuilder.toString();
    }

    public static void escape(StringBuilder stringBuilder, String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
            if (c <= '\u000f') {
                stringBuilder.append("000");
            } else if (c <= '\u00ff') {
                stringBuilder.append("00");
            } else if (c <= '\u0fff') {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toString(c, 16));
        }
    }

    private static String escape(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            StringBuilder stringBuilder = new StringBuilder(string.substring(0, i));
            NameUtil.escape(stringBuilder, string, i);
            return stringBuilder.toString();
        }
        return string;
    }

    public static boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (reservedKeywords.contains(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaPackageName(String string) {
        while (string.length() != 0) {
            int n = string.indexOf(46);
            if (n == -1) {
                n = string.length();
            }
            if (!NameUtil.isJavaIdentifier(string.substring(0, n))) {
                return false;
            }
            if ((string = string.substring(n)).length() == 0) continue;
            string = string.substring(1);
        }
        return true;
    }

    static {
        String[] stringArray;
        actionTable = new byte[25];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                NameUtil.actionTable[i * 5 + j] = NameUtil.decideAction(i, j);
            }
        }
        reservedKeywords = new HashSet();
        for (String string : stringArray = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert", "enum"}) {
            reservedKeywords.add(string);
        }
    }
}

