/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.orb;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBClassLoader;
import com.sun.corba.se.spi.orb.Operation;
import com.sun.corba.se.spi.orb.StringPair;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.StringTokenizer;

public abstract class OperationFactory {
    private static Operation suffixActionImpl = new SuffixAction();
    private static Operation valueActionImpl = new ValueAction();
    private static Operation identityActionImpl = new IdentityAction();
    private static Operation booleanActionImpl = new BooleanAction();
    private static Operation integerActionImpl = new IntegerAction();
    private static Operation stringActionImpl = new StringAction();
    private static Operation classActionImpl = new ClassAction();
    private static Operation setFlagActionImpl = new SetFlagAction();
    private static Operation URLActionImpl = new URLAction();
    private static Operation convertIntegerToShortImpl = new ConvertIntegerToShort();

    private OperationFactory() {
    }

    private static String getString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        throw new Error("String expected");
    }

    private static Object[] getObjectArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        throw new Error("Object[] expected");
    }

    private static StringPair getStringPair(Object object) {
        if (object instanceof StringPair) {
            return (StringPair)object;
        }
        throw new Error("StringPair expected");
    }

    public static Operation maskErrorAction(Operation operation) {
        return new MaskErrorAction(operation);
    }

    public static Operation indexAction(int n) {
        return new IndexAction(n);
    }

    public static Operation identityAction() {
        return identityActionImpl;
    }

    public static Operation suffixAction() {
        return suffixActionImpl;
    }

    public static Operation valueAction() {
        return valueActionImpl;
    }

    public static Operation booleanAction() {
        return booleanActionImpl;
    }

    public static Operation integerAction() {
        return integerActionImpl;
    }

    public static Operation stringAction() {
        return stringActionImpl;
    }

    public static Operation classAction() {
        return classActionImpl;
    }

    public static Operation setFlagAction() {
        return setFlagActionImpl;
    }

    public static Operation URLAction() {
        return URLActionImpl;
    }

    public static Operation integerRangeAction(int n, int n2) {
        return new IntegerRangeAction(n, n2);
    }

    public static Operation listAction(String string, Operation operation) {
        return new ListAction(string, operation);
    }

    public static Operation sequenceAction(String string, Operation[] operationArray) {
        return new SequenceAction(string, operationArray);
    }

    public static Operation compose(Operation operation, Operation operation2) {
        return new ComposeAction(operation, operation2);
    }

    public static Operation mapAction(Operation operation) {
        return new MapAction(operation);
    }

    public static Operation mapSequenceAction(Operation[] operationArray) {
        return new MapSequenceAction(operationArray);
    }

    public static Operation convertIntegerToShort() {
        return convertIntegerToShortImpl;
    }

    private static class BooleanAction
    extends OperationBase {
        private BooleanAction() {
        }

        public Object operate(Object object) {
            return new Boolean(OperationFactory.getString(object));
        }

        public String toString() {
            return "booleanAction";
        }
    }

    private static class ClassAction
    extends OperationBase {
        private ClassAction() {
        }

        public Object operate(Object object) {
            String string = OperationFactory.getString(object);
            try {
                Class clazz = ORBClassLoader.loadClass(string);
                return clazz;
            }
            catch (Exception exception) {
                ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get("orb.lifecycle");
                throw oRBUtilSystemException.couldNotLoadClass(exception, (Object)string);
            }
        }

        public String toString() {
            return "classAction";
        }
    }

    private static class ComposeAction
    extends OperationBase {
        private Operation op1;
        private Operation op2;

        ComposeAction(Operation operation, Operation operation2) {
            this.op1 = operation;
            this.op2 = operation2;
        }

        public Object operate(Object object) {
            return this.op2.operate(this.op1.operate(object));
        }

        public String toString() {
            return "composition(" + this.op1 + "," + this.op2 + ")";
        }
    }

    private static class ConvertIntegerToShort
    extends OperationBase {
        private ConvertIntegerToShort() {
        }

        public Object operate(Object object) {
            Integer n = (Integer)object;
            return new Short(n.shortValue());
        }

        public String toString() {
            return "ConvertIntegerToShort";
        }
    }

    private static class IdentityAction
    extends OperationBase {
        private IdentityAction() {
        }

        public Object operate(Object object) {
            return object;
        }

        public String toString() {
            return "identityAction";
        }
    }

    private static class IndexAction
    extends OperationBase {
        private int index;

        public IndexAction(int n) {
            this.index = n;
        }

        public Object operate(Object object) {
            return OperationFactory.getObjectArray(object)[this.index];
        }

        public String toString() {
            return "indexAction(" + this.index + ")";
        }
    }

    private static class IntegerAction
    extends OperationBase {
        private IntegerAction() {
        }

        public Object operate(Object object) {
            return new Integer(OperationFactory.getString(object));
        }

        public String toString() {
            return "integerAction";
        }
    }

    private static class IntegerRangeAction
    extends OperationBase {
        private int min;
        private int max;

        IntegerRangeAction(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        public Object operate(Object object) {
            int n = Integer.parseInt(OperationFactory.getString(object));
            if (n >= this.min && n <= this.max) {
                return new Integer(n);
            }
            throw new IllegalArgumentException("Property value " + n + " is not in the range " + this.min + " to " + this.max);
        }

        public String toString() {
            return "integerRangeAction(" + this.min + "," + this.max + ")";
        }
    }

    private static class ListAction
    extends OperationBase {
        private String sep;
        private Operation act;

        ListAction(String string, Operation operation) {
            this.sep = string;
            this.act = operation;
        }

        public Object operate(Object object) {
            StringTokenizer stringTokenizer = new StringTokenizer(OperationFactory.getString(object), this.sep);
            int n = stringTokenizer.countTokens();
            Object object2 = null;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                Object object3 = this.act.operate(string);
                if (object2 == null) {
                    object2 = Array.newInstance(object3.getClass(), n);
                }
                Array.set(object2, n2++, object3);
            }
            return object2;
        }

        public String toString() {
            return "listAction(separator=\"" + this.sep + "\",action=" + this.act + ")";
        }
    }

    private static class MapAction
    extends OperationBase {
        Operation op;

        MapAction(Operation operation) {
            this.op = operation;
        }

        public Object operate(Object object) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.op.operate(objectArray[i]);
            }
            return objectArray2;
        }

        public String toString() {
            return "mapAction(" + this.op + ")";
        }
    }

    private static class MapSequenceAction
    extends OperationBase {
        private Operation[] op;

        public MapSequenceAction(Operation[] operationArray) {
            this.op = operationArray;
        }

        public Object operate(Object object) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.op[i].operate(objectArray[i]);
            }
            return objectArray2;
        }

        public String toString() {
            return "mapSequenceAction(" + Arrays.toString(this.op) + ")";
        }
    }

    private static class MaskErrorAction
    extends OperationBase {
        private Operation op;

        public MaskErrorAction(Operation operation) {
            this.op = operation;
        }

        public Object operate(Object object) {
            try {
                return this.op.operate(object);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String toString() {
            return "maskErrorAction(" + this.op + ")";
        }
    }

    private static abstract class OperationBase
    implements Operation {
        private OperationBase() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof OperationBase)) {
                return false;
            }
            OperationBase operationBase = (OperationBase)object;
            return this.toString().equals(operationBase.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private static class SequenceAction
    extends OperationBase {
        private String sep;
        private Operation[] actions;

        SequenceAction(String string, Operation[] operationArray) {
            this.sep = string;
            this.actions = operationArray;
        }

        public Object operate(Object object) {
            StringTokenizer stringTokenizer = new StringTokenizer(OperationFactory.getString(object), this.sep);
            int n = stringTokenizer.countTokens();
            if (n != this.actions.length) {
                throw new Error("Number of tokens and number of actions do not match");
            }
            int n2 = 0;
            Object[] objectArray = new Object[n];
            while (stringTokenizer.hasMoreTokens()) {
                Operation operation = this.actions[n2];
                String string = stringTokenizer.nextToken();
                objectArray[n2++] = operation.operate(string);
            }
            return objectArray;
        }

        public String toString() {
            return "sequenceAction(separator=\"" + this.sep + "\",actions=" + Arrays.toString(this.actions) + ")";
        }
    }

    private static class SetFlagAction
    extends OperationBase {
        private SetFlagAction() {
        }

        public Object operate(Object object) {
            return Boolean.TRUE;
        }

        public String toString() {
            return "setFlagAction";
        }
    }

    private static class StringAction
    extends OperationBase {
        private StringAction() {
        }

        public Object operate(Object object) {
            return object;
        }

        public String toString() {
            return "stringAction";
        }
    }

    private static class SuffixAction
    extends OperationBase {
        private SuffixAction() {
        }

        public Object operate(Object object) {
            return OperationFactory.getStringPair(object).getFirst();
        }

        public String toString() {
            return "suffixAction";
        }
    }

    private static class URLAction
    extends OperationBase {
        private URLAction() {
        }

        public Object operate(Object object) {
            String string = (String)object;
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get("orb.lifecycle");
                throw oRBUtilSystemException.badUrl(malformedURLException, (Object)string);
            }
        }

        public String toString() {
            return "URLAction";
        }
    }

    private static class ValueAction
    extends OperationBase {
        private ValueAction() {
        }

        public Object operate(Object object) {
            return OperationFactory.getStringPair(object).getSecond();
        }

        public String toString() {
            return "valueAction";
        }
    }
}

