/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import com.sun.java.util.jar.pack.PackerImpl;
import com.sun.java.util.jar.pack.UnpackerImpl;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.SortedMap;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import sun.security.action.GetPropertyAction;

public abstract class Pack200 {
    private static final String PACK_PROVIDER = "java.util.jar.Pack200.Packer";
    private static final String UNPACK_PROVIDER = "java.util.jar.Pack200.Unpacker";
    private static Class packerImpl;
    private static Class unpackerImpl;

    private Pack200() {
    }

    public static synchronized Packer newPacker() {
        return (Packer)Pack200.newInstance(PACK_PROVIDER);
    }

    public static Unpacker newUnpacker() {
        return (Unpacker)Pack200.newInstance(UNPACK_PROVIDER);
    }

    private static synchronized Object newInstance(String string) {
        String string2 = "(unknown)";
        try {
            Class clazz;
            Class clazz2 = clazz = string == PACK_PROVIDER ? packerImpl : unpackerImpl;
            if (clazz == null) {
                string2 = AccessController.doPrivileged(new GetPropertyAction(string, ""));
                clazz = string2 != null && !string2.equals("") ? Class.forName(string2) : (string == PACK_PROVIDER ? PackerImpl.class : UnpackerImpl.class);
            }
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("Class not found: " + string2 + ":\ncheck property " + string + " in your properties file.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new Error("Could not instantiate: " + string2 + ":\ncheck property " + string + " in your properties file.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Cannot access class: " + string2 + ":\ncheck property " + string + " in your properties file.", illegalAccessException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Packer {
        public static final String SEGMENT_LIMIT = "pack.segment.limit";
        public static final String KEEP_FILE_ORDER = "pack.keep.file.order";
        public static final String EFFORT = "pack.effort";
        public static final String DEFLATE_HINT = "pack.deflate.hint";
        public static final String MODIFICATION_TIME = "pack.modification.time";
        public static final String PASS_FILE_PFX = "pack.pass.file.";
        public static final String UNKNOWN_ATTRIBUTE = "pack.unknown.attribute";
        public static final String CLASS_ATTRIBUTE_PFX = "pack.class.attribute.";
        public static final String FIELD_ATTRIBUTE_PFX = "pack.field.attribute.";
        public static final String METHOD_ATTRIBUTE_PFX = "pack.method.attribute.";
        public static final String CODE_ATTRIBUTE_PFX = "pack.code.attribute.";
        public static final String PROGRESS = "pack.progress";
        public static final String KEEP = "keep";
        public static final String PASS = "pass";
        public static final String STRIP = "strip";
        public static final String ERROR = "error";
        public static final String TRUE = "true";
        public static final String FALSE = "false";
        public static final String LATEST = "latest";

        public SortedMap<String, String> properties();

        public void pack(JarFile var1, OutputStream var2) throws IOException;

        public void pack(JarInputStream var1, OutputStream var2) throws IOException;

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Unpacker {
        public static final String KEEP = "keep";
        public static final String TRUE = "true";
        public static final String FALSE = "false";
        public static final String DEFLATE_HINT = "unpack.deflate.hint";
        public static final String PROGRESS = "unpack.progress";

        public SortedMap<String, String> properties();

        public void unpack(InputStream var1, JarOutputStream var2) throws IOException;

        public void unpack(File var1, JarOutputStream var2) throws IOException;

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

