/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.Interpreter;
import sun.org.mozilla.javascript.internal.InterpreterData;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.NativeFunction;
import sun.org.mozilla.javascript.internal.RegExpProxy;
import sun.org.mozilla.javascript.internal.Script;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.SecurityController;
import sun.org.mozilla.javascript.internal.debug.DebuggableScript;

final class InterpretedFunction
extends NativeFunction
implements Script {
    static final long serialVersionUID = 541475680333911468L;
    InterpreterData idata;
    SecurityController securityController;
    Object securityDomain;
    Scriptable[] functionRegExps;

    private InterpretedFunction(InterpreterData interpreterData, Object object) {
        Object object2;
        this.idata = interpreterData;
        Context context = Context.getContext();
        SecurityController securityController = context.getSecurityController();
        if (securityController != null) {
            object2 = securityController.getDynamicSecurityDomain(object);
        } else {
            if (object != null) {
                throw new IllegalArgumentException();
            }
            object2 = null;
        }
        this.securityController = securityController;
        this.securityDomain = object2;
    }

    private InterpretedFunction(InterpretedFunction interpretedFunction, int n) {
        this.idata = interpretedFunction.idata.itsNestedFunctions[n];
        this.securityController = interpretedFunction.securityController;
        this.securityDomain = interpretedFunction.securityDomain;
    }

    static InterpretedFunction createScript(InterpreterData interpreterData, Object object) {
        InterpretedFunction interpretedFunction = new InterpretedFunction(interpreterData, object);
        return interpretedFunction;
    }

    static InterpretedFunction createFunction(Context context, Scriptable scriptable, InterpreterData interpreterData, Object object) {
        InterpretedFunction interpretedFunction = new InterpretedFunction(interpreterData, object);
        interpretedFunction.initInterpretedFunction(context, scriptable);
        return interpretedFunction;
    }

    static InterpretedFunction createFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = new InterpretedFunction(interpretedFunction, n);
        interpretedFunction2.initInterpretedFunction(context, scriptable);
        return interpretedFunction2;
    }

    Scriptable[] createRegExpWraps(Context context, Scriptable scriptable) {
        if (this.idata.itsRegExpLiterals == null) {
            Kit.codeBug();
        }
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        int n = this.idata.itsRegExpLiterals.length;
        Scriptable[] scriptableArray = new Scriptable[n];
        for (int i = 0; i != n; ++i) {
            scriptableArray[i] = regExpProxy.wrapRegExp(context, scriptable, this.idata.itsRegExpLiterals[i]);
        }
        return scriptableArray;
    }

    private void initInterpretedFunction(Context context, Scriptable scriptable) {
        this.initScriptFunction(context, scriptable);
        if (this.idata.itsRegExpLiterals != null) {
            this.functionRegExps = this.createRegExpWraps(context, scriptable);
        }
    }

    public String getFunctionName() {
        return this.idata.itsName == null ? "" : this.idata.itsName;
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(this, context, scriptable, scriptable2, objectArray);
        }
        return Interpreter.interpret(this, context, scriptable, scriptable2, objectArray);
    }

    public Object exec(Context context, Scriptable scriptable) {
        if (this.idata.itsFunctionType != 0) {
            throw new IllegalStateException();
        }
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(this, context, scriptable, scriptable, ScriptRuntime.emptyArgs);
        }
        return Interpreter.interpret(this, context, scriptable, scriptable, ScriptRuntime.emptyArgs);
    }

    public String getEncodedSource() {
        return Interpreter.getEncodedSource(this.idata);
    }

    public DebuggableScript getDebuggableView() {
        return this.idata;
    }

    protected int getLanguageVersion() {
        return this.idata.languageVersion;
    }

    protected int getParamCount() {
        return this.idata.argCount;
    }

    protected int getParamAndVarCount() {
        return this.idata.argNames.length;
    }

    protected String getParamOrVarName(int n) {
        return this.idata.argNames[n];
    }
}

