/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.util.MetadataUtil;
import com.sun.xml.internal.ws.util.pipe.AbstractSchemaValidationTube;
import com.sun.xml.internal.ws.util.xml.MetadataDocument;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ClientSchemaValidationTube
extends AbstractSchemaValidationTube {
    private static final Logger LOGGER = Logger.getLogger(ClientSchemaValidationTube.class.getName());
    private final Schema schema;
    private final Validator validator;
    private final boolean noValidation;
    private final WSDLPort port;

    public ClientSchemaValidationTube(WSBinding wSBinding, WSDLPort wSDLPort, Tube tube) {
        super(wSBinding, tube);
        Object object;
        this.port = wSDLPort;
        Source[] sourceArray = null;
        if (wSDLPort != null) {
            object = wSDLPort.getOwner().getParent().getLocation().getSystemId();
            for (Source source : sourceArray = this.getSchemaSources((String)object)) {
                LOGGER.fine("Constructing validation Schema from = " + source.getSystemId());
            }
        }
        if (sourceArray != null) {
            this.noValidation = false;
            object = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                this.schema = ((SchemaFactory)object).newSchema(sourceArray);
            }
            catch (SAXException sAXException) {
                throw new WebServiceException(sAXException);
            }
            this.validator = this.schema.newValidator();
        } else {
            this.noValidation = true;
            this.schema = null;
            this.validator = null;
        }
    }

    private Source[] getSchemaSources(String string) {
        MetadataResolverImpl metadataResolverImpl = new MetadataResolverImpl();
        Map<String, SDDocument> map = MetadataUtil.getMetadataClosure(string, metadataResolverImpl, true);
        ArrayList<Source> arrayList = new ArrayList<Source>();
        for (Map.Entry<String, SDDocument> entry : map.entrySet()) {
            Document document;
            SDDocument sDDocument = entry.getValue();
            if (sDDocument.isWSDL()) {
                document = this.createDOM(sDDocument);
                this.addSchemaFragmentSource(document, sDDocument.getURL().toExternalForm(), arrayList);
                continue;
            }
            if (!sDDocument.isSchema()) continue;
            document = this.createDOM(sDDocument);
            arrayList.add(new DOMSource(document, sDDocument.getURL().toExternalForm()));
        }
        return arrayList.toArray(new Source[arrayList.size()]);
    }

    protected Validator getValidator() {
        return this.validator;
    }

    protected boolean isNoValidation() {
        return this.noValidation;
    }

    protected ClientSchemaValidationTube(ClientSchemaValidationTube clientSchemaValidationTube, TubeCloner tubeCloner) {
        super(clientSchemaValidationTube, tubeCloner);
        this.port = clientSchemaValidationTube.port;
        this.schema = clientSchemaValidationTube.schema;
        this.validator = this.schema.newValidator();
        this.noValidation = clientSchemaValidationTube.noValidation;
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new ClientSchemaValidationTube(this, tubeCloner);
    }

    private class MetadataResolverImpl
    implements MetadataUtil.MetadataResolver {
        Map<String, SDDocument> docs = new HashMap<String, SDDocument>();

        private MetadataResolverImpl() {
        }

        public SDDocument resolveEntity(String string) {
            SDDocument sDDocument = this.docs.get(string);
            if (sDDocument == null) {
                SDDocumentSource sDDocumentSource;
                try {
                    sDDocumentSource = SDDocumentSource.create(new URL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new WebServiceException(malformedURLException);
                }
                sDDocument = MetadataDocument.create(sDDocumentSource, new QName(""), new QName(""));
                this.docs.put(string, sDDocument);
            }
            return sDDocument;
        }
    }
}

