/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEMessage;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEPart;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.internal.ws.encoding.ContentType;
import com.sun.xml.internal.ws.encoding.DataSourceStreamingDataHandler;
import com.sun.xml.internal.ws.encoding.MIMEPartStreamingDataHandler;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeMultipartParser {
    private final String start;
    private final MIMEMessage message;
    private Attachment root;
    private final Map<String, Attachment> attachments = new HashMap<String, Attachment>();
    private boolean gotAll;

    public MimeMultipartParser(InputStream inputStream, String string, StreamingAttachmentFeature streamingAttachmentFeature) {
        ContentType contentType = new ContentType(string);
        String string2 = contentType.getParameter("boundary");
        if (string2 == null || string2.equals("")) {
            throw new WebServiceException("MIME boundary parameter not found" + string);
        }
        this.message = streamingAttachmentFeature != null ? new MIMEMessage(inputStream, string2, streamingAttachmentFeature.getConfig()) : new MIMEMessage(inputStream, string2);
        String string3 = contentType.getParameter("start");
        if (string3 != null && string3.length() > 2 && string3.charAt(0) == '<' && string3.charAt(string3.length() - 1) == '>') {
            string3 = string3.substring(1, string3.length() - 1);
        }
        this.start = string3;
    }

    @Nullable
    public Attachment getRootPart() {
        if (this.root == null) {
            this.root = new PartAttachment(this.start != null ? this.message.getPart(this.start) : this.message.getPart(0));
        }
        return this.root;
    }

    @NotNull
    public Map<String, Attachment> getAttachmentParts() {
        if (!this.gotAll) {
            MIMEPart mIMEPart = this.start != null ? this.message.getPart(this.start) : this.message.getPart(0);
            List<MIMEPart> list = this.message.getAttachments();
            for (MIMEPart mIMEPart2 : list) {
                if (mIMEPart2 == mIMEPart) continue;
                PartAttachment partAttachment = new PartAttachment(mIMEPart2);
                this.attachments.put(partAttachment.getContentId(), partAttachment);
            }
            this.gotAll = true;
        }
        return this.attachments;
    }

    @Nullable
    public Attachment getAttachmentPart(String string) throws IOException {
        Attachment attachment = this.attachments.get(string);
        if (attachment == null) {
            MIMEPart mIMEPart = this.message.getPart(string);
            attachment = new PartAttachment(mIMEPart);
            this.attachments.put(string, attachment);
        }
        return attachment;
    }

    static class PartAttachment
    implements Attachment {
        final MIMEPart part;
        byte[] buf;

        PartAttachment(MIMEPart mIMEPart) {
            this.part = mIMEPart;
        }

        @NotNull
        public String getContentId() {
            return this.part.getContentId();
        }

        @NotNull
        public String getContentType() {
            return this.part.getContentType();
        }

        public byte[] asByteArray() {
            if (this.buf == null) {
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                try {
                    byteArrayBuffer.write(this.part.readOnce());
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
                this.buf = byteArrayBuffer.toByteArray();
            }
            return this.buf;
        }

        public DataHandler asDataHandler() {
            return this.buf != null ? new DataSourceStreamingDataHandler(new ByteArrayDataSource(this.buf, this.getContentType())) : new MIMEPartStreamingDataHandler(this.part);
        }

        public Source asSource() {
            return this.buf != null ? new StreamSource(new ByteArrayInputStream(this.buf)) : new StreamSource(this.part.read());
        }

        public InputStream asInputStream() {
            return this.buf != null ? new ByteArrayInputStream(this.buf) : this.part.read();
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            if (this.buf != null) {
                outputStream.write(this.buf);
            } else {
                int n;
                InputStream inputStream = this.part.read();
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                inputStream.close();
            }
        }

        public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
            sOAPMessage.createAttachmentPart().setDataHandler(this.asDataHandler());
        }
    }
}

