/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpIndex;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpTableCallbackHandler;
import com.sun.jmx.snmp.agent.SnmpTableEntryFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class SnmpTableSupport
implements SnmpTableEntryFactory,
SnmpTableCallbackHandler,
Serializable {
    protected List entries;
    protected SnmpMibTable meta;
    protected SnmpMib theMib;
    private boolean registrationRequired = false;

    protected SnmpTableSupport(SnmpMib snmpMib) {
        this.theMib = snmpMib;
        this.meta = this.getRegisteredTableMeta(snmpMib);
        this.bindWithTableMeta();
        this.entries = this.allocateTable();
    }

    public abstract void createNewEntry(SnmpMibSubRequest var1, SnmpOid var2, int var3, SnmpMibTable var4) throws SnmpStatusException;

    public Object getEntry(int n) {
        if (this.entries == null) {
            return null;
        }
        return this.entries.get(n);
    }

    public int getSize() {
        return this.meta.getSize();
    }

    public void setCreationEnabled(boolean bl) {
        this.meta.setCreationEnabled(bl);
    }

    public boolean isCreationEnabled() {
        return this.meta.isCreationEnabled();
    }

    public boolean isRegistrationRequired() {
        return this.registrationRequired;
    }

    public SnmpIndex buildSnmpIndex(SnmpOid snmpOid) throws SnmpStatusException {
        return this.buildSnmpIndex(snmpOid.longValue(false), 0);
    }

    public abstract SnmpOid buildOidFromIndex(SnmpIndex var1) throws SnmpStatusException;

    public abstract ObjectName buildNameFromIndex(SnmpIndex var1) throws SnmpStatusException;

    public void addEntryCb(int n, SnmpOid snmpOid, ObjectName objectName, Object object, SnmpMibTable snmpMibTable) throws SnmpStatusException {
        try {
            if (this.entries != null) {
                this.entries.add(n, object);
            }
        }
        catch (Exception exception) {
            throw new SnmpStatusException(2);
        }
    }

    public void removeEntryCb(int n, SnmpOid snmpOid, ObjectName objectName, Object object, SnmpMibTable snmpMibTable) throws SnmpStatusException {
        try {
            if (this.entries != null) {
                this.entries.remove(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.meta.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.meta.removeNotificationListener(notificationListener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.meta.getNotificationInfo();
    }

    protected abstract SnmpIndex buildSnmpIndex(long[] var1, int var2) throws SnmpStatusException;

    protected abstract SnmpMibTable getRegisteredTableMeta(SnmpMib var1);

    protected List allocateTable() {
        return new ArrayList();
    }

    protected void addEntry(SnmpIndex snmpIndex, Object object) throws SnmpStatusException {
        SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
        ObjectName objectName = null;
        if (this.isRegistrationRequired()) {
            objectName = this.buildNameFromIndex(snmpIndex);
        }
        this.meta.addEntry(snmpOid, objectName, object);
    }

    protected void addEntry(SnmpIndex snmpIndex, ObjectName objectName, Object object) throws SnmpStatusException {
        SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
        this.meta.addEntry(snmpOid, objectName, object);
    }

    protected void removeEntry(SnmpIndex snmpIndex, Object object) throws SnmpStatusException {
        SnmpOid snmpOid = this.buildOidFromIndex(snmpIndex);
        this.meta.removeEntry(snmpOid, object);
    }

    protected Object[] getBasicEntries() {
        if (this.entries == null) {
            return null;
        }
        Object[] objectArray = new Object[this.entries.size()];
        this.entries.toArray(objectArray);
        return objectArray;
    }

    protected void bindWithTableMeta() {
        if (this.meta == null) {
            return;
        }
        this.registrationRequired = this.meta.isRegistrationRequired();
        this.meta.registerEntryFactory(this);
    }
}

