/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;

class LineIterator
implements PathIterator {
    Line2D line;
    AffineTransform affine;
    int index;

    LineIterator(Line2D line2D, AffineTransform affineTransform) {
        this.line = line2D;
        this.affine = affineTransform;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.index > 1;
    }

    public void next() {
        ++this.index;
    }

    public int currentSegment(float[] fArray) {
        int n;
        if (this.isDone()) {
            throw new NoSuchElementException("line iterator out of bounds");
        }
        if (this.index == 0) {
            fArray[0] = (float)this.line.getX1();
            fArray[1] = (float)this.line.getY1();
            n = 0;
        } else {
            fArray[0] = (float)this.line.getX2();
            fArray[1] = (float)this.line.getY2();
            n = 1;
        }
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, 1);
        }
        return n;
    }

    public int currentSegment(double[] dArray) {
        int n;
        if (this.isDone()) {
            throw new NoSuchElementException("line iterator out of bounds");
        }
        if (this.index == 0) {
            dArray[0] = this.line.getX1();
            dArray[1] = this.line.getY1();
            n = 0;
        } else {
            dArray[0] = this.line.getX2();
            dArray[1] = this.line.getY2();
            n = 1;
        }
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, 1);
        }
        return n;
    }
}

