/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.source;

import com.sun.xml.internal.ws.message.RootElementSniffer;
import com.sun.xml.internal.ws.streaming.SourceReaderFactory;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class SourceUtils {
    int srcType;
    private final int domSource = 1;
    private final int streamSource = 2;
    private final int saxSource = 4;

    public SourceUtils(Source source) {
        if (source instanceof StreamSource) {
            this.srcType = 2;
        } else if (source instanceof DOMSource) {
            this.srcType = 1;
        } else if (source instanceof SAXSource) {
            this.srcType = 4;
        }
    }

    public boolean isDOMSource() {
        return (this.srcType & 1) == 1;
    }

    public boolean isStreamSource() {
        return (this.srcType & 2) == 2;
    }

    public boolean isSaxSource() {
        return (this.srcType & 4) == 4;
    }

    public QName sniff(Source source) {
        return this.sniff(source, new RootElementSniffer());
    }

    public QName sniff(Source source, RootElementSniffer rootElementSniffer) {
        String string = null;
        String string2 = null;
        if (this.isDOMSource()) {
            DOMSource dOMSource = (DOMSource)source;
            Node node = dOMSource.getNode();
            if (node.getNodeType() == 9) {
                node = ((Document)node).getDocumentElement();
            }
            string = node.getLocalName();
            string2 = node.getNamespaceURI();
        } else if (this.isSaxSource()) {
            SAXSource sAXSource = (SAXSource)source;
            SAXResult sAXResult = new SAXResult(rootElementSniffer);
            try {
                Transformer transformer = XmlUtil.newTransformer();
                transformer.transform(sAXSource, sAXResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new WebServiceException(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                string = rootElementSniffer.getLocalName();
                string2 = rootElementSniffer.getNsUri();
            }
        }
        return new QName(string2, string);
    }

    public static void serializeSource(Source source, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        int n;
        XMLStreamReader xMLStreamReader = SourceReaderFactory.createSourceReader(source, true);
        block5: do {
            n = xMLStreamReader.next();
            switch (n) {
                case 1: {
                    String string;
                    String string2;
                    int n2;
                    String string3 = xMLStreamReader.getNamespaceURI();
                    String string4 = xMLStreamReader.getPrefix();
                    String string5 = xMLStreamReader.getLocalName();
                    if (string4 == null) {
                        if (string3 == null) {
                            xMLStreamWriter.writeStartElement(string5);
                        } else {
                            xMLStreamWriter.writeStartElement(string3, string5);
                        }
                    } else {
                        assert (string3 != null);
                        if (string4.length() > 0) {
                            String string6;
                            String string7 = null;
                            if (xMLStreamWriter.getNamespaceContext() != null) {
                                string7 = xMLStreamWriter.getNamespaceContext().getNamespaceURI(string4);
                            }
                            if (SourceUtils.declarePrefix(string4, string3, string6 = xMLStreamWriter.getPrefix(string3), string7)) {
                                xMLStreamWriter.writeStartElement(string4, string5, string3);
                                xMLStreamWriter.setPrefix(string4, string3 != null ? string3 : "");
                                xMLStreamWriter.writeNamespace(string4, string3);
                            } else {
                                xMLStreamWriter.writeStartElement(string4, string5, string3);
                            }
                        } else {
                            xMLStreamWriter.writeStartElement(string4, string5, string3);
                        }
                    }
                    int n3 = xMLStreamReader.getNamespaceCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        string2 = xMLStreamReader.getNamespacePrefix(n2);
                        if (string2 == null) {
                            string2 = "";
                        }
                        string = null;
                        if (xMLStreamWriter.getNamespaceContext() != null) {
                            string = xMLStreamWriter.getNamespaceContext().getNamespaceURI(string2);
                        }
                        String string8 = xMLStreamReader.getNamespaceURI(n2);
                        if (string != null && string2.length() != 0 && string4.length() != 0 && (string2.equals(string4) || string.equals(string8))) continue;
                        xMLStreamWriter.setPrefix(string2, string8 != null ? string8 : "");
                        xMLStreamWriter.writeNamespace(string2, string8 != null ? string8 : "");
                    }
                    n3 = xMLStreamReader.getAttributeCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        string2 = xMLStreamReader.getAttributePrefix(n2);
                        string = xMLStreamReader.getAttributeNamespace(n2);
                        xMLStreamWriter.writeAttribute(string2 != null ? string2 : "", string != null ? string : "", xMLStreamReader.getAttributeLocalName(n2), xMLStreamReader.getAttributeValue(n2));
                        SourceUtils.setUndeclaredPrefix(string2, string, xMLStreamWriter);
                    }
                    continue block5;
                }
                case 2: {
                    xMLStreamWriter.writeEndElement();
                    break;
                }
                case 4: {
                    xMLStreamWriter.writeCharacters(xMLStreamReader.getText());
                }
            }
        } while (n != 8);
        xMLStreamReader.close();
    }

    private static void setUndeclaredPrefix(String string, String string2, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string3 = null;
        if (xMLStreamWriter.getNamespaceContext() != null) {
            string3 = xMLStreamWriter.getNamespaceContext().getNamespaceURI(string);
        }
        if (string3 == null) {
            xMLStreamWriter.setPrefix(string, string2 != null ? string2 : "");
            xMLStreamWriter.writeNamespace(string, string2 != null ? string2 : "");
        }
    }

    private static boolean declarePrefix(String string, String string2, String string3, String string4) {
        return string4 == null || string3 != null && !string.equals(string3) || string2 != null && !string4.equals(string2);
    }
}

