/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_forms.hxx"

#include "sal/config.h"

#include "findpos.hxx"

#include "com/sun/star/uno/Sequence.hxx"
#include "comphelper/types.hxx"
#include "rtl/ustring.hxx"
#include "sal/types.h"

#include <algorithm>

namespace detail {

sal_Int32 findPos(
    const ::rtl::OUString& aStr,
    const ::com::sun::star::uno::Sequence< ::rtl::OUString >& rList)
{
    const ::rtl::OUString* pStrList = rList.getConstArray();
    const ::rtl::OUString* pResult = ::std::lower_bound(
        pStrList, pStrList + rList.getLength(), aStr );
    if ( ( pResult != pStrList + rList.getLength() ) && ( *pResult == aStr ) )
        return ( pResult - pStrList );

    return -1;
}

}
