require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_SPINLOCK_H)) {
    eval 'sub __ASM_SPINLOCK_H {1;}' unless defined(&__ASM_SPINLOCK_H);
    require 'asm/atomic.ph';
    require 'asm/rwlock.ph';
    require 'asm/page.ph';
    require 'linux/config.ph';
    require 'linux/compiler.ph';
    eval 'sub __raw_spin_is_locked {
        my($x) = @_;
	    eval q((*( &volatile \'signed char\' *)(($x)-> &slock) <= 0));
    }' unless defined(&__raw_spin_is_locked);
    eval 'sub __raw_spin_lock_string {"\\n1:\\t" "lock ; decb %0\\n\\t" "jns 3f\\n" "2:\\t" "rep;nop\\n\\t" "cmpb $0,%0\\n\\t" "jle 2b\\n\\t" "jmp 1b\\n" "3:\\n\\t";}' unless defined(&__raw_spin_lock_string);
    eval 'sub __raw_spin_lock_string_flags {"\\n1:\\t" "lock ; decb %0\\n\\t" "jns 4f\\n\\t" "2:\\t" "testl $0x200, %1\\n\\t" "jz 3f\\n\\t" "sti\\n\\t" "3:\\t" "rep;nop\\n\\t" "cmpb $0, %0\\n\\t" "jle 3b\\n\\t" "cli\\n\\t" "jmp 1b\\n" "4:\\n\\t";}' unless defined(&__raw_spin_lock_string_flags);
    eval 'sub __raw_spin_lock {
        my($lock) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__raw_spin_lock);
    eval 'sub __raw_spin_lock_flags {
        my($lock,$flags) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__raw_spin_lock_flags);
    eval 'sub __raw_spin_trylock {
        my($lock) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__raw_spin_trylock);
    if(!defined( &CONFIG_X86_OOSTORE)  && !defined( &CONFIG_X86_PPRO_FENCE)) {
	eval 'sub __raw_spin_unlock_string {"movb $1,%0" :"=m" ( ($lock->{slock})) : : "memory";}' unless defined(&__raw_spin_unlock_string);
	eval 'sub __raw_spin_unlock {
	    my($lock) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&__raw_spin_unlock);
    } else {
	eval 'sub __raw_spin_unlock_string {"xchgb %b0, %1" :"=q" ( &oldval), "=m" ( ($lock->{slock})) :"0" ( &oldval) : "memory";}' unless defined(&__raw_spin_unlock_string);
	eval 'sub __raw_spin_unlock {
	    my($lock) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&__raw_spin_unlock);
    }
    eval 'sub __raw_spin_unlock_wait {
        my($lock) = @_;
	    eval q( &do {  &while ( &__raw_spin_is_locked($lock))  &cpu_relax(); }  &while (0));
    }' unless defined(&__raw_spin_unlock_wait);
    eval 'sub __raw_read_can_lock {
        my($x) = @_;
	    eval q((($x)-> &lock > 0));
    }' unless defined(&__raw_read_can_lock);
    eval 'sub __raw_write_can_lock {
        my($x) = @_;
	    eval q((($x)-> &lock ==  &RW_LOCK_BIAS));
    }' unless defined(&__raw_write_can_lock);
    eval 'sub __raw_read_lock {
        my($rw) = @_;
	    eval q({  &__build_read_lock($rw, \\"__read_lock_failed\\"); });
    }' unless defined(&__raw_read_lock);
    eval 'sub __raw_write_lock {
        my($rw) = @_;
	    eval q({  &__build_write_lock($rw, \\"__write_lock_failed\\"); });
    }' unless defined(&__raw_write_lock);
    eval 'sub __raw_read_trylock {
        my($lock) = @_;
	    eval q({  &atomic_t * &count = ( &atomic_t *)$lock;  &atomic_dec( &count);  &if ( &atomic_read( &count) >= 0) 1;  &atomic_inc( &count); 0; });
    }' unless defined(&__raw_read_trylock);
    eval 'sub __raw_write_trylock {
        my($lock) = @_;
	    eval q({  &atomic_t * &count = ( &atomic_t *)$lock;  &if ( &atomic_sub_and_test( &RW_LOCK_BIAS,  &count)) 1;  &atomic_add( &RW_LOCK_BIAS,  &count); 0; });
    }' unless defined(&__raw_write_trylock);
    eval 'sub __raw_read_unlock {
        my($rw) = @_;
	    eval q({  &asm  &volatile(\\"lock ; incl %0\\" :\\"=m\\" ( ($rw->{lock})) : : \\"memory\\"); });
    }' unless defined(&__raw_read_unlock);
    eval 'sub __raw_write_unlock {
        my($rw) = @_;
	    eval q({  &asm  &volatile(\\"lock ; addl $\\"  &RW_LOCK_BIAS_STR \\", %0\\" : \\"=m\\" ( ($rw->{lock})) : : \\"memory\\"); });
    }' unless defined(&__raw_write_unlock);
}
1;
