require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_CRYPTO_H)) {
    eval 'sub _LINUX_CRYPTO_H {1;}' unless defined(&_LINUX_CRYPTO_H);
    require 'linux/config.ph';
    require 'linux/module.ph';
    require 'linux/kernel.ph';
    require 'linux/types.ph';
    require 'linux/list.ph';
    require 'linux/string.ph';
    require 'asm/page.ph';
    eval 'sub CRYPTO_ALG_TYPE_MASK {0xff;}' unless defined(&CRYPTO_ALG_TYPE_MASK);
    eval 'sub CRYPTO_ALG_TYPE_CIPHER {0x1;}' unless defined(&CRYPTO_ALG_TYPE_CIPHER);
    eval 'sub CRYPTO_ALG_TYPE_DIGEST {0x2;}' unless defined(&CRYPTO_ALG_TYPE_DIGEST);
    eval 'sub CRYPTO_ALG_TYPE_COMPRESS {0x4;}' unless defined(&CRYPTO_ALG_TYPE_COMPRESS);
    eval 'sub CRYPTO_TFM_MODE_MASK {0xff;}' unless defined(&CRYPTO_TFM_MODE_MASK);
    eval 'sub CRYPTO_TFM_REQ_MASK {0xfff00;}' unless defined(&CRYPTO_TFM_REQ_MASK);
    eval 'sub CRYPTO_TFM_RES_MASK {0xfff00000;}' unless defined(&CRYPTO_TFM_RES_MASK);
    eval 'sub CRYPTO_TFM_MODE_ECB {0x1;}' unless defined(&CRYPTO_TFM_MODE_ECB);
    eval 'sub CRYPTO_TFM_MODE_CBC {0x2;}' unless defined(&CRYPTO_TFM_MODE_CBC);
    eval 'sub CRYPTO_TFM_MODE_CFB {0x4;}' unless defined(&CRYPTO_TFM_MODE_CFB);
    eval 'sub CRYPTO_TFM_MODE_CTR {0x8;}' unless defined(&CRYPTO_TFM_MODE_CTR);
    eval 'sub CRYPTO_TFM_REQ_WEAK_KEY {0x100;}' unless defined(&CRYPTO_TFM_REQ_WEAK_KEY);
    eval 'sub CRYPTO_TFM_REQ_MAY_SLEEP {0x200;}' unless defined(&CRYPTO_TFM_REQ_MAY_SLEEP);
    eval 'sub CRYPTO_TFM_RES_WEAK_KEY {0x100000;}' unless defined(&CRYPTO_TFM_RES_WEAK_KEY);
    eval 'sub CRYPTO_TFM_RES_BAD_KEY_LEN {0x200000;}' unless defined(&CRYPTO_TFM_RES_BAD_KEY_LEN);
    eval 'sub CRYPTO_TFM_RES_BAD_KEY_SCHED {0x400000;}' unless defined(&CRYPTO_TFM_RES_BAD_KEY_SCHED);
    eval 'sub CRYPTO_TFM_RES_BAD_BLOCK_LEN {0x800000;}' unless defined(&CRYPTO_TFM_RES_BAD_BLOCK_LEN);
    eval 'sub CRYPTO_TFM_RES_BAD_FLAGS {0x1000000;}' unless defined(&CRYPTO_TFM_RES_BAD_FLAGS);
    eval 'sub CRYPTO_UNSPEC {0;}' unless defined(&CRYPTO_UNSPEC);
    eval 'sub CRYPTO_MAX_ALG_NAME {64;}' unless defined(&CRYPTO_MAX_ALG_NAME);
    eval 'sub CRYPTO_DIR_ENCRYPT {1;}' unless defined(&CRYPTO_DIR_ENCRYPT);
    eval 'sub CRYPTO_DIR_DECRYPT {0;}' unless defined(&CRYPTO_DIR_DECRYPT);
    eval 'sub cra_cipher { ($cra_u->{cipher});}' unless defined(&cra_cipher);
    eval 'sub cra_digest { ($cra_u->{digest});}' unless defined(&cra_digest);
    eval 'sub cra_compress { ($cra_u->{compress});}' unless defined(&cra_compress);
    if(defined(&CONFIG_CRYPTO)) {
    } else {
	eval 'sub crypto_alg_available {
	    my($name,$flags) = @_;
    	    eval q({ 0; });
	}' unless defined(&crypto_alg_available);
    }
    if(defined(&CONFIG_CRYPTO_HMAC)) {
    }
    eval 'sub crt_cipher { ($crt_u->{cipher});}' unless defined(&crt_cipher);
    eval 'sub crt_digest { ($crt_u->{digest});}' unless defined(&crt_digest);
    eval 'sub crt_compress { ($crt_u->{compress});}' unless defined(&crt_compress);
    eval 'sub char {
        eval q(* &crypto_tfm_alg_modname(\'struct crypto_tfm\' * &tfm) {  &module_name( ($tfm->{__crt_alg}->{cra_module})); });
    }' unless defined(&char);
    eval 'sub crypto_tfm_alg_type {
        my($tfm) = @_;
	    eval q({  ($tfm->{__crt_alg}->{cra_flags}) &  &CRYPTO_ALG_TYPE_MASK; });
    }' unless defined(&crypto_tfm_alg_type);
    eval 'sub crypto_tfm_alg_min_keysize {
        my($tfm) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_CIPHER);  ($tfm->{__crt_alg}->{cra_cipher}->{cia_min_keysize}); });
    }' unless defined(&crypto_tfm_alg_min_keysize);
    eval 'sub crypto_tfm_alg_max_keysize {
        my($tfm) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_CIPHER);  ($tfm->{__crt_alg}->{cra_cipher}->{cia_max_keysize}); });
    }' unless defined(&crypto_tfm_alg_max_keysize);
    eval 'sub crypto_tfm_alg_ivsize {
        my($tfm) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_CIPHER);  ($tfm->{crt_cipher}->{cit_ivsize}); });
    }' unless defined(&crypto_tfm_alg_ivsize);
    eval 'sub crypto_tfm_alg_blocksize {
        my($tfm) = @_;
	    eval q({  ($tfm->{__crt_alg}->{cra_blocksize}); });
    }' unless defined(&crypto_tfm_alg_blocksize);
    eval 'sub crypto_tfm_alg_digestsize {
        my($tfm) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_DIGEST);  ($tfm->{__crt_alg}->{cra_digest}->{dia_digestsize}); });
    }' unless defined(&crypto_tfm_alg_digestsize);
    eval 'sub crypto_tfm_alg_alignmask {
        my($tfm) = @_;
	    eval q({  ($tfm->{__crt_alg}->{cra_alignmask}); });
    }' unless defined(&crypto_tfm_alg_alignmask);
    eval 'sub void {
        eval q(* &crypto_tfm_ctx(\'struct crypto_tfm\' * &tfm) { ( &void *) $tfm[1]; });
    }' unless defined(&void);
    eval 'sub crypto_digest_update {
        my($tfm,$sg,$nsg) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_DIGEST);  ($tfm->{crt_digest}->{dit_update})($tfm, $sg, $nsg); });
    }' unless defined(&crypto_digest_update);
    eval 'sub crypto_digest_final {
        my($tfm,$out) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_DIGEST);  ($tfm->{crt_digest}->{dit_final})($tfm, $out); });
    }' unless defined(&crypto_digest_final);
    eval 'sub crypto_digest_digest {
        my($tfm,$sg,$nsg,$out) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_DIGEST);  ($tfm->{crt_digest}->{dit_digest})($tfm, $sg, $nsg, $out); });
    }' unless defined(&crypto_digest_digest);
    eval 'sub crypto_digest_setkey {
        my($tfm,$key,$keylen) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_DIGEST);  &if ( ($tfm->{crt_digest}->{dit_setkey}) ==  &NULL) - &ENOSYS;  ($tfm->{crt_digest}->{dit_setkey})($tfm, $key, $keylen); });
    }' unless defined(&crypto_digest_setkey);
    eval 'sub crypto_cipher_setkey {
        my($tfm,$key,$keylen) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_CIPHER);  ($tfm->{crt_cipher}->{cit_setkey})($tfm, $key, $keylen); });
    }' unless defined(&crypto_cipher_setkey);
    eval 'sub crypto_cipher_encrypt {
        my($tfm,$dst,$src,$nbytes) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_CIPHER);  ($tfm->{crt_cipher}->{cit_encrypt})($tfm, $dst, $src, $nbytes); } );
    }' unless defined(&crypto_cipher_encrypt);
    eval 'sub crypto_cipher_encrypt_iv {
        my($tfm,$dst,$src,$nbytes,$iv) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_CIPHER);  &BUG_ON( ($tfm->{crt_cipher}->{cit_mode}) ==  &CRYPTO_TFM_MODE_ECB);  ($tfm->{crt_cipher}->{cit_encrypt_iv})($tfm, $dst, $src, $nbytes, $iv); } );
    }' unless defined(&crypto_cipher_encrypt_iv);
    eval 'sub crypto_cipher_decrypt {
        my($tfm,$dst,$src,$nbytes) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_CIPHER);  ($tfm->{crt_cipher}->{cit_decrypt})($tfm, $dst, $src, $nbytes); });
    }' unless defined(&crypto_cipher_decrypt);
    eval 'sub crypto_cipher_decrypt_iv {
        my($tfm,$dst,$src,$nbytes,$iv) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_CIPHER);  &BUG_ON( ($tfm->{crt_cipher}->{cit_mode}) ==  &CRYPTO_TFM_MODE_ECB);  ($tfm->{crt_cipher}->{cit_decrypt_iv})($tfm, $dst, $src, $nbytes, $iv); });
    }' unless defined(&crypto_cipher_decrypt_iv);
    eval 'sub crypto_cipher_set_iv {
        my($tfm,$src,$len) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_CIPHER);  &memcpy( ($tfm->{crt_cipher}->{cit_iv}), $src, $len); });
    }' unless defined(&crypto_cipher_set_iv);
    eval 'sub crypto_cipher_get_iv {
        my($tfm,$dst,$len) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_CIPHER);  &memcpy($dst,  ($tfm->{crt_cipher}->{cit_iv}), $len); });
    }' unless defined(&crypto_cipher_get_iv);
    eval 'sub crypto_comp_compress {
        my($tfm,$src,$slen,$dst,$dlen) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_COMPRESS);  ($tfm->{crt_compress}->{cot_compress})($tfm, $src, $slen, $dst, $dlen); });
    }' unless defined(&crypto_comp_compress);
    eval 'sub crypto_comp_decompress {
        my($tfm,$src,$slen,$dst,$dlen) = @_;
	    eval q({  &BUG_ON( &crypto_tfm_alg_type($tfm) !=  &CRYPTO_ALG_TYPE_COMPRESS);  ($tfm->{crt_compress}->{cot_decompress})($tfm, $src, $slen, $dst, $dlen); });
    }' unless defined(&crypto_comp_decompress);
    if(defined(&CONFIG_CRYPTO_HMAC)) {
    }
}
1;
