require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_HIGHMEM_H)) {
    eval 'sub _LINUX_HIGHMEM_H {1;}' unless defined(&_LINUX_HIGHMEM_H);
    require 'linux/config.ph';
    require 'linux/fs.ph';
    require 'linux/mm.ph';
    require 'asm/cacheflush.ph';
    if(defined(&CONFIG_HIGHMEM)) {
	require 'asm/highmem.ph';
    } else {
	eval 'sub kunmap {
	    my($page) = @_;
    	    eval q( &do { ( &void) ($page); }  &while (0));
	}' unless defined(&kunmap);
	eval 'sub kmap_atomic {
	    my($page, $idx) = @_;
    	    eval q( &page_address($page));
	}' unless defined(&kmap_atomic);
	eval 'sub kunmap_atomic {
	    my($addr, $idx) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&kunmap_atomic);
	eval 'sub kmap_atomic_pfn {
	    my($pfn, $idx) = @_;
    	    eval q( &page_address( &pfn_to_page($pfn)));
	}' unless defined(&kmap_atomic_pfn);
	eval 'sub kmap_atomic_to_page {
	    my($ptr) = @_;
    	    eval q( &virt_to_page($ptr));
	}' unless defined(&kmap_atomic_to_page);
    }
    unless(defined(&__HAVE_ARCH_ALLOC_ZEROED_USER_HIGHPAGE)) {
	eval 'sub alloc_zeroed_user_highpage {
	    my($vma,$vaddr) = @_;
    	    eval q({ \'struct page\' * &page =  &alloc_page_vma( &GFP_HIGHUSER, $vma, $vaddr);  &if ( &page)  &clear_user_highpage( &page, $vaddr);  &page; });
	}' unless defined(&alloc_zeroed_user_highpage);
    }
    eval 'sub clear_highpage {
        my($page) = @_;
	    eval q({  &void * &kaddr =  &kmap_atomic($page,  &KM_USER0);  &clear_page( &kaddr);  &kunmap_atomic( &kaddr,  &KM_USER0); });
    }' unless defined(&clear_highpage);
    eval 'sub copy_user_highpage {
        my($to,$from,$vaddr) = @_;
	    eval q({ \'char\' * &vfrom, * &vto;  &vfrom =  &kmap_atomic($from,  &KM_USER0);  &vto =  &kmap_atomic($to,  &KM_USER1);  &copy_user_page( &vto,  &vfrom, $vaddr, $to);  &kunmap_atomic( &vfrom,  &KM_USER0);  &kunmap_atomic( &vto,  &KM_USER1);  &smp_wmb(); });
    }' unless defined(&copy_user_highpage);
    eval 'sub copy_highpage {
        my($to,$from) = @_;
	    eval q({ \'char\' * &vfrom, * &vto;  &vfrom =  &kmap_atomic($from,  &KM_USER0);  &vto =  &kmap_atomic($to,  &KM_USER1);  &copy_page( &vto,  &vfrom);  &kunmap_atomic( &vfrom,  &KM_USER0);  &kunmap_atomic( &vto,  &KM_USER1); });
    }' unless defined(&copy_highpage);
}
1;
