require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_IF_VLAN_H_)) {
    eval 'sub _LINUX_IF_VLAN_H_ {1;}' unless defined(&_LINUX_IF_VLAN_H_);
    if(defined(&__KERNEL__)) {
	require 'linux/proc_fs.ph';
	require 'linux/netdevice.ph';
	eval 'sub VLAN_HLEN {4;}' unless defined(&VLAN_HLEN);
	eval 'sub VLAN_ETH_ALEN {6;}' unless defined(&VLAN_ETH_ALEN);
	eval 'sub VLAN_ETH_HLEN {18;}' unless defined(&VLAN_ETH_HLEN);
	eval 'sub VLAN_ETH_ZLEN {64;}' unless defined(&VLAN_ETH_ZLEN);
	eval 'sub VLAN_ETH_DATA_LEN {1500;}' unless defined(&VLAN_ETH_DATA_LEN);
	eval 'sub VLAN_ETH_FRAME_LEN {1518;}' unless defined(&VLAN_ETH_FRAME_LEN);
	require 'linux/skbuff.ph';
	eval 'sub vlan_ethhdr {
	    eval q(* &vlan_eth_hdr( &const \'struct sk_buff\' * &skb) {  ($skb->{mac}->{raw}); });
	}' unless defined(&vlan_ethhdr);
	eval 'sub VLAN_VID_MASK {0xfff;}' unless defined(&VLAN_VID_MASK);
	eval 'sub VLAN_NAME {"vlan";}' unless defined(&VLAN_NAME);
	eval 'sub VLAN_GROUP_ARRAY_LEN {4096;}' unless defined(&VLAN_GROUP_ARRAY_LEN);
	eval 'sub VLAN_DEV_INFO {
	    my($x) = @_;
    	    eval q((( ($x->{priv}))));
	}' unless defined(&VLAN_DEV_INFO);
	eval 'sub vlan_get_ingress_priority {
	    my($dev,$vlan_tag) = @_;
    	    eval q({ \'struct vlan_dev_info\' * &vip =  &VLAN_DEV_INFO($dev);  ($vip->{ingress_priority_map[(vlan_tag >> 13) & 0x7]}); });
	}' unless defined(&vlan_get_ingress_priority);
	eval 'sub VLAN_TX_COOKIE_MAGIC {0x564c414e;}' unless defined(&VLAN_TX_COOKIE_MAGIC);
	eval 'sub VLAN_TX_SKB_CB {
	    my($__skb) = @_;
    	    eval q(((($__skb)-> $cb[0])));
	}' unless defined(&VLAN_TX_SKB_CB);
	eval 'sub vlan_tx_tag_present {
	    my($__skb) = @_;
    	    eval q(( &VLAN_TX_SKB_CB($__skb)-> &magic ==  &VLAN_TX_COOKIE_MAGIC));
	}' unless defined(&vlan_tx_tag_present);
	eval 'sub vlan_tx_tag_get {
	    my($__skb) = @_;
    	    eval q(( &VLAN_TX_SKB_CB($__skb)-> &vlan_tag));
	}' unless defined(&vlan_tx_tag_get);
	eval 'sub vlan_hwaccel_rx {
	    my($skb,$grp,$vlan_tag) = @_;
    	    eval q({  &__vlan_hwaccel_rx($skb, $grp, $vlan_tag, 0); });
	}' unless defined(&vlan_hwaccel_rx);
	eval 'sub vlan_hwaccel_receive_skb {
	    my($skb,$grp,$vlan_tag) = @_;
    	    eval q({  &__vlan_hwaccel_rx($skb, $grp, $vlan_tag, 1); });
	}' unless defined(&vlan_hwaccel_receive_skb);
	eval 'sub HAVE_VLAN_PUT_TAG {1;}' unless defined(&HAVE_VLAN_PUT_TAG);
	eval 'sub HAVE_VLAN_GET_TAG {1;}' unless defined(&HAVE_VLAN_GET_TAG);
    }
    eval("sub ADD_VLAN_CMD () { 0; }") unless defined(&ADD_VLAN_CMD);
    eval("sub DEL_VLAN_CMD () { 1; }") unless defined(&DEL_VLAN_CMD);
    eval("sub SET_VLAN_INGRESS_PRIORITY_CMD () { 2; }") unless defined(&SET_VLAN_INGRESS_PRIORITY_CMD);
    eval("sub SET_VLAN_EGRESS_PRIORITY_CMD () { 3; }") unless defined(&SET_VLAN_EGRESS_PRIORITY_CMD);
    eval("sub GET_VLAN_INGRESS_PRIORITY_CMD () { 4; }") unless defined(&GET_VLAN_INGRESS_PRIORITY_CMD);
    eval("sub GET_VLAN_EGRESS_PRIORITY_CMD () { 5; }") unless defined(&GET_VLAN_EGRESS_PRIORITY_CMD);
    eval("sub SET_VLAN_NAME_TYPE_CMD () { 6; }") unless defined(&SET_VLAN_NAME_TYPE_CMD);
    eval("sub SET_VLAN_FLAG_CMD () { 7; }") unless defined(&SET_VLAN_FLAG_CMD);
    eval("sub GET_VLAN_REALDEV_NAME_CMD () { 8; }") unless defined(&GET_VLAN_REALDEV_NAME_CMD);
    eval("sub GET_VLAN_VID_CMD () { 9; }") unless defined(&GET_VLAN_VID_CMD);
    eval("sub VLAN_NAME_TYPE_PLUS_VID () { 0; }") unless defined(&VLAN_NAME_TYPE_PLUS_VID);
    eval("sub VLAN_NAME_TYPE_RAW_PLUS_VID () { 1; }") unless defined(&VLAN_NAME_TYPE_RAW_PLUS_VID);
    eval("sub VLAN_NAME_TYPE_PLUS_VID_NO_PAD () { 2; }") unless defined(&VLAN_NAME_TYPE_PLUS_VID_NO_PAD);
    eval("sub VLAN_NAME_TYPE_RAW_PLUS_VID_NO_PAD () { 3; }") unless defined(&VLAN_NAME_TYPE_RAW_PLUS_VID_NO_PAD);
    eval("sub VLAN_NAME_TYPE_HIGHEST () { 4; }") unless defined(&VLAN_NAME_TYPE_HIGHEST);
}
1;
