require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&IOPRIO_H)) {
    eval 'sub IOPRIO_H {1;}' unless defined(&IOPRIO_H);
    require 'linux/sched.ph';
    eval 'sub IOPRIO_BITS {(16);}' unless defined(&IOPRIO_BITS);
    eval 'sub IOPRIO_CLASS_SHIFT {(13);}' unless defined(&IOPRIO_CLASS_SHIFT);
    eval 'sub IOPRIO_PRIO_MASK {((1 <<  &IOPRIO_CLASS_SHIFT) - 1);}' unless defined(&IOPRIO_PRIO_MASK);
    eval 'sub IOPRIO_PRIO_CLASS {
        my($mask) = @_;
	    eval q((($mask) >>  &IOPRIO_CLASS_SHIFT));
    }' unless defined(&IOPRIO_PRIO_CLASS);
    eval 'sub IOPRIO_PRIO_DATA {
        my($mask) = @_;
	    eval q((($mask) &  &IOPRIO_PRIO_MASK));
    }' unless defined(&IOPRIO_PRIO_DATA);
    eval 'sub IOPRIO_PRIO_VALUE {
        my($class, $data) = @_;
	    eval q(((($class) <<  &IOPRIO_CLASS_SHIFT) | $data));
    }' unless defined(&IOPRIO_PRIO_VALUE);
    eval 'sub ioprio_valid {
        my($mask) = @_;
	    eval q(( &IOPRIO_PRIO_CLASS(($mask)) !=  &IOPRIO_CLASS_NONE));
    }' unless defined(&ioprio_valid);
    eval("sub IOPRIO_CLASS_NONE () { 0; }") unless defined(&IOPRIO_CLASS_NONE);
    eval("sub IOPRIO_CLASS_RT () { 1; }") unless defined(&IOPRIO_CLASS_RT);
    eval("sub IOPRIO_CLASS_BE () { 2; }") unless defined(&IOPRIO_CLASS_BE);
    eval("sub IOPRIO_CLASS_IDLE () { 3; }") unless defined(&IOPRIO_CLASS_IDLE);
    eval 'sub IOPRIO_BE_NR {(8);}' unless defined(&IOPRIO_BE_NR);
    eval("sub IOPRIO_WHO_PROCESS () { 1; }") unless defined(&IOPRIO_WHO_PROCESS);
    eval("sub IOPRIO_WHO_PGRP () { 2; }") unless defined(&IOPRIO_WHO_PGRP);
    eval("sub IOPRIO_WHO_USER () { 3; }") unless defined(&IOPRIO_WHO_USER);
    eval 'sub IOPRIO_NORM {(4);}' unless defined(&IOPRIO_NORM);
    eval 'sub task_ioprio {
        my($task) = @_;
	    eval q({  &WARN_ON(! &ioprio_valid( ($task->{ioprio})));  &IOPRIO_PRIO_DATA( ($task->{ioprio})); });
    }' unless defined(&task_ioprio);
    eval 'sub task_nice_ioprio {
        my($task) = @_;
	    eval q({ ( &task_nice($task) + 20) / 5; });
    }' unless defined(&task_nice_ioprio);
}
1;
