require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__irq_h)) {
    eval 'sub __irq_h {1;}' unless defined(&__irq_h);
    require 'linux/config.ph';
    require 'linux/smp.ph';
    if(!defined( &CONFIG_S390)) {
	require 'linux/linkage.ph';
	require 'linux/cache.ph';
	require 'linux/spinlock.ph';
	require 'linux/cpumask.ph';
	require 'asm/irq.ph';
	require 'asm/ptrace.ph';
	eval 'sub IRQ_INPROGRESS {1;}' unless defined(&IRQ_INPROGRESS);
	eval 'sub IRQ_DISABLED {2;}' unless defined(&IRQ_DISABLED);
	eval 'sub IRQ_PENDING {4;}' unless defined(&IRQ_PENDING);
	eval 'sub IRQ_REPLAY {8;}' unless defined(&IRQ_REPLAY);
	eval 'sub IRQ_AUTODETECT {16;}' unless defined(&IRQ_AUTODETECT);
	eval 'sub IRQ_WAITING {32;}' unless defined(&IRQ_WAITING);
	eval 'sub IRQ_LEVEL {64;}' unless defined(&IRQ_LEVEL);
	eval 'sub IRQ_MASKED {128;}' unless defined(&IRQ_MASKED);
	if(defined( &ARCH_HAS_IRQ_PER_CPU)) {
	    eval 'sub IRQ_PER_CPU {256;}' unless defined(&IRQ_PER_CPU);
	    eval 'sub CHECK_IRQ_PER_CPU {
	        my($var) = @_;
    		eval q((($var) &  &IRQ_PER_CPU));
	    }' unless defined(&CHECK_IRQ_PER_CPU);
	} else {
	    eval 'sub CHECK_IRQ_PER_CPU {
	        my($var) = @_;
    		eval q(0);
	    }' unless defined(&CHECK_IRQ_PER_CPU);
	}
	if(defined(&CONFIG_IRQ_RELEASE_METHOD)) {
	}
	if(defined ( &CONFIG_GENERIC_PENDING_IRQ) || defined ( &CONFIG_IRQBALANCE)) {
	}
	require 'asm/hw_irq.ph';
	if(defined(&CONFIG_GENERIC_HARDIRQS)) {
	    if(defined(&CONFIG_SMP)) {
		eval 'sub set_native_irq_info {
		    my($irq,$mask) = @_;
    		    eval q({  $irq_affinity[$irq] = $mask; });
		}' unless defined(&set_native_irq_info);
	    } else {
		eval 'sub set_native_irq_info {
		    my($irq,$mask) = @_;
    		    eval q({ });
		}' unless defined(&set_native_irq_info);
	    }
	    if(defined(&CONFIG_SMP)) {
		if(defined ( &CONFIG_GENERIC_PENDING_IRQ) || defined ( &CONFIG_IRQBALANCE)) {
		    eval 'sub set_pending_irq {
		        my($irq,$mask) = @_;
    			eval q({  &irq_desc_t * &desc =  &irq_desc + $irq; my $flags;  &spin_lock_irqsave( ($desc->{lock}),  $flags);  ($desc->{move_irq}) = 1;  $pending_irq_cpumask[$irq] = $mask;  &spin_unlock_irqrestore( ($desc->{lock}),  $flags); });
		    }' unless defined(&set_pending_irq);
		    eval 'sub move_native_irq {
		        my($irq) = @_;
    			eval q({  &cpumask_t  &tmp;  &irq_desc_t * &desc =  &irq_descp($irq);  &if ( &likely (! ($desc->{move_irq}))) ;  ($desc->{move_irq}) = 0;  &if ( &likely( &cpus_empty( $pending_irq_cpumask[$irq]))) ;  &if (! ($desc->{handler}->{set_affinity})) ;  &cpus_and( &tmp,  $pending_irq_cpumask[$irq],  &cpu_online_map);  &if ( &unlikely(! &cpus_empty( &tmp))) {  ($desc->{handler}->{disable})($irq);  ($desc->{handler}->{set_affinity})($irq, &tmp);  ($desc->{handler}->{enable})($irq); }  &cpus_clear( $pending_irq_cpumask[$irq]); });
		    }' unless defined(&move_native_irq);
		    if(defined(&CONFIG_PCI_MSI)) {
			eval 'sub set_irq_info {
			    my($irq,$mask) = @_;
    			    eval q({ });
			}' unless defined(&set_irq_info);
		    } else {
			eval 'sub move_irq {
			    my($irq) = @_;
    			    eval q({  &move_native_irq($irq); });
			}' unless defined(&move_irq);
			eval 'sub set_irq_info {
			    my($irq,$mask) = @_;
    			    eval q({  &set_native_irq_info($irq, $mask); });
			}' unless defined(&set_irq_info);
		    }
		} else {
		    eval 'sub move_irq {
		        my($x) = @_;
    			eval q();
		    }' unless defined(&move_irq);
		    eval 'sub move_native_irq {
		        my($x) = @_;
    			eval q();
		    }' unless defined(&move_native_irq);
		    eval 'sub set_pending_irq {
		        my($x,$y) = @_;
    			eval q();
		    }' unless defined(&set_pending_irq);
		    eval 'sub set_irq_info {
		        my($irq,$mask) = @_;
    			eval q({  &set_native_irq_info($irq, $mask); });
		    }' unless defined(&set_irq_info);
		}
	    } else {
		eval 'sub move_irq {
		    my($x) = @_;
    		    eval q();
		}' unless defined(&move_irq);
		eval 'sub move_native_irq {
		    my($x) = @_;
    		    eval q();
		}' unless defined(&move_native_irq);
	    }
	    if(defined(&CONFIG_AUTO_IRQ_AFFINITY)) {
	    } else {
		eval 'sub select_smp_affinity {
		    my($irq) = @_;
    		    eval q({ 1; });
		}' unless defined(&select_smp_affinity);
	    }
	}
    }
}
1;
