require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_KPROBES_H)) {
    eval 'sub _LINUX_KPROBES_H {1;}' unless defined(&_LINUX_KPROBES_H);
    require 'linux/config.ph';
    require 'linux/list.ph';
    require 'linux/notifier.ph';
    require 'linux/smp.ph';
    require 'linux/percpu.ph';
    require 'linux/spinlock.ph';
    require 'linux/rcupdate.ph';
    if(defined(&CONFIG_KPROBES)) {
	require 'asm/kprobes.ph';
	eval 'sub KPROBE_HIT_ACTIVE {0x1;}' unless defined(&KPROBE_HIT_ACTIVE);
	eval 'sub KPROBE_HIT_SS {0x2;}' unless defined(&KPROBE_HIT_SS);
	eval 'sub KPROBE_REENTER {0x4;}' unless defined(&KPROBE_REENTER);
	eval 'sub KPROBE_HIT_SSDONE {0x8;}' unless defined(&KPROBE_HIT_SSDONE);
	eval 'sub __kprobes { &__attribute__(( &__section__(".kprobes.text")));}' unless defined(&__kprobes);
	if(defined(&ARCH_SUPPORTS_KRETPROBES)) {
	} else {
	    eval 'sub arch_prepare_kretprobe {
	        my($rp,$regs) = @_;
    		eval q({ });
	    }' unless defined(&arch_prepare_kretprobe);
	}
	eval 'sub reset_current_kprobe {
	    my($void) = @_;
    	    eval q({  &__get_cpu_var( &current_kprobe) =  &NULL; });
	}' unless defined(&reset_current_kprobe);
	eval 'sub kprobe_ctlblk {
	    eval q(* &get_kprobe_ctlblk( &void) { (& &__get_cpu_var( &kprobe_ctlblk)); });
	}' unless defined(&kprobe_ctlblk);
    } else {
	eval 'sub __kprobes {1;}' unless defined(&__kprobes);
	eval 'sub kprobe {
	    eval q(* &kprobe_running( &void) {  &NULL; });
	}' unless defined(&kprobe);
	eval 'sub register_kprobe {
	    my($p) = @_;
    	    eval q({ - &ENOSYS; });
	}' unless defined(&register_kprobe);
	eval 'sub unregister_kprobe {
	    my($p) = @_;
    	    eval q({ });
	}' unless defined(&unregister_kprobe);
	eval 'sub register_jprobe {
	    my($p) = @_;
    	    eval q({ - &ENOSYS; });
	}' unless defined(&register_jprobe);
	eval 'sub unregister_jprobe {
	    my($p) = @_;
    	    eval q({ });
	}' unless defined(&unregister_jprobe);
	eval 'sub jprobe_return {
	    my($void) = @_;
    	    eval q({ });
	}' unless defined(&jprobe_return);
	eval 'sub register_kretprobe {
	    my($rp) = @_;
    	    eval q({ - &ENOSYS; });
	}' unless defined(&register_kretprobe);
	eval 'sub unregister_kretprobe {
	    my($rp) = @_;
    	    eval q({ });
	}' unless defined(&unregister_kretprobe);
	eval 'sub kprobe_flush_task {
	    my($tk) = @_;
    	    eval q({ });
	}' unless defined(&kprobe_flush_task);
    }
}
1;
