require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_NFS_FS_H)) {
    eval 'sub _LINUX_NFS_FS_H {1;}' unless defined(&_LINUX_NFS_FS_H);
    require 'linux/config.ph';
    require 'linux/in.ph';
    require 'linux/mm.ph';
    require 'linux/pagemap.ph';
    require 'linux/rwsem.ph';
    require 'linux/wait.ph';
    require 'linux/nfs_fs_sb.ph';
    require 'linux/sunrpc/debug.ph';
    require 'linux/sunrpc/auth.ph';
    require 'linux/sunrpc/clnt.ph';
    require 'linux/nfs.ph';
    require 'linux/nfs2.ph';
    require 'linux/nfs3.ph';
    require 'linux/nfs4.ph';
    require 'linux/nfs_xdr.ph';
    require 'linux/rwsem.ph';
    require 'linux/mempool.ph';
    if(defined(&RPC_DEBUG)) {
	eval 'sub NFS_DEBUG {1;}' unless defined(&NFS_DEBUG);
    }
    eval 'sub NFS_MAX_UDP_TIMEOUT {(60* &HZ);}' unless defined(&NFS_MAX_UDP_TIMEOUT);
    eval 'sub NFS_MAX_TCP_TIMEOUT {(600* &HZ);}' unless defined(&NFS_MAX_TCP_TIMEOUT);
    eval 'sub NFS_SUPER_MAGIC {0x6969;}' unless defined(&NFS_SUPER_MAGIC);
    eval 'sub NFS_RPC_SWAPFLAGS {( &RPC_TASK_SWAPPER| &RPC_TASK_ROOTCREDS);}' unless defined(&NFS_RPC_SWAPFLAGS);
    eval 'sub FLUSH_AGING {0;}' unless defined(&FLUSH_AGING);
    eval 'sub FLUSH_SYNC {1;}' unless defined(&FLUSH_SYNC);
    eval 'sub FLUSH_WAIT {2;}' unless defined(&FLUSH_WAIT);
    eval 'sub FLUSH_STABLE {4;}' unless defined(&FLUSH_STABLE);
    eval 'sub FLUSH_LOWPRI {8;}' unless defined(&FLUSH_LOWPRI);
    eval 'sub FLUSH_HIGHPRI {16;}' unless defined(&FLUSH_HIGHPRI);
    eval 'sub FLUSH_NOCOMMIT {32;}' unless defined(&FLUSH_NOCOMMIT);
    if(defined(&__KERNEL__)) {
	if(defined(&CONFIG_NFS_V3_ACL)) {
	}
	if(defined(&CONFIG_NFS_V4)) {
	}
	eval 'sub NFS_INO_INVALID_ATTR {0x1;}' unless defined(&NFS_INO_INVALID_ATTR);
	eval 'sub NFS_INO_INVALID_DATA {0x2;}' unless defined(&NFS_INO_INVALID_DATA);
	eval 'sub NFS_INO_INVALID_ATIME {0x4;}' unless defined(&NFS_INO_INVALID_ATIME);
	eval 'sub NFS_INO_INVALID_ACCESS {0x8;}' unless defined(&NFS_INO_INVALID_ACCESS);
	eval 'sub NFS_INO_INVALID_ACL {0x10;}' unless defined(&NFS_INO_INVALID_ACL);
	eval 'sub NFS_INO_REVAL_PAGECACHE {0x20;}' unless defined(&NFS_INO_REVAL_PAGECACHE);
	eval 'sub NFS_INO_REVALIDATING {(0);}' unless defined(&NFS_INO_REVALIDATING);
	eval 'sub NFS_INO_ADVISE_RDPLUS {(1);}' unless defined(&NFS_INO_ADVISE_RDPLUS);
	eval 'sub NFS_INO_STALE {(2);}' unless defined(&NFS_INO_STALE);
	eval 'sub nfs_inode {
	    eval q(* &NFS_I(\'struct inode\' * &inode) {  &container_of( &inode, \'struct nfs_inode\',  &vfs_inode); });
	}' unless defined(&nfs_inode);
	eval 'sub NFS_SB {
	    my($s) = @_;
    	    eval q((( ($s->{s_fs_info}))));
	}' unless defined(&NFS_SB);
	eval 'sub NFS_FH {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &fh));
	}' unless defined(&NFS_FH);
	eval 'sub NFS_SERVER {
	    my($inode) = @_;
    	    eval q(( &NFS_SB( ($inode->{i_sb}))));
	}' unless defined(&NFS_SERVER);
	eval 'sub NFS_CLIENT {
	    my($inode) = @_;
    	    eval q(( &NFS_SERVER($inode)-> &client));
	}' unless defined(&NFS_CLIENT);
	eval 'sub NFS_PROTO {
	    my($inode) = @_;
    	    eval q(( &NFS_SERVER($inode)-> &rpc_ops));
	}' unless defined(&NFS_PROTO);
	eval 'sub NFS_ADDR {
	    my($inode) = @_;
    	    eval q(( &RPC_PEERADDR( &NFS_CLIENT($inode))));
	}' unless defined(&NFS_ADDR);
	eval 'sub NFS_COOKIEVERF {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &cookieverf));
	}' unless defined(&NFS_COOKIEVERF);
	eval 'sub NFS_READTIME {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &read_cache_jiffies));
	}' unless defined(&NFS_READTIME);
	eval 'sub NFS_CHANGE_ATTR {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &change_attr));
	}' unless defined(&NFS_CHANGE_ATTR);
	eval 'sub NFS_ATTRTIMEO {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &attrtimeo));
	}' unless defined(&NFS_ATTRTIMEO);
	eval 'sub NFS_MINATTRTIMEO {
	    my($inode) = @_;
    	    eval q(( &S_ISDIR( ($inode->{i_mode}))?  &NFS_SERVER($inode)-> &acdirmin :  &NFS_SERVER($inode)-> &acregmin));
	}' unless defined(&NFS_MINATTRTIMEO);
	eval 'sub NFS_MAXATTRTIMEO {
	    my($inode) = @_;
    	    eval q(( &S_ISDIR( ($inode->{i_mode}))?  &NFS_SERVER($inode)-> &acdirmax :  &NFS_SERVER($inode)-> &acregmax));
	}' unless defined(&NFS_MAXATTRTIMEO);
	eval 'sub NFS_ATTRTIMEO_UPDATE {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &attrtimeo_timestamp));
	}' unless defined(&NFS_ATTRTIMEO_UPDATE);
	eval 'sub NFS_FLAGS {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &flags));
	}' unless defined(&NFS_FLAGS);
	eval 'sub NFS_STALE {
	    my($inode) = @_;
    	    eval q(( &test_bit( &NFS_INO_STALE,  &NFS_FLAGS($inode))));
	}' unless defined(&NFS_STALE);
	eval 'sub NFS_FILEID {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &fileid));
	}' unless defined(&NFS_FILEID);
	eval 'sub nfs_caches_unstable {
	    my($inode) = @_;
    	    eval q({  &atomic_read( &NFS_I($inode)-> &data_updates) != 0; });
	}' unless defined(&nfs_caches_unstable);
	eval 'sub nfs_mark_for_revalidate {
	    my($inode) = @_;
    	    eval q({  &spin_lock( ($inode->{i_lock}));  &NFS_I($inode)-> &cache_validity |=  &NFS_INO_INVALID_ATTR |  &NFS_INO_INVALID_ACCESS;  &spin_unlock( ($inode->{i_lock})); });
	}' unless defined(&nfs_mark_for_revalidate);
	eval 'sub NFS_CACHEINV {
	    my($inode) = @_;
    	    eval q({  &if (! &nfs_caches_unstable($inode))  &nfs_mark_for_revalidate($inode); });
	}' unless defined(&NFS_CACHEINV);
	eval 'sub nfs_server_capable {
	    my($inode,$cap) = @_;
    	    eval q({  &NFS_SERVER($inode)-> &caps & $cap; });
	}' unless defined(&nfs_server_capable);
	eval 'sub NFS_USE_READDIRPLUS {
	    my($inode) = @_;
    	    eval q({  &test_bit( &NFS_INO_ADVISE_RDPLUS,  &NFS_FLAGS($inode)); });
	}' unless defined(&NFS_USE_READDIRPLUS);
	eval 'sub nfs_fattr_init {
	    my($fattr) = @_;
    	    eval q({  ($fattr->{valid}) = 0;  ($fattr->{time_start}) =  &jiffies; });
	}' unless defined(&nfs_fattr_init);
	if(defined(&CONFIG_NFS_V3)) {
	}
	eval 'sub rpc_cred {
	    eval q(* &nfs_file_cred(\'struct file\' * &file) {  &if ( &file !=  &NULL) { \'struct nfs_open_context\' * &ctx;  &ctx =  ($file->{private_data});  ($ctx->{cred}); }  &NULL; });
	}' unless defined(&rpc_cred);
	if(defined(&CONFIG_NFS_V3_ACL)) {
	} else {
	    eval 'sub nfs3_listxattr { &NULL;}' unless defined(&nfs3_listxattr);
	    eval 'sub nfs3_getxattr { &NULL;}' unless defined(&nfs3_getxattr);
	    eval 'sub nfs3_setxattr { &NULL;}' unless defined(&nfs3_setxattr);
	    eval 'sub nfs3_removexattr { &NULL;}' unless defined(&nfs3_removexattr);
	}
	if(defined(&CONFIG_NFS_V3)) {
	}
	if(defined(&CONFIG_SYSCTL)) {
	} else {
	    eval 'sub nfs_register_sysctl () {
	        eval q(0);
	    }' unless defined(&nfs_register_sysctl);
	    eval 'sub nfs_unregister_sysctl () {
	        eval q( &do { }  &while(0));
	    }' unless defined(&nfs_unregister_sysctl);
	}
	if(defined( &CONFIG_NFS_V3) || defined( &CONFIG_NFS_V4)) {
	}
	if(defined( &CONFIG_NFS_V3) || defined( &CONFIG_NFS_V4)) {
	} else {
	    eval 'sub nfs_commit_inode {
	        my($inode,$how) = @_;
    		eval q({ 0; });
	    }' unless defined(&nfs_commit_inode);
	}
	eval 'sub nfs_have_writebacks {
	    my($inode) = @_;
    	    eval q({  &NFS_I($inode)-> &npages != 0; });
	}' unless defined(&nfs_have_writebacks);
	eval 'sub nfs_wb_all {
	    my($inode) = @_;
    	    eval q({ \'int\'  &error =  &nfs_sync_inode($inode, 0, 0,  &FLUSH_WAIT); ( &error < 0) ?  &error : 0; });
	}' unless defined(&nfs_wb_all);
	eval 'sub nfs_wb_page {
	    my($inode,$page) = @_;
    	    eval q({  &nfs_wb_page_priority($inode, $page, 0); });
	}' unless defined(&nfs_wb_page);
	eval 'sub nfs_write_data {
	    eval q(* &nfs_writedata_alloc { \'struct nfs_write_data\' * &p =  &mempool_alloc( &nfs_wdata_mempool,  &SLAB_NOFS);  &if ( &p) {  &memset( &p, 0, $sizeof{ &p});  &INIT_LIST_HEAD( ($p->{pages}));  &if ( &pagecount <  &NFS_PAGEVEC_SIZE)  ($p->{pagevec}) =  ($p->{page_array[0]});  &else { \'size_t\'  &size = ++ &pagecount * $sizeof{\'struct page\' };  ($p->{pagevec}) =  &kmalloc( &size,  &GFP_NOFS);  &if ( ($p->{pagevec})) {  &memset( ($p->{pagevec}), 0,  &size); }  &else {  &mempool_free( &p,  &nfs_wdata_mempool);  &p =  &NULL; } } }  &p; });
	}' unless defined(&nfs_write_data);
	eval 'sub nfs_writedata_free {
	    my($p) = @_;
    	    eval q({  &if ($p  && ( ($p->{pagevec}) !=  ($p->{page_array[0]})))  &kfree( ($p->{pagevec}));  &mempool_free($p,  &nfs_wdata_mempool); });
	}' unless defined(&nfs_writedata_free);
	eval 'sub nfs_read_data {
	    eval q(* &nfs_readdata_alloc { \'struct nfs_read_data\' * &p =  &mempool_alloc( &nfs_rdata_mempool,  &SLAB_NOFS);  &if ( &p) {  &memset( &p, 0, $sizeof{ &p});  &INIT_LIST_HEAD( ($p->{pages}));  &if ( &pagecount <  &NFS_PAGEVEC_SIZE)  ($p->{pagevec}) =  ($p->{page_array[0]});  &else { \'size_t\'  &size = ++ &pagecount * $sizeof{\'struct page\' };  ($p->{pagevec}) =  &kmalloc( &size,  &GFP_NOFS);  &if ( ($p->{pagevec})) {  &memset( ($p->{pagevec}), 0,  &size); }  &else {  &mempool_free( &p,  &nfs_rdata_mempool);  &p =  &NULL; } } }  &p; });
	}' unless defined(&nfs_read_data);
	eval 'sub nfs_readdata_free {
	    my($p) = @_;
    	    eval q({  &if ($p  && ( ($p->{pagevec}) !=  ($p->{page_array[0]})))  &kfree( ($p->{pagevec}));  &mempool_free($p,  &nfs_rdata_mempool); });
	}' unless defined(&nfs_readdata_free);
	if(defined(&CONFIG_NFS_V3_ACL)) {
	} else {
	    eval 'sub nfs3_proc_set_default_acl {
	        my($dir,$inode,$mode) = @_;
    		eval q({ 0; });
	    }' unless defined(&nfs3_proc_set_default_acl);
	    eval 'sub nfs3_forget_cached_acls {
	        my($inode) = @_;
    		eval q({ });
	    }' unless defined(&nfs3_forget_cached_acls);
	}
	eval 'sub nfs_fileid_to_ino_t {
	    my($fileid) = @_;
    	    eval q({  &ino_t  &ino = ( &ino_t) $fileid;  &if ($sizeof{ &ino_t} < $sizeof{ &u64})  &ino ^= $fileid >> ($sizeof{ &u64}-$sizeof{ &ino_t}) * 8;  &ino; });
	}' unless defined(&nfs_fileid_to_ino_t);
	eval 'sub nfs_wait_event {
	    my($clnt, $wq, $condition) = @_;
    	    eval q(({ \'int\'  &__retval = 0;  &if ( ($clnt->{cl_intr})) {  &sigset_t  &oldmask;  &rpc_clnt_sigmask($clnt,  &oldmask);  &__retval =  &wait_event_interruptible($wq, $condition);  &rpc_clnt_sigunmask($clnt,  &oldmask); }  &else  &wait_event($wq, $condition);  &__retval; }));
	}' unless defined(&nfs_wait_event);
	eval 'sub NFS_JUKEBOX_RETRY_TIME {(5*  &HZ);}' unless defined(&NFS_JUKEBOX_RETRY_TIME);
    }
    eval 'sub NFSDBG_VFS {0x1;}' unless defined(&NFSDBG_VFS);
    eval 'sub NFSDBG_DIRCACHE {0x2;}' unless defined(&NFSDBG_DIRCACHE);
    eval 'sub NFSDBG_LOOKUPCACHE {0x4;}' unless defined(&NFSDBG_LOOKUPCACHE);
    eval 'sub NFSDBG_PAGECACHE {0x8;}' unless defined(&NFSDBG_PAGECACHE);
    eval 'sub NFSDBG_PROC {0x10;}' unless defined(&NFSDBG_PROC);
    eval 'sub NFSDBG_XDR {0x20;}' unless defined(&NFSDBG_XDR);
    eval 'sub NFSDBG_FILE {0x40;}' unless defined(&NFSDBG_FILE);
    eval 'sub NFSDBG_ROOT {0x80;}' unless defined(&NFSDBG_ROOT);
    eval 'sub NFSDBG_CALLBACK {0x100;}' unless defined(&NFSDBG_CALLBACK);
    eval 'sub NFSDBG_ALL {0xffff;}' unless defined(&NFSDBG_ALL);
    if(defined(&__KERNEL__)) {
	undef(&ifdebug) if defined(&ifdebug);
	if(defined(&NFS_DEBUG)) {
	    eval 'sub ifdebug {
	        my($fac) = @_;
    		eval q( &if ( &unlikely( &nfs_debug &  &NFSDBG_$fac)));
	    }' unless defined(&ifdebug);
	} else {
	    eval 'sub ifdebug {
	        my($fac) = @_;
    		eval q( &if (0));
	    }' unless defined(&ifdebug);
	}
    }
}
1;
