require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_NFS_PAGE_H)) {
    eval 'sub _LINUX_NFS_PAGE_H {1;}' unless defined(&_LINUX_NFS_PAGE_H);
    require 'linux/list.ph';
    require 'linux/pagemap.ph';
    require 'linux/wait.ph';
    require 'linux/nfs_fs_sb.ph';
    require 'linux/sunrpc/auth.ph';
    require 'linux/nfs_xdr.ph';
    require 'asm/atomic.ph';
    eval 'sub NFS_PAGE_TAG_DIRTY {0;}' unless defined(&NFS_PAGE_TAG_DIRTY);
    eval 'sub NFS_PAGE_TAG_WRITEBACK {1;}' unless defined(&NFS_PAGE_TAG_WRITEBACK);
    eval 'sub PG_BUSY {0;}' unless defined(&PG_BUSY);
    eval 'sub PG_NEED_COMMIT {1;}' unless defined(&PG_NEED_COMMIT);
    eval 'sub PG_NEED_RESCHED {2;}' unless defined(&PG_NEED_RESCHED);
    eval 'sub NFS_WBACK_BUSY {
        my($req) = @_;
	    eval q(( &test_bit( &PG_BUSY,($req)-> &wb_flags)));
    }' unless defined(&NFS_WBACK_BUSY);
    eval 'sub NFS_NEED_COMMIT {
        my($req) = @_;
	    eval q(( &test_bit( &PG_NEED_COMMIT,($req)-> &wb_flags)));
    }' unless defined(&NFS_NEED_COMMIT);
    eval 'sub NFS_NEED_RESCHED {
        my($req) = @_;
	    eval q(( &test_bit( &PG_NEED_RESCHED,($req)-> &wb_flags)));
    }' unless defined(&NFS_NEED_RESCHED);
    eval 'sub nfs_defer_commit {
        my($req) = @_;
	    eval q({ ! &test_and_set_bit( &PG_NEED_COMMIT,  ($req->{wb_flags})); });
    }' unless defined(&nfs_defer_commit);
    eval 'sub nfs_clear_commit {
        my($req) = @_;
	    eval q({  &smp_mb__before_clear_bit();  &clear_bit( &PG_NEED_COMMIT,  ($req->{wb_flags}));  &smp_mb__after_clear_bit(); });
    }' unless defined(&nfs_clear_commit);
    eval 'sub nfs_defer_reschedule {
        my($req) = @_;
	    eval q({ ! &test_and_set_bit( &PG_NEED_RESCHED,  ($req->{wb_flags})); });
    }' unless defined(&nfs_defer_reschedule);
    eval 'sub nfs_clear_reschedule {
        my($req) = @_;
	    eval q({  &smp_mb__before_clear_bit();  &clear_bit( &PG_NEED_RESCHED,  ($req->{wb_flags}));  &smp_mb__after_clear_bit(); });
    }' unless defined(&nfs_clear_reschedule);
    eval 'sub nfs_list_entry {
        my($head) = @_;
	    eval q({  &list_entry($head, \'struct nfs_page\',  &wb_list); });
    }' unless defined(&nfs_list_entry);
}
1;
