require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&LINUX_PCI_H)) {
    eval 'sub LINUX_PCI_H {1;}' unless defined(&LINUX_PCI_H);
    if(defined(&__KERNEL__)) {
	require 'linux/mod_devicetable.ph';
    }
    require 'linux/pci_regs.ph';
    require 'linux/pci_ids.ph';
    eval 'sub PCI_DEVFN {
        my($slot,$func) = @_;
	    eval q((((($slot) & 0x1f) << 3) | (($func) & 0x7)));
    }' unless defined(&PCI_DEVFN);
    eval 'sub PCI_SLOT {
        my($devfn) = @_;
	    eval q(((($devfn) >> 3) & 0x1f));
    }' unless defined(&PCI_SLOT);
    eval 'sub PCI_FUNC {
        my($devfn) = @_;
	    eval q((($devfn) & 0x7));
    }' unless defined(&PCI_FUNC);
    eval 'sub PCIIOC_BASE {(ord(\'P\' << 24 | \'C\' << 16 | \'I\') << 8);}' unless defined(&PCIIOC_BASE);
    eval 'sub PCIIOC_CONTROLLER {( &PCIIOC_BASE | 0x);}' unless defined(&PCIIOC_CONTROLLER);
    eval 'sub PCIIOC_MMAP_IS_IO {( &PCIIOC_BASE | 0x1);}' unless defined(&PCIIOC_MMAP_IS_IO);
    eval 'sub PCIIOC_MMAP_IS_MEM {( &PCIIOC_BASE | 0x2);}' unless defined(&PCIIOC_MMAP_IS_MEM);
    eval 'sub PCIIOC_WRITE_COMBINE {( &PCIIOC_BASE | 0x3);}' unless defined(&PCIIOC_WRITE_COMBINE);
    if(defined(&__KERNEL__)) {
	require 'linux/types.ph';
	require 'linux/config.ph';
	require 'linux/ioport.ph';
	require 'linux/list.ph';
	require 'linux/errno.ph';
	require 'linux/device.ph';
	eval("sub pci_mmap_io () { 0; }") unless defined(&pci_mmap_io);
	eval("sub pci_mmap_mem () { 1; }") unless defined(&pci_mmap_mem);
	eval 'sub PCI_DMA_BIDIRECTIONAL {0;}' unless defined(&PCI_DMA_BIDIRECTIONAL);
	eval 'sub PCI_DMA_TODEVICE {1;}' unless defined(&PCI_DMA_TODEVICE);
	eval 'sub PCI_DMA_FROMDEVICE {2;}' unless defined(&PCI_DMA_FROMDEVICE);
	eval 'sub PCI_DMA_NONE {3;}' unless defined(&PCI_DMA_NONE);
	eval 'sub DEVICE_COUNT_COMPATIBLE {4;}' unless defined(&DEVICE_COUNT_COMPATIBLE);
	eval 'sub DEVICE_COUNT_RESOURCE {12;}' unless defined(&DEVICE_COUNT_RESOURCE);
	eval 'sub PCI_D0 {(( &pci_power_t  &__force) 0);}' unless defined(&PCI_D0);
	eval 'sub PCI_D1 {(( &pci_power_t  &__force) 1);}' unless defined(&PCI_D1);
	eval 'sub PCI_D2 {(( &pci_power_t  &__force) 2);}' unless defined(&PCI_D2);
	eval 'sub PCI_D3hot {(( &pci_power_t  &__force) 3);}' unless defined(&PCI_D3hot);
	eval 'sub PCI_D3cold {(( &pci_power_t  &__force) 4);}' unless defined(&PCI_D3cold);
	eval 'sub PCI_UNKNOWN {(( &pci_power_t  &__force) 5);}' unless defined(&PCI_UNKNOWN);
	eval 'sub PCI_POWER_ERROR {(( &pci_power_t  &__force) -1);}' unless defined(&PCI_POWER_ERROR);
	eval("sub pci_channel_io_normal () { (__forcepci_channel_state_t)1; }") unless defined(&pci_channel_io_normal);
	eval("sub pci_channel_io_frozen () { (__forcepci_channel_state_t)2; }") unless defined(&pci_channel_io_frozen);
	eval("sub pci_channel_io_perm_failure () { (__forcepci_channel_state_t)3; }") unless defined(&pci_channel_io_perm_failure);
	eval 'sub pci_dev_g {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct pci_dev\',  &global_list));
	}' unless defined(&pci_dev_g);
	eval 'sub pci_dev_b {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct pci_dev\',  &bus_list));
	}' unless defined(&pci_dev_b);
	eval 'sub to_pci_dev {
	    my($n) = @_;
    	    eval q( &container_of($n, \'struct pci_dev\',  &dev));
	}' unless defined(&to_pci_dev);
	eval 'sub for_each_pci_dev {
	    my($d) = @_;
    	    eval q( &while (($d =  &pci_get_device( &PCI_ANY_ID,  &PCI_ANY_ID, $d)) !=  &NULL));
	}' unless defined(&for_each_pci_dev);
	eval 'sub PCI_ROM_RESOURCE {6;}' unless defined(&PCI_ROM_RESOURCE);
	eval 'sub PCI_BRIDGE_RESOURCES {7;}' unless defined(&PCI_BRIDGE_RESOURCES);
	eval 'sub PCI_NUM_RESOURCES {11;}' unless defined(&PCI_NUM_RESOURCES);
	unless(defined(&PCI_BUS_NUM_RESOURCES)) {
	    eval 'sub PCI_BUS_NUM_RESOURCES {8;}' unless defined(&PCI_BUS_NUM_RESOURCES);
	}
	eval 'sub PCI_REGION_FLAG_MASK {0xf;}' unless defined(&PCI_REGION_FLAG_MASK);
	eval 'sub pci_bus_b {
	    my($n) = @_;
    	    eval q( &list_entry($n, \'struct pci_bus\',  &node));
	}' unless defined(&pci_bus_b);
	eval 'sub to_pci_bus {
	    my($n) = @_;
    	    eval q( &container_of($n, \'struct pci_bus\',  &class_dev));
	}' unless defined(&to_pci_bus);
	eval 'sub PCIBIOS_SUCCESSFUL {0x;}' unless defined(&PCIBIOS_SUCCESSFUL);
	eval 'sub PCIBIOS_FUNC_NOT_SUPPORTED {0x81;}' unless defined(&PCIBIOS_FUNC_NOT_SUPPORTED);
	eval 'sub PCIBIOS_BAD_VENDOR_ID {0x83;}' unless defined(&PCIBIOS_BAD_VENDOR_ID);
	eval 'sub PCIBIOS_DEVICE_NOT_FOUND {0x86;}' unless defined(&PCIBIOS_DEVICE_NOT_FOUND);
	eval 'sub PCIBIOS_BAD_REGISTER_NUMBER {0x87;}' unless defined(&PCIBIOS_BAD_REGISTER_NUMBER);
	eval 'sub PCIBIOS_SET_FAILED {0x88;}' unless defined(&PCIBIOS_SET_FAILED);
	eval 'sub PCIBIOS_BUFFER_TOO_SMALL {0x89;}' unless defined(&PCIBIOS_BUFFER_TOO_SMALL);
	eval("sub PCI_ERS_RESULT_NONE () { (__forcepci_ers_result_t)1; }") unless defined(&PCI_ERS_RESULT_NONE);
	eval("sub PCI_ERS_RESULT_CAN_RECOVER () { (__forcepci_ers_result_t)2; }") unless defined(&PCI_ERS_RESULT_CAN_RECOVER);
	eval("sub PCI_ERS_RESULT_NEED_RESET () { (__forcepci_ers_result_t)3; }") unless defined(&PCI_ERS_RESULT_NEED_RESET);
	eval("sub PCI_ERS_RESULT_DISCONNECT () { (__forcepci_ers_result_t)4; }") unless defined(&PCI_ERS_RESULT_DISCONNECT);
	eval("sub PCI_ERS_RESULT_RECOVERED () { (__forcepci_ers_result_t)5; }") unless defined(&PCI_ERS_RESULT_RECOVERED);
	eval 'sub to_pci_driver {
	    my($drv) = @_;
    	    eval q( &container_of($drv,\'struct pci_driver\',  &driver));
	}' unless defined(&to_pci_driver);
	eval 'sub PCI_DEVICE {
	    my($vend,$dev) = @_;
    	    eval q(. &vendor = ($vend), . &device = ($dev), . &subvendor =  &PCI_ANY_ID, . &subdevice =  &PCI_ANY_ID);
	}' unless defined(&PCI_DEVICE);
	eval 'sub PCI_DEVICE_CLASS {
	    my($dev_class,$dev_class_mask) = @_;
    	    eval q(. &class = ($dev_class), . &class_mask = ($dev_class_mask), . &vendor =  &PCI_ANY_ID, . &device =  &PCI_ANY_ID, . &subvendor =  &PCI_ANY_ID, . &subdevice =  &PCI_ANY_ID);
	}' unless defined(&PCI_DEVICE_CLASS);
	eval 'sub pci_module_init { &pci_register_driver;}' unless defined(&pci_module_init);
	if(defined(&CONFIG_PCI)) {
	    eval 'sub pci_bus {
	        eval q(* &pci_scan_bus(\'int\'  &bus, \'struct pci_ops\' * &ops,  &void * &sysdata) { \'struct pci_bus\' * &root_bus;  &root_bus =  &pci_scan_bus_parented( &NULL,  &bus,  &ops,  &sysdata);  &if ( &root_bus)  &pci_bus_add_devices( &root_bus);  &root_bus; });
	    }' unless defined(&pci_bus);
	    eval 'sub pci_read_config_byte {
	        my($dev,$where,$val) = @_;
    		eval q({  &pci_bus_read_config_byte ( ($dev->{bus}),  ($dev->{devfn}), $where, $val); });
	    }' unless defined(&pci_read_config_byte);
	    eval 'sub pci_read_config_word {
	        my($dev,$where,$val) = @_;
    		eval q({  &pci_bus_read_config_word ( ($dev->{bus}),  ($dev->{devfn}), $where, $val); });
	    }' unless defined(&pci_read_config_word);
	    eval 'sub pci_read_config_dword {
	        my($dev,$where,$val) = @_;
    		eval q({  &pci_bus_read_config_dword ( ($dev->{bus}),  ($dev->{devfn}), $where, $val); });
	    }' unless defined(&pci_read_config_dword);
	    eval 'sub pci_write_config_byte {
	        my($dev,$where,$val) = @_;
    		eval q({  &pci_bus_write_config_byte ( ($dev->{bus}),  ($dev->{devfn}), $where, $val); });
	    }' unless defined(&pci_write_config_byte);
	    eval 'sub pci_write_config_word {
	        my($dev,$where,$val) = @_;
    		eval q({  &pci_bus_write_config_word ( ($dev->{bus}),  ($dev->{devfn}), $where, $val); });
	    }' unless defined(&pci_write_config_word);
	    eval 'sub pci_write_config_dword {
	        my($dev,$where,$val) = @_;
    		eval q({  &pci_bus_write_config_dword ( ($dev->{bus}),  ($dev->{devfn}), $where, $val); });
	    }' unless defined(&pci_write_config_dword);
	    eval 'sub HAVE_PCI_SET_MWI {1;}' unless defined(&HAVE_PCI_SET_MWI);
	    eval 'sub HAVE_PCI_REQ_REGIONS {2;}' unless defined(&HAVE_PCI_REQ_REGIONS);
	    eval 'sub pci_register_driver {
	        my($driver) = @_;
    		eval q({  &__pci_register_driver($driver,  &THIS_MODULE); });
	    }' unless defined(&pci_register_driver);
	    require 'linux/dmapool.ph';
	    eval 'sub pci_pool { &dma_pool;}' unless defined(&pci_pool);
	    eval 'sub pci_pool_create {
	        my($name, $pdev, $size, $align, $allocation) = @_;
    		eval q( &dma_pool_create($name,  ($pdev->{dev}), $size, $align, $allocation));
	    }' unless defined(&pci_pool_create);
	    eval 'sub pci_pool_destroy {
	        my($pool) = @_;
    		eval q( &dma_pool_destroy($pool));
	    }' unless defined(&pci_pool_destroy);
	    eval 'sub pci_pool_alloc {
	        my($pool, $flags, $handle) = @_;
    		eval q( &dma_pool_alloc($pool, $flags, $handle));
	    }' unless defined(&pci_pool_alloc);
	    eval 'sub pci_pool_free {
	        my($pool, $vaddr, $addr) = @_;
    		eval q( &dma_pool_free($pool, $vaddr, $addr));
	    }' unless defined(&pci_pool_free);
	    eval("sub PCI_DMA_BURST_INFINITY () { 0; }") unless defined(&PCI_DMA_BURST_INFINITY);
	    eval("sub PCI_DMA_BURST_BOUNDARY () { 1; }") unless defined(&PCI_DMA_BURST_BOUNDARY);
	    eval("sub PCI_DMA_BURST_MULTIPLE () { 2; }") unless defined(&PCI_DMA_BURST_MULTIPLE);
	    if(defined( &CONFIG_ISA) || defined( &CONFIG_EISA)) {
	    }
	    unless(defined(&CONFIG_PCI_MSI)) {
	    } else {
	    }
	    unless(defined(&CONFIG_PCI_DOMAINS)) {
	    }
	} else {
	    eval 'sub _PCI_NOP {
	        my($o,$s,$t) = @_;
    		eval q( &static  &inline \'int\'  &pci_$o &_config_$s (\'struct pci_dev\' * &dev, \'int\'  &where, $t  &val) {  &return  &PCIBIOS_FUNC_NOT_SUPPORTED; });
	    }' unless defined(&_PCI_NOP);
	    eval 'sub _PCI_NOP_ALL {
	        my($o,$x) = @_;
    		eval q( &_PCI_NOP($o, &byte, &u8 $x)  &_PCI_NOP($o, &word, &u16 $x)  &_PCI_NOP($o, &dword, &u32 $x));
	    }' unless defined(&_PCI_NOP_ALL);
	    eval 'sub pci_dev {
	        eval q(* &pci_find_device(my $vendor, my $device,  &const \'struct pci_dev\' * &from) {  &NULL; });
	    }' unless defined(&pci_dev);
	    eval 'sub pci_dev {
	        eval q(* &pci_find_slot(my $bus, my $devfn) {  &NULL; });
	    }' unless defined(&pci_dev);
	    eval 'sub pci_dev {
	        eval q(* &pci_get_device (my $vendor, my $device, \'struct pci_dev\' * &from) {  &NULL; });
	    }' unless defined(&pci_dev);
	    eval 'sub pci_dev {
	        eval q(* &pci_get_subsys (my $vendor, my $device, my $ss_vendor, my $ss_device, \'struct pci_dev\' * &from) {  &NULL; });
	    }' unless defined(&pci_dev);
	    eval 'sub pci_dev {
	        eval q(* &pci_get_class(my $class, \'struct pci_dev\' * &from) {  &NULL; });
	    }' unless defined(&pci_dev);
	    eval 'sub pci_dev_present {
	        my($ids) = @_;
    		eval q((0));
	    }' unless defined(&pci_dev_present);
	    eval 'sub pci_dev_put {
	        my($dev) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&pci_dev_put);
	}
	require 'asm/pci.ph';
	eval 'sub pci_resource_start {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($resource[&(bar)]->{start})));
	}' unless defined(&pci_resource_start);
	eval 'sub pci_resource_end {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($resource[&(bar)]->{end})));
	}' unless defined(&pci_resource_end);
	eval 'sub pci_resource_flags {
	    my($dev,$bar) = @_;
    	    eval q((($dev)-> ($resource[&(bar)]->{flags})));
	}' unless defined(&pci_resource_flags);
	eval 'sub pci_resource_len {
	    my($dev,$bar) = @_;
    	    eval q((( &pci_resource_start(($dev),($bar)) == 0 &&  &pci_resource_end(($dev),($bar)) ==  &pci_resource_start(($dev),($bar))) ? 0: ( &pci_resource_end(($dev),($bar)) -  &pci_resource_start(($dev),($bar)) + 1)));
	}' unless defined(&pci_resource_len);
	eval 'sub pci_set_drvdata {
	    my($pdev,$data) = @_;
    	    eval q({  &dev_set_drvdata( ($pdev->{dev}), $data); });
	}' unless defined(&pci_set_drvdata);
	unless(defined(&HAVE_ARCH_PCI_RESOURCE_TO_USER)) {
	    eval 'sub pci_resource_to_user {
	        my($dev,$bar,$rsrc,$start,$end) = @_;
    		eval q({ *$start =  ($rsrc->{start}); *$end =  ($rsrc->{end}); });
	    }' unless defined(&pci_resource_to_user);
	}
	eval("sub pci_fixup_early () { 0; }") unless defined(&pci_fixup_early);
	eval("sub pci_fixup_header () { 1; }") unless defined(&pci_fixup_header);
	eval("sub pci_fixup_final () { 2; }") unless defined(&pci_fixup_final);
	eval("sub pci_fixup_enable () { 3; }") unless defined(&pci_fixup_enable);
	eval 'sub DECLARE_PCI_FIXUP_SECTION {
	    my($section, $name, $vendor, $device, $hook) = @_;
    	    eval q( &static  &const \'struct pci_fixup\'  &__pci_fixup_$name  &__attribute_used__  &__attribute__(( &__section__($section))) = { $vendor, $device, $hook };);
	}' unless defined(&DECLARE_PCI_FIXUP_SECTION);
	eval 'sub DECLARE_PCI_FIXUP_EARLY {
	    my($vendor, $device, $hook) = @_;
    	    eval q( &DECLARE_PCI_FIXUP_SECTION(. &pci_fixup_early, $vendor$device$hook, $vendor, $device, $hook));
	}' unless defined(&DECLARE_PCI_FIXUP_EARLY);
	eval 'sub DECLARE_PCI_FIXUP_HEADER {
	    my($vendor, $device, $hook) = @_;
    	    eval q( &DECLARE_PCI_FIXUP_SECTION(. &pci_fixup_header, $vendor$device$hook, $vendor, $device, $hook));
	}' unless defined(&DECLARE_PCI_FIXUP_HEADER);
	eval 'sub DECLARE_PCI_FIXUP_FINAL {
	    my($vendor, $device, $hook) = @_;
    	    eval q( &DECLARE_PCI_FIXUP_SECTION(. &pci_fixup_final, $vendor$device$hook, $vendor, $device, $hook));
	}' unless defined(&DECLARE_PCI_FIXUP_FINAL);
	eval 'sub DECLARE_PCI_FIXUP_ENABLE {
	    my($vendor, $device, $hook) = @_;
    	    eval q( &DECLARE_PCI_FIXUP_SECTION(. &pci_fixup_enable, $vendor$device$hook, $vendor, $device, $hook));
	}' unless defined(&DECLARE_PCI_FIXUP_ENABLE);
	eval 'sub PCIPCI_FAIL {1;}' unless defined(&PCIPCI_FAIL);
	eval 'sub PCIPCI_TRITON {2;}' unless defined(&PCIPCI_TRITON);
	eval 'sub PCIPCI_NATOMA {4;}' unless defined(&PCIPCI_NATOMA);
	eval 'sub PCIPCI_VIAETBF {8;}' unless defined(&PCIPCI_VIAETBF);
	eval 'sub PCIPCI_VSFX {16;}' unless defined(&PCIPCI_VSFX);
	eval 'sub PCIPCI_ALIMAGIK {32;}' unless defined(&PCIPCI_ALIMAGIK);
    }
}
1;
