require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_PERCPU_H)) {
    eval 'sub __LINUX_PERCPU_H {1;}' unless defined(&__LINUX_PERCPU_H);
    if(defined(&__KERNEL__)) {
	require 'linux/spinlock.ph';
	require 'linux/slab.ph';
	require 'linux/smp.ph';
	require 'linux/string.ph';
	require 'asm/percpu.ph';
	unless(defined(&PERCPU_ENOUGH_ROOM)) {
	    eval 'sub PERCPU_ENOUGH_ROOM {32768;}' unless defined(&PERCPU_ENOUGH_ROOM);
	}
	eval 'sub get_cpu_var {
	    my($var) = @_;
    	    eval q((*({  &preempt_disable(); & &__get_cpu_var($var); })));
	}' unless defined(&get_cpu_var);
	eval 'sub put_cpu_var {
	    my($var) = @_;
    	    eval q( &preempt_enable());
	}' unless defined(&put_cpu_var);
	if(defined(&CONFIG_SMP)) {
	    eval 'sub per_cpu_ptr {
	        my($ptr, $cpu) = @_;
    		eval q(({ \'struct percpu_data\' * &__p = ~($ptr); ( &__typeof__($ptr)) ($__p->{ptrs[&(cpu)]}); }));
	    }' unless defined(&per_cpu_ptr);
	} else {
	    eval 'sub per_cpu_ptr {
	        my($ptr, $cpu) = @_;
    		eval q(({ ( &void)($cpu); ($ptr); }));
	    }' unless defined(&per_cpu_ptr);
	    eval 'sub void {
	        eval q(* &__alloc_percpu(\'size_t\'  &size) {  &void * &ret =  &kmalloc( &size,  &GFP_KERNEL);  &if ( &ret)  &memset( &ret, 0,  &size);  &ret; });
	    }' unless defined(&void);
	    eval 'sub free_percpu {
	        my($ptr) = @_;
    		eval q({  &kfree($ptr); });
	    }' unless defined(&free_percpu);
	}
	eval 'sub alloc_percpu {
	    my($type) = @_;
    	    eval q((($type *)( &__alloc_percpu($sizeof{$type}))));
	}' unless defined(&alloc_percpu);
    }
}
1;
