require '_h2ph_pre.ph';

no warnings 'redefine';

require 'linux/config.ph';
unless(defined(&PMU_DRIVER_VERSION)) {
    sub PMU_DRIVER_VERSION () {	2;}
}
unless(defined(&PMU_POWER_CTRL0)) {
    sub PMU_POWER_CTRL0 () {	0x10;}
}
unless(defined(&PMU_POWER_CTRL)) {
    sub PMU_POWER_CTRL () {	0x11;}
}
unless(defined(&PMU_ADB_CMD)) {
    sub PMU_ADB_CMD () {	0x20;}
}
unless(defined(&PMU_ADB_POLL_OFF)) {
    sub PMU_ADB_POLL_OFF () {	0x21;}
}
unless(defined(&PMU_WRITE_NVRAM)) {
    sub PMU_WRITE_NVRAM () {	0x33;}
}
unless(defined(&PMU_READ_NVRAM)) {
    sub PMU_READ_NVRAM () {	0x3b;}
}
unless(defined(&PMU_SET_RTC)) {
    sub PMU_SET_RTC () {	0x30;}
}
unless(defined(&PMU_READ_RTC)) {
    sub PMU_READ_RTC () {	0x38;}
}
unless(defined(&PMU_SET_VOLBUTTON)) {
    sub PMU_SET_VOLBUTTON () {	0x40;}
}
unless(defined(&PMU_BACKLIGHT_BRIGHT)) {
    sub PMU_BACKLIGHT_BRIGHT () {	0x41;}
}
unless(defined(&PMU_GET_VOLBUTTON)) {
    sub PMU_GET_VOLBUTTON () {	0x48;}
}
unless(defined(&PMU_PCEJECT)) {
    sub PMU_PCEJECT () {	0x4c;}
}
unless(defined(&PMU_BATTERY_STATE)) {
    sub PMU_BATTERY_STATE () {	0x6b;}
}
unless(defined(&PMU_SMART_BATTERY_STATE)) {
    sub PMU_SMART_BATTERY_STATE () {	0x6f;}
}
unless(defined(&PMU_SET_INTR_MASK)) {
    sub PMU_SET_INTR_MASK () {	0x70;}
}
unless(defined(&PMU_INT_ACK)) {
    sub PMU_INT_ACK () {	0x78;}
}
unless(defined(&PMU_SHUTDOWN)) {
    sub PMU_SHUTDOWN () {	0x7e;}
}
unless(defined(&PMU_CPU_SPEED)) {
    sub PMU_CPU_SPEED () {	0x7d;}
}
unless(defined(&PMU_SLEEP)) {
    sub PMU_SLEEP () {	0x7f;}
}
unless(defined(&PMU_POWER_EVENTS)) {
    sub PMU_POWER_EVENTS () {	0x8f;}
}
unless(defined(&PMU_I2C_CMD)) {
    sub PMU_I2C_CMD () {	0x9a;}
}
unless(defined(&PMU_RESET)) {
    sub PMU_RESET () {	0xd0;}
}
unless(defined(&PMU_GET_BRIGHTBUTTON)) {
    sub PMU_GET_BRIGHTBUTTON () {	0xd9;}
}
unless(defined(&PMU_GET_COVER)) {
    sub PMU_GET_COVER () {	0xdc;}
}
unless(defined(&PMU_SYSTEM_READY)) {
    sub PMU_SYSTEM_READY () {	0xdf;}
}
unless(defined(&PMU_GET_VERSION)) {
    sub PMU_GET_VERSION () {	0xea;}
}
unless(defined(&PMU_POW0_ON)) {
    sub PMU_POW0_ON () {	0x80;}
}
unless(defined(&PMU_POW0_OFF)) {
    sub PMU_POW0_OFF () {	0x;}
}
unless(defined(&PMU_POW0_HARD_DRIVE)) {
    sub PMU_POW0_HARD_DRIVE () {	0x4;}
}
unless(defined(&PMU_POW_ON)) {
    sub PMU_POW_ON () {	0x80;}
}
unless(defined(&PMU_POW_OFF)) {
    sub PMU_POW_OFF () {	0x;}
}
unless(defined(&PMU_POW_BACKLIGHT)) {
    sub PMU_POW_BACKLIGHT () {	0x1;}
}
unless(defined(&PMU_POW_CHARGER)) {
    sub PMU_POW_CHARGER () {	0x2;}
}
unless(defined(&PMU_POW_IRLED)) {
    sub PMU_POW_IRLED () {	0x4;}
}
unless(defined(&PMU_POW_MEDIABAY)) {
    sub PMU_POW_MEDIABAY () {	0x8;}
}
unless(defined(&PMU_INT_PCEJECT)) {
    sub PMU_INT_PCEJECT () {	0x4;}
}
unless(defined(&PMU_INT_SNDBRT)) {
    sub PMU_INT_SNDBRT () {	0x8;}
}
unless(defined(&PMU_INT_ADB)) {
    sub PMU_INT_ADB () {	0x10;}
}
unless(defined(&PMU_INT_BATTERY)) {
    sub PMU_INT_BATTERY () {	0x20;}
}
unless(defined(&PMU_INT_ENVIRONMENT)) {
    sub PMU_INT_ENVIRONMENT () {	0x40;}
}
unless(defined(&PMU_INT_TICK)) {
    sub PMU_INT_TICK () {	0x80;}
}
unless(defined(&PMU_INT_ADB_AUTO)) {
    sub PMU_INT_ADB_AUTO () {	0x4;}
}
unless(defined(&PMU_INT_WAITING_CHARGER)) {
    sub PMU_INT_WAITING_CHARGER () {	0x1;}
}
unless(defined(&PMU_INT_AUTO_SRQ_POLL)) {
    sub PMU_INT_AUTO_SRQ_POLL () {	0x2;}
}
unless(defined(&PMU_ENV_LID_CLOSED)) {
    sub PMU_ENV_LID_CLOSED () {	0x1;}
}
unless(defined(&PMU_I2C_MODE_SIMPLE)) {
    sub PMU_I2C_MODE_SIMPLE () {	0;}
}
unless(defined(&PMU_I2C_MODE_STDSUB)) {
    sub PMU_I2C_MODE_STDSUB () {	1;}
}
unless(defined(&PMU_I2C_MODE_COMBINED)) {
    sub PMU_I2C_MODE_COMBINED () {	2;}
}
unless(defined(&PMU_I2C_BUS_STATUS)) {
    sub PMU_I2C_BUS_STATUS () {	0;}
}
unless(defined(&PMU_I2C_BUS_SYSCLK)) {
    sub PMU_I2C_BUS_SYSCLK () {	1;}
}
unless(defined(&PMU_I2C_BUS_POWER)) {
    sub PMU_I2C_BUS_POWER () {	2;}
}
unless(defined(&PMU_I2C_STATUS_OK)) {
    sub PMU_I2C_STATUS_OK () {	0;}
}
unless(defined(&PMU_I2C_STATUS_DATAREAD)) {
    sub PMU_I2C_STATUS_DATAREAD () {	1;}
}
unless(defined(&PMU_I2C_STATUS_BUSY)) {
    sub PMU_I2C_STATUS_BUSY () {	0xfe;}
}
eval("sub PMU_UNKNOWN () { 0; }") unless defined(&PMU_UNKNOWN);
eval("sub PMU_OHARE_BASED () { 1; }") unless defined(&PMU_OHARE_BASED);
eval("sub PMU_HEATHROW_BASED () { 2; }") unless defined(&PMU_HEATHROW_BASED);
eval("sub PMU_PADDINGTON_BASED () { 3; }") unless defined(&PMU_PADDINGTON_BASED);
eval("sub PMU_KEYLARGO_BASED () { 4; }") unless defined(&PMU_KEYLARGO_BASED);
eval("sub PMU_68K_V1 () { 5; }") unless defined(&PMU_68K_V1);
eval("sub PMU_68K_V2 () { 6; }") unless defined(&PMU_68K_V2);
eval("sub PMU_PWR_GET_POWERUP_EVENTS () { 0x00; }") unless defined(&PMU_PWR_GET_POWERUP_EVENTS);
eval("sub PMU_PWR_SET_POWERUP_EVENTS () { 0x01; }") unless defined(&PMU_PWR_SET_POWERUP_EVENTS);
eval("sub PMU_PWR_CLR_POWERUP_EVENTS () { 0x02; }") unless defined(&PMU_PWR_CLR_POWERUP_EVENTS);
eval("sub PMU_PWR_GET_WAKEUP_EVENTS () { 0x03; }") unless defined(&PMU_PWR_GET_WAKEUP_EVENTS);
eval("sub PMU_PWR_SET_WAKEUP_EVENTS () { 0x04; }") unless defined(&PMU_PWR_SET_WAKEUP_EVENTS);
eval("sub PMU_PWR_CLR_WAKEUP_EVENTS () { 0x05; }") unless defined(&PMU_PWR_CLR_WAKEUP_EVENTS);
eval("sub PMU_PWR_WAKEUP_KEY () { 0x01; }") unless defined(&PMU_PWR_WAKEUP_KEY);
eval("sub PMU_PWR_WAKEUP_AC_INSERT () { 0x02; }") unless defined(&PMU_PWR_WAKEUP_AC_INSERT);
eval("sub PMU_PWR_WAKEUP_AC_CHANGE () { 0x04; }") unless defined(&PMU_PWR_WAKEUP_AC_CHANGE);
eval("sub PMU_PWR_WAKEUP_LID_OPEN () { 0x08; }") unless defined(&PMU_PWR_WAKEUP_LID_OPEN);
eval("sub PMU_PWR_WAKEUP_RING () { 0x10; }") unless defined(&PMU_PWR_WAKEUP_RING);
require 'linux/ioctl.ph';
unless(defined(&PMU_IOC_SLEEP)) {
    sub PMU_IOC_SLEEP () {	 &_IO(ord('B'), 0);}
}
unless(defined(&PMU_IOC_GET_BACKLIGHT)) {
    sub PMU_IOC_GET_BACKLIGHT () {	 &_IOR(ord('B'), 1, 'size_t');}
}
unless(defined(&PMU_IOC_SET_BACKLIGHT)) {
    sub PMU_IOC_SET_BACKLIGHT () {	 &_IOW(ord('B'), 2, 'size_t');}
}
unless(defined(&PMU_IOC_GET_MODEL)) {
    sub PMU_IOC_GET_MODEL () {	 &_IOR(ord('B'), 3, 'size_t');}
}
unless(defined(&PMU_IOC_HAS_ADB)) {
    sub PMU_IOC_HAS_ADB () {	 &_IOR(ord('B'), 4, 'size_t');}
}
unless(defined(&PMU_IOC_CAN_SLEEP)) {
    sub PMU_IOC_CAN_SLEEP () {	 &_IOR(ord('B'), 5, 'size_t');}
}
unless(defined(&PMU_IOC_GRAB_BACKLIGHT)) {
    sub PMU_IOC_GRAB_BACKLIGHT () {	 &_IOR(ord('B'), 6, 'size_t');}
}
if(defined(&__KERNEL__)) {
    if(defined(&CONFIG_PM)) {
	require 'linux/list.ph';
	eval 'sub PBOOK_SLEEP_REQUEST {1;}' unless defined(&PBOOK_SLEEP_REQUEST);
	eval 'sub PBOOK_SLEEP_NOW {2;}' unless defined(&PBOOK_SLEEP_NOW);
	eval 'sub PBOOK_SLEEP_REJECT {3;}' unless defined(&PBOOK_SLEEP_REJECT);
	eval 'sub PBOOK_WAKE {4;}' unless defined(&PBOOK_WAKE);
	eval 'sub PBOOK_SLEEP_OK {0;}' unless defined(&PBOOK_SLEEP_OK);
	eval 'sub PBOOK_SLEEP_REFUSE {-1;}' unless defined(&PBOOK_SLEEP_REFUSE);
	eval 'sub SLEEP_LEVEL_VIDEO {100;}' unless defined(&SLEEP_LEVEL_VIDEO);
	eval 'sub SLEEP_LEVEL_MEDIABAY {90;}' unless defined(&SLEEP_LEVEL_MEDIABAY);
	eval 'sub SLEEP_LEVEL_BLOCK {80;}' unless defined(&SLEEP_LEVEL_BLOCK);
	eval 'sub SLEEP_LEVEL_NET {70;}' unless defined(&SLEEP_LEVEL_NET);
	eval 'sub SLEEP_LEVEL_MISC {60;}' unless defined(&SLEEP_LEVEL_MISC);
	eval 'sub SLEEP_LEVEL_USERLAND {55;}' unless defined(&SLEEP_LEVEL_USERLAND);
	eval 'sub SLEEP_LEVEL_ADB {50;}' unless defined(&SLEEP_LEVEL_ADB);
	eval 'sub SLEEP_LEVEL_SOUND {40;}' unless defined(&SLEEP_LEVEL_SOUND);
    }
    eval 'sub PMU_MAX_BATTERIES {2;}' unless defined(&PMU_MAX_BATTERIES);
    eval 'sub PMU_PWR_AC_PRESENT {0x1;}' unless defined(&PMU_PWR_AC_PRESENT);
    eval 'sub PMU_BATT_PRESENT {0x1;}' unless defined(&PMU_BATT_PRESENT);
    eval 'sub PMU_BATT_CHARGING {0x2;}' unless defined(&PMU_BATT_CHARGING);
    eval 'sub PMU_BATT_TYPE_MASK {0xf0;}' unless defined(&PMU_BATT_TYPE_MASK);
    eval 'sub PMU_BATT_TYPE_SMART {0x10;}' unless defined(&PMU_BATT_TYPE_SMART);
    eval 'sub PMU_BATT_TYPE_HOOPER {0x20;}' unless defined(&PMU_BATT_TYPE_HOOPER);
    eval 'sub PMU_BATT_TYPE_COMET {0x30;}' unless defined(&PMU_BATT_TYPE_COMET);
}
1;
